/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.multipart;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpConstants;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.AbstractDiskHttpData;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.Attribute;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.InterfaceHttpData$HttpDataType;
import java.io.IOException;
import java.nio.charset.Charset;

public class DiskAttribute
extends AbstractDiskHttpData
implements Attribute {
    public static String baseDirectory;
    public static boolean deleteOnExitTemporaryFile;
    public static final String prefix = "Attr_";
    public static final String postfix = ".att";

    public DiskAttribute(String string) {
        this(string, HttpConstants.DEFAULT_CHARSET);
    }

    public DiskAttribute(String string, long l2) {
        this(string, l2, HttpConstants.DEFAULT_CHARSET);
    }

    public DiskAttribute(String string, Charset charset) {
        super(string, charset, 0L);
    }

    public DiskAttribute(String string, long l2, Charset charset) {
        super(string, charset, l2);
    }

    public DiskAttribute(String string, String string2) {
        this(string, string2, HttpConstants.DEFAULT_CHARSET);
    }

    public DiskAttribute(String string, String string2, Charset charset) {
        super(string, charset, 0L);
        this.setValue(string2);
    }

    @Override
    public InterfaceHttpData$HttpDataType getHttpDataType() {
        return InterfaceHttpData$HttpDataType.Attribute;
    }

    @Override
    public String getValue() {
        byte[] byArray = this.get();
        return new String(byArray, this.getCharset());
    }

    @Override
    public void setValue(String string) {
        if (string == null) {
            throw new NullPointerException("value");
        }
        byte[] byArray = string.getBytes(this.getCharset());
        this.checkSize(byArray.length);
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray);
        if (this.definedSize > 0L) {
            this.definedSize = byteBuf.readableBytes();
        }
        this.setContent(byteBuf);
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl3) {
        long l2 = this.size + (long)byteBuf.readableBytes();
        this.checkSize(l2);
        if (this.definedSize > 0L && this.definedSize < l2) {
            this.definedSize = l2;
        }
        super.addContent(byteBuf, bl3);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        return this.getName().equalsIgnoreCase(attribute.getName());
    }

    @Override
    public int compareTo(InterfaceHttpData interfaceHttpData) {
        if (!(interfaceHttpData instanceof Attribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)interfaceHttpData.getHttpDataType()));
        }
        return this.compareTo((Attribute)interfaceHttpData);
    }

    @Override
    public int compareTo(Attribute attribute) {
        return this.getName().compareToIgnoreCase(attribute.getName());
    }

    public String toString() {
        try {
            return this.getName() + '=' + this.getValue();
        }
        catch (IOException iOException) {
            return this.getName() + '=' + iOException;
        }
    }

    @Override
    protected boolean deleteOnExit() {
        return deleteOnExitTemporaryFile;
    }

    @Override
    protected String getBaseDirectory() {
        return baseDirectory;
    }

    @Override
    protected String getDiskFilename() {
        return this.getName() + postfix;
    }

    @Override
    protected String getPostfix() {
        return postfix;
    }

    @Override
    protected String getPrefix() {
        return prefix;
    }

    @Override
    public Attribute copy() {
        ByteBuf byteBuf = this.content();
        return this.replace(byteBuf != null ? byteBuf.copy() : null);
    }

    @Override
    public Attribute duplicate() {
        ByteBuf byteBuf = this.content();
        return this.replace(byteBuf != null ? byteBuf.duplicate() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attribute retainedDuplicate() {
        ByteBuf byteBuf = this.content();
        if (byteBuf != null) {
            byteBuf = byteBuf.retainedDuplicate();
            boolean bl3 = false;
            try {
                Attribute attribute = this.replace(byteBuf);
                bl3 = true;
                Attribute attribute2 = attribute;
                return attribute2;
            }
            finally {
                if (!bl3) {
                    byteBuf.release();
                }
            }
        }
        return this.replace(null);
    }

    @Override
    public Attribute replace(ByteBuf byteBuf) {
        DiskAttribute diskAttribute = new DiskAttribute(this.getName());
        diskAttribute.setCharset(this.getCharset());
        if (byteBuf != null) {
            try {
                diskAttribute.setContent(byteBuf);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
        }
        return diskAttribute;
    }

    @Override
    public Attribute retain(int n4) {
        super.retain(n4);
        return this;
    }

    @Override
    public Attribute retain() {
        super.retain();
        return this;
    }

    @Override
    public Attribute touch() {
        super.touch();
        return this;
    }

    @Override
    public Attribute touch(Object object) {
        super.touch(object);
        return this;
    }

    static {
        deleteOnExitTemporaryFile = true;
    }
}

