/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.multipart;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpConstants;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public abstract class AbstractMemoryHttpData
extends AbstractHttpData {
    private ByteBuf byteBuf;
    private int chunkPosition;

    protected AbstractMemoryHttpData(String string, Charset charset, long l2) {
        super(string, charset, l2);
    }

    @Override
    public void setContent(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("buffer");
        }
        long l2 = byteBuf.readableBytes();
        this.checkSize(l2);
        if (this.definedSize > 0L && this.definedSize < l2) {
            throw new IOException("Out of size: " + l2 + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = byteBuf;
        this.size = l2;
        this.setCompleted();
    }

    @Override
    public void setContent(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        ByteBuf byteBuf = Unpooled.buffer();
        byte[] byArray = new byte[16384];
        int n4 = inputStream.read(byArray);
        int n7 = 0;
        while (n4 > 0) {
            byteBuf.writeBytes(byArray, 0, n4);
            this.checkSize(n7 += n4);
            n4 = inputStream.read(byArray);
        }
        this.size = n7;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = byteBuf;
        this.setCompleted();
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl3) {
        if (byteBuf != null) {
            long l2 = byteBuf.readableBytes();
            this.checkSize(this.size + l2);
            if (this.definedSize > 0L && this.definedSize < this.size + l2) {
                throw new IOException("Out of size: " + (this.size + l2) + " > " + this.definedSize);
            }
            this.size += l2;
            if (this.byteBuf == null) {
                this.byteBuf = byteBuf;
            } else if (this.byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.byteBuf;
                compositeByteBuf.addComponent(true, byteBuf);
            } else {
                CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer(Integer.MAX_VALUE);
                compositeByteBuf.addComponents(true, this.byteBuf, byteBuf);
                this.byteBuf = compositeByteBuf;
            }
        }
        if (bl3) {
            this.setCompleted();
        } else if (byteBuf == null) {
            throw new NullPointerException("buffer");
        }
    }

    @Override
    public void setContent(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        long l2 = file.length();
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        this.checkSize(l2);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        byte[] byArray = new byte[(int)l2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n4 = 0;
        while ((long)n4 < l2) {
            n4 += fileChannel.read(byteBuffer);
        }
        fileChannel.close();
        fileInputStream.close();
        byteBuffer.flip();
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = Unpooled.wrappedBuffer(Integer.MAX_VALUE, byteBuffer);
        this.size = l2;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.byteBuf != null) {
            this.byteBuf.release();
            this.byteBuf = null;
        }
    }

    @Override
    public byte[] get() {
        if (this.byteBuf == null) {
            return Unpooled.EMPTY_BUFFER.array();
        }
        byte[] byArray = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.getBytes(this.byteBuf.readerIndex(), byArray);
        return byArray;
    }

    @Override
    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset charset) {
        if (this.byteBuf == null) {
            return "";
        }
        if (charset == null) {
            charset = HttpConstants.DEFAULT_CHARSET;
        }
        return this.byteBuf.toString(charset);
    }

    @Override
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    @Override
    public ByteBuf getChunk(int n4) {
        if (this.byteBuf == null || n4 == 0 || this.byteBuf.readableBytes() == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int n7 = this.byteBuf.readableBytes() - this.chunkPosition;
        if (n7 == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int n8 = n4;
        if (n7 < n4) {
            n8 = n7;
        }
        ByteBuf byteBuf = this.byteBuf.retainedSlice(this.chunkPosition, n8);
        this.chunkPosition += n8;
        return byteBuf;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public boolean renameTo(File file) {
        int n4;
        if (file == null) {
            throw new NullPointerException("dest");
        }
        if (this.byteBuf == null) {
            if (!file.createNewFile()) {
                throw new IOException("file exists already: " + file);
            }
            return true;
        }
        int n7 = this.byteBuf.readableBytes();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileChannel fileChannel = fileOutputStream.getChannel();
        if (this.byteBuf.nioBufferCount() == 1) {
            ByteBuffer byteBuffer = this.byteBuf.nioBuffer();
            for (n4 = 0; n4 < n7; n4 += fileChannel.write(byteBuffer)) {
            }
        } else {
            ByteBuffer[] byteBufferArray = this.byteBuf.nioBuffers();
            while (n4 < n7) {
                n4 = (int)((long)n4 + fileChannel.write(byteBufferArray));
            }
        }
        fileChannel.force(false);
        fileChannel.close();
        fileOutputStream.close();
        return n4 == n7;
    }

    @Override
    public File getFile() {
        throw new IOException("Not represented by a file");
    }

    @Override
    public HttpData touch() {
        return this.touch(null);
    }

    @Override
    public HttpData touch(Object object) {
        if (this.byteBuf != null) {
            this.byteBuf.touch(object);
        }
        return this;
    }
}

