/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.multipart;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpConstants;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpData;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public abstract class AbstractDiskHttpData
extends AbstractHttpData {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractDiskHttpData.class);
    private File file;
    private boolean isRenamed;
    private FileChannel fileChannel;

    protected AbstractDiskHttpData(String string, Charset charset, long l2) {
        super(string, charset, l2);
    }

    protected abstract String getDiskFilename();

    protected abstract String getPrefix();

    protected abstract String getBaseDirectory();

    protected abstract String getPostfix();

    protected abstract boolean deleteOnExit();

    private File tempFile() {
        String string = this.getDiskFilename();
        String string2 = string != null ? '_' + string : this.getPostfix();
        File file = this.getBaseDirectory() == null ? File.createTempFile(this.getPrefix(), string2) : File.createTempFile(this.getPrefix(), string2, new File(this.getBaseDirectory()));
        if (this.deleteOnExit()) {
            file.deleteOnExit();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("buffer");
        }
        try {
            this.size = byteBuf.readableBytes();
            this.checkSize(this.size);
            if (this.definedSize > 0L && this.definedSize < this.size) {
                throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
            }
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (byteBuf.readableBytes() == 0) {
                if (!this.file.createNewFile()) {
                    if (this.file.length() == 0L) {
                        return;
                    }
                    if (!this.file.delete() || !this.file.createNewFile()) {
                        throw new IOException("file exists already: " + this.file);
                    }
                }
                return;
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
                FileChannel fileChannel = fileOutputStream.getChannel();
                ByteBuffer byteBuffer = byteBuf.nioBuffer();
                int n4 = 0;
                while ((long)n4 < this.size) {
                    n4 += fileChannel.write(byteBuffer);
                }
                byteBuf.readerIndex(byteBuf.readerIndex() + n4);
                fileChannel.force(false);
            }
            this.setCompleted();
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContent(ByteBuf byteBuf, boolean bl3) {
        if (byteBuf != null) {
            try {
                int n4 = byteBuf.readableBytes();
                this.checkSize(this.size + (long)n4);
                if (this.definedSize > 0L && this.definedSize < this.size + (long)n4) {
                    throw new IOException("Out of size: " + (this.size + (long)n4) + " > " + this.definedSize);
                }
                ByteBuffer byteBuffer = byteBuf.nioBufferCount() == 1 ? byteBuf.nioBuffer() : byteBuf.copy().nioBuffer();
                int n7 = 0;
                if (this.file == null) {
                    this.file = this.tempFile();
                }
                if (this.fileChannel == null) {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                    this.fileChannel = fileOutputStream.getChannel();
                }
                while (n7 < n4) {
                    n7 += this.fileChannel.write(byteBuffer);
                }
                this.size += (long)n4;
                byteBuf.readerIndex(byteBuf.readerIndex() + n7);
            }
            finally {
                byteBuf.release();
            }
        }
        if (bl3) {
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (this.fileChannel == null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                this.fileChannel = fileOutputStream.getChannel();
            }
            this.fileChannel.force(false);
            this.fileChannel.close();
            this.fileChannel = null;
            this.setCompleted();
        } else if (byteBuf == null) {
            throw new NullPointerException("buffer");
        }
    }

    @Override
    public void setContent(File file) {
        if (this.file != null) {
            this.delete();
        }
        this.file = file;
        this.size = file.length();
        this.checkSize(this.size);
        this.isRenamed = true;
        this.setCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (this.file != null) {
            this.delete();
        }
        this.file = this.tempFile();
        int n4 = 0;
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            FileChannel fileChannel = fileOutputStream.getChannel();
            byte[] byArray = new byte[16384];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n7 = inputStream.read(byArray);
            while (n7 > 0) {
                byteBuffer.position(n7).flip();
                this.checkSize(n4 += fileChannel.write(byteBuffer));
                n7 = inputStream.read(byArray);
            }
            fileChannel.force(false);
        }
        this.size = n4;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            if (!this.file.delete()) {
                logger.warn("Failed to delete: {}", (Object)this.file);
            }
            this.file = null;
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        this.isRenamed = true;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.force(false);
                this.fileChannel.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close a file.", iOException);
            }
            this.fileChannel = null;
        }
        if (!this.isRenamed) {
            if (this.file != null && this.file.exists() && !this.file.delete()) {
                logger.warn("Failed to delete: {}", (Object)this.file);
            }
            this.file = null;
        }
    }

    @Override
    public byte[] get() {
        if (this.file == null) {
            return EmptyArrays.EMPTY_BYTES;
        }
        return AbstractDiskHttpData.readFrom(this.file);
    }

    @Override
    public ByteBuf getByteBuf() {
        if (this.file == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        byte[] byArray = AbstractDiskHttpData.readFrom(this.file);
        return Unpooled.wrappedBuffer(byArray);
    }

    @Override
    public ByteBuf getChunk(int n4) {
        int n7;
        int n8;
        if (this.file == null || n4 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (this.fileChannel == null) {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            this.fileChannel = fileInputStream.getChannel();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n4);
        for (n7 = 0; n7 < n4; n7 += n8) {
            n8 = this.fileChannel.read(byteBuffer);
            if (n8 != -1) continue;
            this.fileChannel.close();
            this.fileChannel = null;
            break;
        }
        if (n7 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        byteBuffer.flip();
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byteBuffer);
        byteBuf.readerIndex(0);
        byteBuf.writerIndex(n7);
        return byteBuf;
    }

    @Override
    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset charset) {
        if (this.file == null) {
            return "";
        }
        if (charset == null) {
            byte[] byArray = AbstractDiskHttpData.readFrom(this.file);
            return new String(byArray, HttpConstants.DEFAULT_CHARSET.name());
        }
        byte[] byArray = AbstractDiskHttpData.readFrom(this.file);
        return new String(byArray, charset.name());
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameTo(File file) {
        if (file == null) {
            throw new NullPointerException("dest");
        }
        if (this.file == null) {
            throw new IOException("No file defined so cannot be renamed");
        }
        if (!this.file.renameTo(file)) {
            long l2;
            IOException iOException = null;
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            long l10 = 8196L;
            try {
                fileInputStream = new FileInputStream(this.file);
                fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileInputStream.getChannel();
                FileChannel fileChannel2 = fileOutputStream.getChannel();
                for (l2 = 0L; l2 < this.size; l2 += fileChannel.transferTo(l2, l10, fileChannel2)) {
                    if (l10 >= this.size - l2) continue;
                    l10 = this.size - l2;
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException3) {
                        if (iOException == null) {
                            iOException = iOException3;
                        }
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", iOException3);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException4) {
                        if (iOException == null) {
                            iOException = iOException4;
                        }
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", iOException4);
                    }
                }
            }
            if (iOException != null) {
                throw iOException;
            }
            if (l2 == this.size) {
                if (!this.file.delete()) {
                    logger.warn("Failed to delete: {}", (Object)this.file);
                }
                this.file = file;
                this.isRenamed = true;
                return true;
            }
            if (!file.delete()) {
                logger.warn("Failed to delete: {}", (Object)file);
            }
            return false;
        }
        this.file = file;
        this.isRenamed = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFrom(File file) {
        long l2 = file.length();
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        byte[] byArray = new byte[(int)l2];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n4 = 0;
            while ((long)n4 < l2) {
                n4 += fileChannel.read(byteBuffer);
            }
        }
        return byArray;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public HttpData touch() {
        return this;
    }

    @Override
    public HttpData touch(Object object) {
        return this;
    }
}

