/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.cookie;

import io.grpc.netty.shaded.io.netty.handler.codec.DateFormatter;
import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.CookieEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.CookieUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.DefaultCookie;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ServerCookieEncoder
extends CookieEncoder {
    public static final ServerCookieEncoder STRICT = new ServerCookieEncoder(true);
    public static final ServerCookieEncoder LAX = new ServerCookieEncoder(false);

    private ServerCookieEncoder(boolean bl3) {
        super(bl3);
    }

    public String encode(String string, String string2) {
        return this.encode((Cookie)new DefaultCookie(string, string2));
    }

    public String encode(Cookie cookie) {
        String string = ObjectUtil.checkNotNull(cookie, "cookie").name();
        String string2 = cookie.value() != null ? cookie.value() : "";
        this.validateCookie(string, string2);
        StringBuilder stringBuilder = CookieUtil.stringBuilder();
        if (cookie.wrap()) {
            CookieUtil.addQuoted(stringBuilder, string, string2);
        } else {
            CookieUtil.add(stringBuilder, string, string2);
        }
        if (cookie.maxAge() != Long.MIN_VALUE) {
            CookieUtil.add(stringBuilder, "Max-Age", cookie.maxAge());
            Date date = new Date(cookie.maxAge() * 1000L + System.currentTimeMillis());
            stringBuilder.append("Expires");
            stringBuilder.append('=');
            DateFormatter.append(date, stringBuilder);
            stringBuilder.append(';');
            stringBuilder.append(' ');
        }
        if (cookie.path() != null) {
            CookieUtil.add(stringBuilder, "Path", cookie.path());
        }
        if (cookie.domain() != null) {
            CookieUtil.add(stringBuilder, "Domain", cookie.domain());
        }
        if (cookie.isSecure()) {
            CookieUtil.add(stringBuilder, "Secure");
        }
        if (cookie.isHttpOnly()) {
            CookieUtil.add(stringBuilder, "HTTPOnly");
        }
        return CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    private static List<String> dedup(List<String> list, Map<String, Integer> map) {
        int n4;
        boolean[] blArray = new boolean[list.size()];
        Object object = map.values().iterator();
        while (object.hasNext()) {
            n4 = object.next();
            blArray[n4] = true;
        }
        object = new ArrayList(map.size());
        int n7 = list.size();
        for (n4 = 0; n4 < n7; ++n4) {
            if (!blArray[n4]) continue;
            object.add(list.get(n4));
        }
        return object;
    }

    public List<String> encode(Cookie ... cookieArray) {
        if (ObjectUtil.checkNotNull(cookieArray, "cookies").length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(cookieArray.length);
        HashMap<String, Integer> hashMap = this.strict && cookieArray.length > 1 ? new HashMap<String, Integer>() : null;
        boolean bl3 = false;
        for (int i3 = 0; i3 < cookieArray.length; ++i3) {
            Cookie cookie = cookieArray[i3];
            arrayList.add(this.encode(cookie));
            if (hashMap == null) continue;
            bl3 |= hashMap.put(cookie.name(), i3) != null;
        }
        return bl3 ? ServerCookieEncoder.dedup(arrayList, hashMap) : arrayList;
    }

    public List<String> encode(Collection<? extends Cookie> collection) {
        if (ObjectUtil.checkNotNull(collection, "cookies").isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        HashMap<String, Integer> hashMap = this.strict && collection.size() > 1 ? new HashMap<String, Integer>() : null;
        int n4 = 0;
        boolean bl3 = false;
        for (Cookie cookie : collection) {
            arrayList.add(this.encode(cookie));
            if (hashMap == null) continue;
            bl3 |= hashMap.put(cookie.name(), n4++) != null;
        }
        return bl3 ? ServerCookieEncoder.dedup(arrayList, hashMap) : arrayList;
    }

    public List<String> encode(Iterable<? extends Cookie> iterable) {
        boolean bl3;
        Iterator<? extends Cookie> iterator = ObjectUtil.checkNotNull(iterable, "cookies").iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Cookie cookie = iterator.next();
        HashMap<String, Integer> hashMap = this.strict && iterator.hasNext() ? new HashMap<String, Integer>() : null;
        int n4 = 0;
        arrayList.add(this.encode(cookie));
        boolean bl4 = bl3 = hashMap != null && hashMap.put(cookie.name(), n4++) != null;
        while (iterator.hasNext()) {
            Cookie cookie2 = iterator.next();
            arrayList.add(this.encode(cookie2));
            if (hashMap == null) continue;
            bl3 |= hashMap.put(cookie2.name(), n4++) != null;
        }
        return bl3 ? ServerCookieEncoder.dedup(arrayList, hashMap) : arrayList;
    }
}

