/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.cookie;

import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.CookieDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.DefaultCookie;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class ServerCookieDecoder
extends CookieDecoder {
    private static final String RFC2965_VERSION = "$Version";
    private static final String RFC2965_PATH = "$Path";
    private static final String RFC2965_DOMAIN = "$Domain";
    private static final String RFC2965_PORT = "$Port";
    public static final ServerCookieDecoder STRICT = new ServerCookieDecoder(true);
    public static final ServerCookieDecoder LAX = new ServerCookieDecoder(false);

    private ServerCookieDecoder(boolean bl3) {
        super(bl3);
    }

    public Set<Cookie> decode(String string) {
        int n4 = ObjectUtil.checkNotNull(string, "header").length();
        if (n4 == 0) {
            return Collections.emptySet();
        }
        TreeSet<Cookie> treeSet = new TreeSet<Cookie>();
        int n7 = 0;
        boolean bl3 = false;
        if (string.regionMatches(true, 0, RFC2965_VERSION, 0, RFC2965_VERSION.length())) {
            n7 = string.indexOf(59) + 1;
            bl3 = true;
        }
        while (n7 != n4) {
            DefaultCookie defaultCookie;
            int n8;
            int n10;
            int n11;
            int n12;
            block9: {
                n12 = string.charAt(n7);
                if (n12 == 9 || n12 == 10 || n12 == 11 || n12 == 12 || n12 == 13 || n12 == 32 || n12 == 44 || n12 == 59) {
                    ++n7;
                    continue;
                }
                n12 = n7;
                do {
                    char c10;
                    if ((c10 = string.charAt(n7)) == ';') {
                        n11 = n7;
                        n10 = -1;
                        n8 = -1;
                    } else {
                        if (c10 != '=') continue;
                        n11 = n7++;
                        if (n7 == n4) {
                            n10 = 0;
                            n8 = 0;
                        } else {
                            n8 = n7;
                            int n13 = string.indexOf(59, n7);
                            n7 = n13 > 0 ? n13 : n4;
                            n10 = n7;
                        }
                    }
                    break block9;
                } while (++n7 != n4);
                n11 = n4;
                n10 = -1;
                n8 = -1;
            }
            if (bl3 && (string.regionMatches(n12, RFC2965_PATH, 0, RFC2965_PATH.length()) || string.regionMatches(n12, RFC2965_DOMAIN, 0, RFC2965_DOMAIN.length()) || string.regionMatches(n12, RFC2965_PORT, 0, RFC2965_PORT.length())) || (defaultCookie = this.initCookie(string, n12, n11, n8, n10)) == null) continue;
            treeSet.add(defaultCookie);
        }
        return treeSet;
    }
}

