/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.cookie;

import io.grpc.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;
import java.util.BitSet;

final class CookieUtil {
    private static final BitSet VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets();
    private static final BitSet VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();
    private static final BitSet VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS = CookieUtil.validCookieAttributeValueOctets();

    private static BitSet validCookieNameOctets() {
        int[] nArray;
        BitSet bitSet = new BitSet();
        for (int i3 = 32; i3 < 127; ++i3) {
            bitSet.set(i3);
        }
        for (int n4 : nArray = new int[]{40, 41, 60, 62, 64, 44, 59, 58, 92, 34, 47, 91, 93, 63, 61, 123, 125, 32, 9}) {
            bitSet.set(n4, false);
        }
        return bitSet;
    }

    private static BitSet validCookieValueOctets() {
        int n4;
        BitSet bitSet = new BitSet();
        bitSet.set(33);
        for (n4 = 35; n4 <= 43; ++n4) {
            bitSet.set(n4);
        }
        for (n4 = 45; n4 <= 58; ++n4) {
            bitSet.set(n4);
        }
        for (n4 = 60; n4 <= 91; ++n4) {
            bitSet.set(n4);
        }
        for (n4 = 93; n4 <= 126; ++n4) {
            bitSet.set(n4);
        }
        return bitSet;
    }

    private static BitSet validCookieAttributeValueOctets() {
        BitSet bitSet = new BitSet();
        for (int i3 = 32; i3 < 127; ++i3) {
            bitSet.set(i3);
        }
        bitSet.set(59, false);
        return bitSet;
    }

    static StringBuilder stringBuilder() {
        return InternalThreadLocalMap.get().stringBuilder();
    }

    static String stripTrailingSeparatorOrNull(StringBuilder stringBuilder) {
        return stringBuilder.length() == 0 ? null : CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    static String stripTrailingSeparator(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        return stringBuilder.toString();
    }

    static void add(StringBuilder stringBuilder, String string, long l2) {
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(l2);
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static void add(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(string2);
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static void add(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static void addQuoted(StringBuilder stringBuilder, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append('\"');
        stringBuilder.append(string2);
        stringBuilder.append('\"');
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static int firstInvalidCookieNameOctet(CharSequence charSequence) {
        return CookieUtil.firstInvalidOctet(charSequence, VALID_COOKIE_NAME_OCTETS);
    }

    static int firstInvalidCookieValueOctet(CharSequence charSequence) {
        return CookieUtil.firstInvalidOctet(charSequence, VALID_COOKIE_VALUE_OCTETS);
    }

    static int firstInvalidOctet(CharSequence charSequence, BitSet bitSet) {
        for (int i3 = 0; i3 < charSequence.length(); ++i3) {
            char c10 = charSequence.charAt(i3);
            if (bitSet.get(c10)) continue;
            return i3;
        }
        return -1;
    }

    static CharSequence unwrapValue(CharSequence charSequence) {
        int n4 = charSequence.length();
        if (n4 > 0 && charSequence.charAt(0) == '\"') {
            if (n4 >= 2 && charSequence.charAt(n4 - 1) == '\"') {
                return n4 == 2 ? "" : charSequence.subSequence(1, n4 - 1);
            }
            return null;
        }
        return charSequence;
    }

    static String validateAttributeValue(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).isEmpty()) {
            return null;
        }
        int n4 = CookieUtil.firstInvalidOctet(string2, VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS);
        if (n4 != -1) {
            throw new IllegalArgumentException(string + " contains the prohibited characters: " + string2.charAt(n4));
        }
        return string2;
    }

    private CookieUtil() {
    }
}

