/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.cookie;

import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.CookieUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.DefaultCookie;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.CharBuffer;

public abstract class CookieDecoder {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private final boolean strict;

    protected CookieDecoder(boolean bl3) {
        this.strict = bl3;
    }

    protected DefaultCookie initCookie(String string, int n4, int n7, int n8, int n10) {
        boolean bl3;
        int n11;
        if (n4 == -1 || n4 == n7) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (n8 == -1) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap(string, n8, n10);
        CharSequence charSequence = CookieUtil.unwrapValue(charBuffer);
        if (charSequence == null) {
            this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)charBuffer);
            return null;
        }
        String string2 = string.substring(n4, n7);
        if (this.strict && (n11 = CookieUtil.firstInvalidCookieNameOctet(string2)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)string2, (Object)Character.valueOf(string2.charAt(n11)));
            }
            return null;
        }
        boolean bl4 = bl3 = charSequence.length() != n10 - n8;
        if (this.strict && (n11 = CookieUtil.firstInvalidCookieValueOctet(charSequence)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)charSequence, (Object)Character.valueOf(charSequence.charAt(n11)));
            }
            return null;
        }
        DefaultCookie defaultCookie = new DefaultCookie(string2, charSequence.toString());
        defaultCookie.setWrap(bl3);
        return defaultCookie;
    }
}

