/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http.cookie;

import io.grpc.netty.shaded.io.netty.handler.codec.DateFormatter;
import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.grpc.netty.shaded.io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.Date;

class ClientCookieDecoder$CookieBuilder {
    private final String header;
    private final DefaultCookie cookie;
    private String domain;
    private String path;
    private long maxAge = Long.MIN_VALUE;
    private int expiresStart;
    private int expiresEnd;
    private boolean secure;
    private boolean httpOnly;

    ClientCookieDecoder$CookieBuilder(DefaultCookie defaultCookie, String string) {
        this.cookie = defaultCookie;
        this.header = string;
    }

    private long mergeMaxAgeAndExpires() {
        Date date;
        if (this.maxAge != Long.MIN_VALUE) {
            return this.maxAge;
        }
        if (ClientCookieDecoder$CookieBuilder.isValueDefined(this.expiresStart, this.expiresEnd) && (date = DateFormatter.parseHttpDate(this.header, this.expiresStart, this.expiresEnd)) != null) {
            long l2 = date.getTime() - System.currentTimeMillis();
            return l2 / 1000L + (long)(l2 % 1000L != 0L ? 1 : 0);
        }
        return Long.MIN_VALUE;
    }

    Cookie cookie() {
        this.cookie.setDomain(this.domain);
        this.cookie.setPath(this.path);
        this.cookie.setMaxAge(this.mergeMaxAgeAndExpires());
        this.cookie.setSecure(this.secure);
        this.cookie.setHttpOnly(this.httpOnly);
        return this.cookie;
    }

    void appendAttribute(int n4, int n7, int n8, int n10) {
        int n11 = n7 - n4;
        if (n11 == 4) {
            this.parse4(n4, n8, n10);
        } else if (n11 == 6) {
            this.parse6(n4, n8, n10);
        } else if (n11 == 7) {
            this.parse7(n4, n8, n10);
        } else if (n11 == 8) {
            this.parse8(n4);
        }
    }

    private void parse4(int n4, int n7, int n8) {
        if (this.header.regionMatches(true, n4, "Path", 0, 4)) {
            this.path = this.computeValue(n7, n8);
        }
    }

    private void parse6(int n4, int n7, int n8) {
        if (this.header.regionMatches(true, n4, "Domain", 0, 5)) {
            this.domain = this.computeValue(n7, n8);
        } else if (this.header.regionMatches(true, n4, "Secure", 0, 5)) {
            this.secure = true;
        }
    }

    private void setMaxAge(String string) {
        try {
            this.maxAge = Math.max(Long.parseLong(string), 0L);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void parse7(int n4, int n7, int n8) {
        if (this.header.regionMatches(true, n4, "Expires", 0, 7)) {
            this.expiresStart = n7;
            this.expiresEnd = n8;
        } else if (this.header.regionMatches(true, n4, "Max-Age", 0, 7)) {
            this.setMaxAge(this.computeValue(n7, n8));
        }
    }

    private void parse8(int n4) {
        if (this.header.regionMatches(true, n4, "HTTPOnly", 0, 8)) {
            this.httpOnly = true;
        }
    }

    private static boolean isValueDefined(int n4, int n7) {
        return n4 != -1 && n4 != n7;
    }

    private String computeValue(int n4, int n7) {
        return ClientCookieDecoder$CookieBuilder.isValueDefined(n4, n7) ? this.header.substring(n4, n7) : null;
    }
}

