/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.handler.codec.CharSequenceValueConverter;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.ReadOnlyHttpHeaders$ReadOnlyIterator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.ReadOnlyHttpHeaders$ReadOnlyStringIterator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.ReadOnlyHttpHeaders$ReadOnlyStringValueIterator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.ReadOnlyHttpHeaders$ReadOnlyValueIterator;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReadOnlyHttpHeaders
extends HttpHeaders {
    private final CharSequence[] nameValuePairs;

    public ReadOnlyHttpHeaders(boolean bl3, CharSequence ... charSequenceArray) {
        if ((charSequenceArray.length & 1) != 0) {
            throw ReadOnlyHttpHeaders.newInvalidArraySizeException();
        }
        if (bl3) {
            ReadOnlyHttpHeaders.validateHeaders(charSequenceArray);
        }
        this.nameValuePairs = charSequenceArray;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("nameValuePairs must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(CharSequence ... charSequenceArray) {
        for (int i3 = 0; i3 < charSequenceArray.length; i3 += 2) {
            DefaultHttpHeaders.HttpNameValidator.validateName(charSequenceArray[i3]);
        }
    }

    private CharSequence get0(CharSequence charSequence) {
        int n4 = AsciiString.hashCode(charSequence);
        for (int i3 = 0; i3 < this.nameValuePairs.length; i3 += 2) {
            CharSequence charSequence2 = this.nameValuePairs[i3];
            if (AsciiString.hashCode(charSequence2) != n4 || !AsciiString.contentEqualsIgnoreCase(charSequence2, charSequence)) continue;
            return this.nameValuePairs[i3 + 1];
        }
        return null;
    }

    @Override
    public String get(String string) {
        CharSequence charSequence = this.get0(string);
        return charSequence == null ? null : charSequence.toString();
    }

    @Override
    public Integer getInt(CharSequence charSequence) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? null : Integer.valueOf(CharSequenceValueConverter.INSTANCE.convertToInt(charSequence2));
    }

    @Override
    public int getInt(CharSequence charSequence, int n4) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? n4 : CharSequenceValueConverter.INSTANCE.convertToInt(charSequence2);
    }

    @Override
    public Short getShort(CharSequence charSequence) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? null : Short.valueOf(CharSequenceValueConverter.INSTANCE.convertToShort(charSequence2));
    }

    @Override
    public short getShort(CharSequence charSequence, short s11) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? s11 : CharSequenceValueConverter.INSTANCE.convertToShort(charSequence2);
    }

    @Override
    public Long getTimeMillis(CharSequence charSequence) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? null : Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToTimeMillis(charSequence2));
    }

    @Override
    public long getTimeMillis(CharSequence charSequence, long l2) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? l2 : CharSequenceValueConverter.INSTANCE.convertToTimeMillis(charSequence2);
    }

    @Override
    public List<String> getAll(String string) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        int n4 = AsciiString.hashCode(string);
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (int i3 = 0; i3 < this.nameValuePairs.length; i3 += 2) {
            CharSequence charSequence = this.nameValuePairs[i3];
            if (AsciiString.hashCode(charSequence) != n4 || !AsciiString.contentEqualsIgnoreCase(charSequence, string)) continue;
            arrayList.add(this.nameValuePairs[i3 + 1].toString());
        }
        return arrayList;
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(this.size());
        for (int i3 = 0; i3 < this.nameValuePairs.length; i3 += 2) {
            arrayList.add(new AbstractMap.SimpleImmutableEntry<String, String>(this.nameValuePairs[i3].toString(), this.nameValuePairs[i3 + 1].toString()));
        }
        return arrayList;
    }

    @Override
    public boolean contains(String string) {
        return this.get0(string) != null;
    }

    @Override
    public boolean contains(String string, String string2, boolean bl3) {
        return this.containsValue(string, string2, bl3);
    }

    @Override
    public boolean containsValue(CharSequence charSequence, CharSequence charSequence2, boolean bl3) {
        if (bl3) {
            for (int i3 = 0; i3 < this.nameValuePairs.length; i3 += 2) {
                if (!AsciiString.contentEqualsIgnoreCase(this.nameValuePairs[i3], charSequence) || !AsciiString.contentEqualsIgnoreCase(this.nameValuePairs[i3 + 1], charSequence2)) continue;
                return true;
            }
        } else {
            for (int i8 = 0; i8 < this.nameValuePairs.length; i8 += 2) {
                if (!AsciiString.contentEqualsIgnoreCase(this.nameValuePairs[i8], charSequence) || !AsciiString.contentEquals(this.nameValuePairs[i8 + 1], charSequence2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<String> valueStringIterator(CharSequence charSequence) {
        return new ReadOnlyHttpHeaders$ReadOnlyStringValueIterator(this, charSequence);
    }

    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence charSequence) {
        return new ReadOnlyHttpHeaders$ReadOnlyValueIterator(this, charSequence);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new ReadOnlyHttpHeaders$ReadOnlyStringIterator(this, null);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new ReadOnlyHttpHeaders$ReadOnlyIterator(this, null);
    }

    @Override
    public boolean isEmpty() {
        return this.nameValuePairs.length == 0;
    }

    @Override
    public int size() {
        return this.nameValuePairs.length >>> 1;
    }

    @Override
    public Set<String> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.size());
        for (int i3 = 0; i3 < this.nameValuePairs.length; i3 += 2) {
            linkedHashSet.add(this.nameValuePairs[i3].toString());
        }
        return linkedHashSet;
    }

    @Override
    public HttpHeaders add(String string, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders add(String string, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders addInt(CharSequence charSequence, int n4) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders addShort(CharSequence charSequence, short s11) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders set(String string, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders set(String string, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders setInt(CharSequence charSequence, int n4) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders setShort(CharSequence charSequence, short s11) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders remove(String string) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders clear() {
        throw new UnsupportedOperationException("read only");
    }

    static /* synthetic */ CharSequence[] access$200(ReadOnlyHttpHeaders readOnlyHttpHeaders) {
        return readOnlyHttpHeaders.nameValuePairs;
    }
}

