/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpConstants;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryStringDecoder {
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private final Charset charset;
    private final String uri;
    private final int maxParams;
    private int pathEndIdx;
    private String path;
    private Map<String, List<String>> params;

    public QueryStringDecoder(String string) {
        this(string, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(String string, boolean bl3) {
        this(string, HttpConstants.DEFAULT_CHARSET, bl3);
    }

    public QueryStringDecoder(String string, Charset charset) {
        this(string, charset, true);
    }

    public QueryStringDecoder(String string, Charset charset, boolean bl3) {
        this(string, charset, bl3, 1024);
    }

    public QueryStringDecoder(String string, Charset charset, boolean bl3, int n4) {
        this.uri = ObjectUtil.checkNotNull(string, "uri");
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.maxParams = ObjectUtil.checkPositive(n4, "maxParams");
        this.pathEndIdx = bl3 ? -1 : 0;
    }

    public QueryStringDecoder(URI uRI) {
        this(uRI, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(URI uRI, Charset charset) {
        this(uRI, charset, 1024);
    }

    public QueryStringDecoder(URI uRI, Charset charset, int n4) {
        String string;
        String string2 = uRI.getRawPath();
        if (string2 == null) {
            string2 = "";
        }
        this.uri = (string = uRI.getRawQuery()) == null ? string2 : string2 + '?' + string;
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.maxParams = ObjectUtil.checkPositive(n4, "maxParams");
        this.pathEndIdx = string2.length();
    }

    public String toString() {
        return this.uri();
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        if (this.path == null) {
            this.path = QueryStringDecoder.decodeComponent(this.uri, 0, this.pathEndIdx(), this.charset, true);
        }
        return this.path;
    }

    public Map<String, List<String>> parameters() {
        if (this.params == null) {
            this.params = QueryStringDecoder.decodeParams(this.uri, this.pathEndIdx(), this.charset, this.maxParams);
        }
        return this.params;
    }

    public String rawPath() {
        return this.uri.substring(0, this.pathEndIdx());
    }

    public String rawQuery() {
        int n4 = this.pathEndIdx() + 1;
        return n4 < this.uri.length() ? this.uri.substring(n4) : "";
    }

    private int pathEndIdx() {
        if (this.pathEndIdx == -1) {
            this.pathEndIdx = QueryStringDecoder.findPathEndIndex(this.uri);
        }
        return this.pathEndIdx;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, List<String>> decodeParams(String string, int n4, Charset charset, int n7) {
        int n8;
        int n10 = string.length();
        if (n4 >= n10) {
            return Collections.emptyMap();
        }
        if (string.charAt(n4) == '?') {
            ++n4;
        }
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        int n11 = n4;
        int n12 = -1;
        block5: for (n8 = n4; n8 < n10; ++n8) {
            switch (string.charAt(n8)) {
                case '=': {
                    if (n11 == n8) {
                        n11 = n8 + 1;
                        break;
                    }
                    if (n12 >= n11) break;
                    n12 = n8 + 1;
                    break;
                }
                case '&': 
                case ';': {
                    if (QueryStringDecoder.addParam(string, n11, n12, n8, linkedHashMap, charset) && --n7 == 0) {
                        return linkedHashMap;
                    }
                    n11 = n8 + 1;
                    break;
                }
                case '#': {
                    break block5;
                }
            }
        }
        QueryStringDecoder.addParam(string, n11, n12, n8, linkedHashMap, charset);
        return linkedHashMap;
    }

    private static boolean addParam(String string, int n4, int n7, int n8, Map<String, List<String>> map, Charset charset) {
        if (n4 >= n8) {
            return false;
        }
        if (n7 <= n4) {
            n7 = n8 + 1;
        }
        String string2 = QueryStringDecoder.decodeComponent(string, n4, n7 - 1, charset, false);
        String string3 = QueryStringDecoder.decodeComponent(string, n7, n8, charset, false);
        List<String> list = map.get(string2);
        if (list == null) {
            list = new ArrayList<String>(1);
            map.put(string2, list);
        }
        list.add(string3);
        return true;
    }

    public static String decodeComponent(String string) {
        return QueryStringDecoder.decodeComponent(string, HttpConstants.DEFAULT_CHARSET);
    }

    public static String decodeComponent(String string, Charset charset) {
        if (string == null) {
            return "";
        }
        return QueryStringDecoder.decodeComponent(string, 0, string.length(), charset, false);
    }

    private static String decodeComponent(String string, int n4, int n7, Charset charset, boolean bl3) {
        int n8;
        int n10 = n7 - n4;
        if (n10 <= 0) {
            return "";
        }
        int n11 = -1;
        for (int i3 = n4; i3 < n7; ++i3) {
            n8 = string.charAt(i3);
            if (n8 != 37 && (n8 != 43 || bl3)) continue;
            n11 = i3;
            break;
        }
        if (n11 == -1) {
            return string.substring(n4, n7);
        }
        CharsetDecoder charsetDecoder = CharsetUtil.decoder(charset);
        n8 = (n7 - n11) / 3;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n8);
        CharBuffer charBuffer = CharBuffer.allocate(n8);
        StringBuilder stringBuilder = new StringBuilder(n10);
        stringBuilder.append(string, n4, n11);
        for (int i8 = n11; i8 < n7; ++i8) {
            char c10 = string.charAt(i8);
            if (c10 != '%') {
                stringBuilder.append(c10 != '+' || bl3 ? c10 : (char)' ');
                continue;
            }
            byteBuffer.clear();
            do {
                if (i8 + 3 > n7) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i8 + " of: " + string);
                }
                byteBuffer.put(StringUtil.decodeHexByte(string, i8 + 1));
            } while ((i8 += 3) < n7 && string.charAt(i8) == '%');
            --i8;
            byteBuffer.flip();
            charBuffer.clear();
            CoderResult coderResult = charsetDecoder.reset().decode(byteBuffer, charBuffer, true);
            try {
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IllegalStateException(characterCodingException);
            }
            stringBuilder.append(charBuffer.flip());
        }
        return stringBuilder.toString();
    }

    private static int findPathEndIndex(String string) {
        int n4 = string.length();
        for (int i3 = 0; i3 < n4; ++i3) {
            char c10 = string.charAt(i3);
            if (c10 != '?' && c10 != '#') continue;
            return i3;
        }
        return n4;
    }
}

