/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpVersion
implements Comparable<HttpVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\S+)/(\\d+)\\.(\\d+)");
    private static final String HTTP_1_0_STRING = "HTTP/1.0";
    private static final String HTTP_1_1_STRING = "HTTP/1.1";
    public static final HttpVersion HTTP_1_0 = new HttpVersion("HTTP", 1, 0, false, true);
    public static final HttpVersion HTTP_1_1 = new HttpVersion("HTTP", 1, 1, true, true);
    private final String protocolName;
    private final int majorVersion;
    private final int minorVersion;
    private final String text;
    private final boolean keepAliveDefault;
    private final byte[] bytes;

    public static HttpVersion valueOf(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if ((string = string.trim()).isEmpty()) {
            throw new IllegalArgumentException("text is empty (possibly HTTP/0.9)");
        }
        HttpVersion httpVersion = HttpVersion.version0(string);
        if (httpVersion == null) {
            httpVersion = new HttpVersion(string, true);
        }
        return httpVersion;
    }

    private static HttpVersion version0(String string) {
        if (HTTP_1_1_STRING.equals(string)) {
            return HTTP_1_1;
        }
        if (HTTP_1_0_STRING.equals(string)) {
            return HTTP_1_0;
        }
        return null;
    }

    public HttpVersion(String string, boolean bl3) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if ((string = string.trim().toUpperCase()).isEmpty()) {
            throw new IllegalArgumentException("empty text");
        }
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid version format: " + string);
        }
        this.protocolName = matcher.group(1);
        this.majorVersion = Integer.parseInt(matcher.group(2));
        this.minorVersion = Integer.parseInt(matcher.group(3));
        this.text = this.protocolName + '/' + this.majorVersion + '.' + this.minorVersion;
        this.keepAliveDefault = bl3;
        this.bytes = null;
    }

    public HttpVersion(String string, int n4, int n7, boolean bl3) {
        this(string, n4, n7, bl3, false);
    }

    private HttpVersion(String string, int n4, int n7, boolean bl3, boolean bl4) {
        if (string == null) {
            throw new NullPointerException("protocolName");
        }
        if ((string = string.trim().toUpperCase()).isEmpty()) {
            throw new IllegalArgumentException("empty protocolName");
        }
        for (int i3 = 0; i3 < string.length(); ++i3) {
            if (!Character.isISOControl(string.charAt(i3)) && !Character.isWhitespace(string.charAt(i3))) continue;
            throw new IllegalArgumentException("invalid character in protocolName");
        }
        ObjectUtil.checkPositiveOrZero(n4, "majorVersion");
        ObjectUtil.checkPositiveOrZero(n7, "minorVersion");
        this.protocolName = string;
        this.majorVersion = n4;
        this.minorVersion = n7;
        this.text = string + '/' + n4 + '.' + n7;
        this.keepAliveDefault = bl3;
        this.bytes = (byte[])(bl4 ? this.text.getBytes(CharsetUtil.US_ASCII) : null);
    }

    public String protocolName() {
        return this.protocolName;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public String text() {
        return this.text;
    }

    public boolean isKeepAliveDefault() {
        return this.keepAliveDefault;
    }

    public String toString() {
        return this.text();
    }

    public int hashCode() {
        return (this.protocolName().hashCode() * 31 + this.majorVersion()) * 31 + this.minorVersion();
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpVersion)) {
            return false;
        }
        HttpVersion httpVersion = (HttpVersion)object;
        return this.minorVersion() == httpVersion.minorVersion() && this.majorVersion() == httpVersion.majorVersion() && this.protocolName().equals(httpVersion.protocolName());
    }

    @Override
    public int compareTo(HttpVersion httpVersion) {
        int n4 = this.protocolName().compareTo(httpVersion.protocolName());
        if (n4 != 0) {
            return n4;
        }
        n4 = this.majorVersion() - httpVersion.majorVersion();
        if (n4 != 0) {
            return n4;
        }
        return this.minorVersion() - httpVersion.minorVersion();
    }

    void encode(ByteBuf byteBuf) {
        if (this.bytes == null) {
            byteBuf.writeCharSequence(this.text, CharsetUtil.US_ASCII);
        } else {
            byteBuf.writeBytes(this.bytes);
        }
    }
}

