/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObject;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpServerUpgradeHandler$SourceCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeCodecFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeEvent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.List;

public class HttpServerUpgradeHandler
extends HttpObjectAggregator {
    private final HttpServerUpgradeHandler$SourceCodec sourceCodec;
    private final HttpServerUpgradeHandler$UpgradeCodecFactory upgradeCodecFactory;
    private boolean handlingUpgrade;

    public HttpServerUpgradeHandler(HttpServerUpgradeHandler$SourceCodec httpServerUpgradeHandler$SourceCodec, HttpServerUpgradeHandler$UpgradeCodecFactory httpServerUpgradeHandler$UpgradeCodecFactory) {
        this(httpServerUpgradeHandler$SourceCodec, httpServerUpgradeHandler$UpgradeCodecFactory, 0);
    }

    public HttpServerUpgradeHandler(HttpServerUpgradeHandler$SourceCodec httpServerUpgradeHandler$SourceCodec, HttpServerUpgradeHandler$UpgradeCodecFactory httpServerUpgradeHandler$UpgradeCodecFactory, int n4) {
        super(n4);
        this.sourceCodec = ObjectUtil.checkNotNull(httpServerUpgradeHandler$SourceCodec, "sourceCodec");
        this.upgradeCodecFactory = ObjectUtil.checkNotNull(httpServerUpgradeHandler$UpgradeCodecFactory, "upgradeCodecFactory");
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        FullHttpRequest fullHttpRequest;
        this.handlingUpgrade |= HttpServerUpgradeHandler.isUpgradeRequest(httpObject);
        if (!this.handlingUpgrade) {
            ReferenceCountUtil.retain(httpObject);
            list.add(httpObject);
            return;
        }
        if (httpObject instanceof FullHttpRequest) {
            fullHttpRequest = (FullHttpRequest)httpObject;
            ReferenceCountUtil.retain(httpObject);
            list.add(httpObject);
        } else {
            super.decode(channelHandlerContext, httpObject, list);
            if (list.isEmpty()) {
                return;
            }
            assert (list.size() == 1);
            this.handlingUpgrade = false;
            fullHttpRequest = (FullHttpRequest)list.get(0);
        }
        if (this.upgrade(channelHandlerContext, fullHttpRequest)) {
            list.clear();
        }
    }

    private static boolean isUpgradeRequest(HttpObject httpObject) {
        return httpObject instanceof HttpRequest && ((HttpRequest)httpObject).headers().get(HttpHeaderNames.UPGRADE) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgrade(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) {
        Object object;
        Object object3;
        CharSequence charSequence;
        List<CharSequence> list = HttpServerUpgradeHandler.splitHeader(fullHttpRequest.headers().get(HttpHeaderNames.UPGRADE));
        int n4 = list.size();
        HttpServerUpgradeHandler$UpgradeCodec httpServerUpgradeHandler$UpgradeCodec = null;
        CharSequence charSequence2 = null;
        for (int i3 = 0; i3 < n4; ++i3) {
            charSequence = list.get(i3);
            object3 = this.upgradeCodecFactory.newUpgradeCodec(charSequence);
            if (object3 == null) continue;
            charSequence2 = charSequence;
            httpServerUpgradeHandler$UpgradeCodec = object3;
            break;
        }
        if (httpServerUpgradeHandler$UpgradeCodec == null) {
            return false;
        }
        List<String> list2 = fullHttpRequest.headers().getAll(HttpHeaderNames.CONNECTION);
        if (list2 == null) {
            return false;
        }
        charSequence = new StringBuilder(list2.size() * 10);
        for (CharSequence object22 : list2) {
            ((StringBuilder)charSequence).append(object22).append(',');
        }
        ((StringBuilder)charSequence).setLength(((StringBuilder)charSequence).length() - 1);
        object3 = httpServerUpgradeHandler$UpgradeCodec.requiredUpgradeHeaders();
        List<CharSequence> list3 = HttpServerUpgradeHandler.splitHeader(charSequence);
        if (!AsciiString.containsContentEqualsIgnoreCase(list3, HttpHeaderNames.UPGRADE) || !AsciiString.containsAllContentEqualsIgnoreCase(list3, object3)) {
            return false;
        }
        Object object2 = object3.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (fullHttpRequest.headers().contains((CharSequence)object)) continue;
            return false;
        }
        object2 = HttpServerUpgradeHandler.createUpgradeResponse(charSequence2);
        if (!httpServerUpgradeHandler$UpgradeCodec.prepareUpgradeResponse(channelHandlerContext, fullHttpRequest, object2.headers())) {
            return false;
        }
        object = new HttpServerUpgradeHandler$UpgradeEvent(charSequence2, fullHttpRequest);
        try {
            ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(object2);
            this.sourceCodec.upgradeFrom(channelHandlerContext);
            httpServerUpgradeHandler$UpgradeCodec.upgradeTo(channelHandlerContext, fullHttpRequest);
            channelHandlerContext.pipeline().remove(this);
            channelHandlerContext.fireUserEventTriggered(((HttpServerUpgradeHandler$UpgradeEvent)object).retain());
            channelFuture.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        finally {
            ((HttpServerUpgradeHandler$UpgradeEvent)object).release();
        }
        return true;
    }

    private static FullHttpResponse createUpgradeResponse(CharSequence charSequence) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, false);
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)charSequence);
        return defaultFullHttpResponse;
    }

    private static List<CharSequence> splitHeader(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(4);
        for (int i3 = 0; i3 < charSequence.length(); ++i3) {
            char c10 = charSequence.charAt(i3);
            if (Character.isWhitespace(c10)) continue;
            if (c10 == ',') {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c10);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }
}

