/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;

public class HttpRequestEncoder
extends HttpObjectEncoder<HttpRequest> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final int SLASH_AND_SPACE_SHORT = 12064;
    private static final int SPACE_SLASH_AND_SPACE_MEDIUM = 0x202F20;

    @Override
    public boolean acceptOutboundMessage(Object object) {
        return super.acceptOutboundMessage(object) && !(object instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf byteBuf, HttpRequest httpRequest) {
        ByteBufUtil.copy(httpRequest.method().asciiName(), byteBuf);
        String string = httpRequest.uri();
        if (string.isEmpty()) {
            ByteBufUtil.writeMediumBE(byteBuf, 0x202F20);
        } else {
            CharSequence charSequence = string;
            boolean bl3 = false;
            int n4 = string.indexOf("://");
            if (n4 != -1 && string.charAt(0) != '/') {
                int n7 = string.indexOf(63, n4 += 3);
                if (n7 == -1) {
                    if (string.lastIndexOf(47) < n4) {
                        bl3 = true;
                    }
                } else if (string.lastIndexOf(47, n7) < n4) {
                    charSequence = new StringBuilder(string).insert(n7, '/');
                }
            }
            byteBuf.writeByte(32).writeCharSequence(charSequence, CharsetUtil.UTF_8);
            if (bl3) {
                ByteBufUtil.writeShortBE(byteBuf, 12064);
            } else {
                byteBuf.writeByte(32);
            }
        }
        httpRequest.protocolVersion().encode(byteBuf);
        ByteBufUtil.writeShortBE(byteBuf, 3338);
    }
}

