/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderResult;
import io.grpc.netty.shaded.io.netty.handler.codec.PrematureChannelClosureException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultLastHttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectDecoder$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectDecoder$HeaderParser;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectDecoder$LineParser;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectDecoder$State;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.grpc.netty.shaded.io.netty.util.internal.AppendableCharSequence;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

public abstract class HttpObjectDecoder
extends ByteToMessageDecoder {
    private static final String EMPTY_VALUE = "";
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    protected final boolean validateHeaders;
    private final HttpObjectDecoder$HeaderParser headerParser;
    private final HttpObjectDecoder$LineParser lineParser;
    private HttpMessage message;
    private long chunkSize;
    private long contentLength = Long.MIN_VALUE;
    private volatile boolean resetRequested;
    private CharSequence name;
    private CharSequence value;
    private LastHttpContent trailer;
    private HttpObjectDecoder$State currentState = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;

    protected HttpObjectDecoder() {
        this(4096, 8192, 8192, true);
    }

    protected HttpObjectDecoder(int n4, int n7, int n8, boolean bl3) {
        this(n4, n7, n8, bl3, true);
    }

    protected HttpObjectDecoder(int n4, int n7, int n8, boolean bl3, boolean bl4) {
        this(n4, n7, n8, bl3, bl4, 128);
    }

    protected HttpObjectDecoder(int n4, int n7, int n8, boolean bl3, boolean bl4, int n10) {
        ObjectUtil.checkPositive(n4, "maxInitialLineLength");
        ObjectUtil.checkPositive(n7, "maxHeaderSize");
        ObjectUtil.checkPositive(n8, "maxChunkSize");
        AppendableCharSequence appendableCharSequence = new AppendableCharSequence(n10);
        this.lineParser = new HttpObjectDecoder$LineParser(appendableCharSequence, n4);
        this.headerParser = new HttpObjectDecoder$HeaderParser(appendableCharSequence, n7);
        this.maxChunkSize = n8;
        this.chunkedSupported = bl3;
        this.validateHeaders = bl4;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.resetRequested) {
            this.resetNow();
        }
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: {
                if (!HttpObjectDecoder.skipControlCharacters(byteBuf)) {
                    return;
                }
                this.currentState = HttpObjectDecoder$State.READ_INITIAL;
            }
            case READ_INITIAL: {
                Object object;
                try {
                    object = this.lineParser.parse(byteBuf);
                    if (object == null) {
                        return;
                    }
                    String[] stringArray = HttpObjectDecoder.splitInitialLine((AppendableCharSequence)object);
                    if (stringArray.length < 3) {
                        this.currentState = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;
                        return;
                    }
                    this.message = this.createMessage(stringArray);
                    this.currentState = HttpObjectDecoder$State.READ_HEADER;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_HEADER: {
                Object object;
                try {
                    object = this.readHeaders(byteBuf);
                    if (object == null) {
                        return;
                    }
                    this.currentState = object;
                    switch (HttpObjectDecoder$1.$SwitchMap$io$netty$handler$codec$http$HttpObjectDecoder$State[((Enum)object).ordinal()]) {
                        case 1: {
                            list.add(this.message);
                            list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                            this.resetNow();
                            return;
                        }
                        case 2: {
                            if (!this.chunkedSupported) {
                                throw new IllegalArgumentException("Chunked messages not supported");
                            }
                            list.add(this.message);
                            return;
                        }
                    }
                    long l2 = this.contentLength();
                    if (l2 == 0L || l2 == -1L && this.isDecodingRequest()) {
                        list.add(this.message);
                        list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                        this.resetNow();
                        return;
                    }
                    assert (object == HttpObjectDecoder$State.READ_FIXED_LENGTH_CONTENT || object == HttpObjectDecoder$State.READ_VARIABLE_LENGTH_CONTENT);
                    list.add(this.message);
                    if (object == HttpObjectDecoder$State.READ_FIXED_LENGTH_CONTENT) {
                        this.chunkSize = l2;
                    }
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int n4 = Math.min(byteBuf.readableBytes(), this.maxChunkSize);
                if (n4 > 0) {
                    ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n4);
                    list.add(new DefaultHttpContent(byteBuf2));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int n7 = byteBuf.readableBytes();
                if (n7 == 0) {
                    return;
                }
                int n8 = Math.min(n7, this.maxChunkSize);
                if ((long)n8 > this.chunkSize) {
                    n8 = (int)this.chunkSize;
                }
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n8);
                this.chunkSize -= (long)n8;
                if (this.chunkSize == 0L) {
                    list.add(new DefaultLastHttpContent(byteBuf3, this.validateHeaders));
                    this.resetNow();
                } else {
                    list.add(new DefaultHttpContent(byteBuf3));
                }
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    AppendableCharSequence appendableCharSequence = this.lineParser.parse(byteBuf);
                    if (appendableCharSequence == null) {
                        return;
                    }
                    int n10 = HttpObjectDecoder.getChunkSize(appendableCharSequence.toString());
                    this.chunkSize = n10;
                    if (n10 == 0) {
                        this.currentState = HttpObjectDecoder$State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = HttpObjectDecoder$State.READ_CHUNKED_CONTENT;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int n11 = Math.min((int)this.chunkSize, this.maxChunkSize);
                if ((n11 = Math.min(n11, byteBuf.readableBytes())) == 0) {
                    return;
                }
                DefaultHttpContent defaultHttpContent = new DefaultHttpContent(byteBuf.readRetainedSlice(n11));
                this.chunkSize -= (long)n11;
                list.add(defaultHttpContent);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = HttpObjectDecoder$State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int n11 = byteBuf.writerIndex();
                int n12 = byteBuf.readerIndex();
                while (n11 > n12) {
                    byte by2;
                    if ((by2 = byteBuf.getByte(n12++)) != 10) continue;
                    this.currentState = HttpObjectDecoder$State.READ_CHUNK_SIZE;
                    break;
                }
                byteBuf.readerIndex(n12);
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    LastHttpContent lastHttpContent = this.readTrailingHeaders(byteBuf);
                    if (lastHttpContent == null) {
                        return;
                    }
                    list.add(lastHttpContent);
                    this.resetNow();
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case BAD_MESSAGE: {
                byteBuf.skipBytes(byteBuf.readableBytes());
                break;
            }
            case UPGRADED: {
                int n13 = byteBuf.readableBytes();
                if (n13 <= 0) break;
                list.add(byteBuf.readBytes(n13));
                break;
            }
        }
    }

    @Override
    public void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        super.decodeLast(channelHandlerContext, byteBuf, list);
        if (this.resetRequested) {
            this.resetNow();
        }
        if (this.message != null) {
            boolean bl3;
            boolean bl4 = HttpUtil.isTransferEncodingChunked(this.message);
            if (this.currentState == HttpObjectDecoder$State.READ_VARIABLE_LENGTH_CONTENT && !byteBuf.isReadable() && !bl4) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                this.resetNow();
                return;
            }
            if (this.currentState == HttpObjectDecoder$State.READ_HEADER) {
                list.add(this.invalidMessage(Unpooled.EMPTY_BUFFER, new PrematureChannelClosureException("Connection closed before received headers")));
                this.resetNow();
                return;
            }
            if (this.isDecodingRequest() || bl4) {
                bl3 = true;
            } else {
                boolean bl5 = bl3 = this.contentLength() > 0L;
            }
            if (!bl3) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            }
            this.resetNow();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.reset();
                    break;
                }
            }
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            int n4 = httpResponse.status().code();
            if (n4 >= 100 && n4 < 200) {
                return n4 != 101 || httpResponse.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT) || !httpResponse.headers().contains(HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET, true);
            }
            switch (n4) {
                case 204: 
                case 304: {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isSwitchingToNonHttp1Protocol(HttpResponse httpResponse) {
        if (httpResponse.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        String string = httpResponse.headers().get(HttpHeaderNames.UPGRADE);
        return string == null || !string.contains(HttpVersion.HTTP_1_0.text()) && !string.contains(HttpVersion.HTTP_1_1.text());
    }

    public void reset() {
        this.resetRequested = true;
    }

    private void resetNow() {
        HttpResponse httpResponse;
        HttpMessage httpMessage = this.message;
        this.message = null;
        this.name = null;
        this.value = null;
        this.contentLength = Long.MIN_VALUE;
        this.lineParser.reset();
        this.headerParser.reset();
        this.trailer = null;
        if (!this.isDecodingRequest() && (httpResponse = (HttpResponse)httpMessage) != null && this.isSwitchingToNonHttp1Protocol(httpResponse)) {
            this.currentState = HttpObjectDecoder$State.UPGRADED;
            return;
        }
        this.resetRequested = false;
        this.currentState = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;
    }

    private HttpMessage invalidMessage(ByteBuf byteBuf, Exception exception) {
        this.currentState = HttpObjectDecoder$State.BAD_MESSAGE;
        byteBuf.skipBytes(byteBuf.readableBytes());
        if (this.message == null) {
            this.message = this.createInvalidMessage();
        }
        this.message.setDecoderResult(DecoderResult.failure(exception));
        HttpMessage httpMessage = this.message;
        this.message = null;
        return httpMessage;
    }

    private HttpContent invalidChunk(ByteBuf byteBuf, Exception exception) {
        this.currentState = HttpObjectDecoder$State.BAD_MESSAGE;
        byteBuf.skipBytes(byteBuf.readableBytes());
        DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        defaultLastHttpContent.setDecoderResult(DecoderResult.failure(exception));
        this.message = null;
        this.trailer = null;
        return defaultLastHttpContent;
    }

    private static boolean skipControlCharacters(ByteBuf byteBuf) {
        boolean bl3 = false;
        int n4 = byteBuf.writerIndex();
        int n7 = byteBuf.readerIndex();
        while (n4 > n7) {
            short s11;
            if (Character.isISOControl(s11 = byteBuf.getUnsignedByte(n7++)) || Character.isWhitespace(s11)) continue;
            --n7;
            bl3 = true;
            break;
        }
        byteBuf.readerIndex(n7);
        return bl3;
    }

    private HttpObjectDecoder$State readHeaders(ByteBuf byteBuf) {
        HttpObjectDecoder$State httpObjectDecoder$State;
        HttpMessage httpMessage = this.message;
        HttpHeaders httpHeaders = httpMessage.headers();
        AppendableCharSequence appendableCharSequence = this.headerParser.parse(byteBuf);
        if (appendableCharSequence == null) {
            return null;
        }
        if (appendableCharSequence.length() > 0) {
            do {
                char c10 = appendableCharSequence.charAt(0);
                if (this.name != null && (c10 == ' ' || c10 == '\t')) {
                    String string = appendableCharSequence.toString().trim();
                    String string2 = String.valueOf(this.value);
                    this.value = string2 + ' ' + string;
                } else {
                    if (this.name != null) {
                        httpHeaders.add(this.name, (Object)this.value);
                    }
                    this.splitHeader(appendableCharSequence);
                }
                appendableCharSequence = this.headerParser.parse(byteBuf);
                if (appendableCharSequence != null) continue;
                return null;
            } while (appendableCharSequence.length() > 0);
        }
        if (this.name != null) {
            httpHeaders.add(this.name, (Object)this.value);
        }
        this.name = null;
        this.value = null;
        if (this.isContentAlwaysEmpty(httpMessage)) {
            HttpUtil.setTransferEncodingChunked(httpMessage, false);
            httpObjectDecoder$State = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;
        } else {
            httpObjectDecoder$State = HttpUtil.isTransferEncodingChunked(httpMessage) ? HttpObjectDecoder$State.READ_CHUNK_SIZE : (this.contentLength() >= 0L ? HttpObjectDecoder$State.READ_FIXED_LENGTH_CONTENT : HttpObjectDecoder$State.READ_VARIABLE_LENGTH_CONTENT);
        }
        return httpObjectDecoder$State;
    }

    private long contentLength() {
        if (this.contentLength == Long.MIN_VALUE) {
            this.contentLength = HttpUtil.getContentLength(this.message, -1L);
        }
        return this.contentLength;
    }

    private LastHttpContent readTrailingHeaders(ByteBuf byteBuf) {
        AppendableCharSequence appendableCharSequence = this.headerParser.parse(byteBuf);
        if (appendableCharSequence == null) {
            return null;
        }
        LastHttpContent lastHttpContent = this.trailer;
        if (appendableCharSequence.length() == 0 && lastHttpContent == null) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        CharSequence charSequence = null;
        if (lastHttpContent == null) {
            lastHttpContent = this.trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
        }
        while (appendableCharSequence.length() > 0) {
            List<String> list;
            char c10 = appendableCharSequence.charAt(0);
            if (charSequence != null && (c10 == ' ' || c10 == '\t')) {
                list = lastHttpContent.trailingHeaders().getAll(charSequence);
                if (!list.isEmpty()) {
                    int n4 = list.size() - 1;
                    String string = appendableCharSequence.toString().trim();
                    String string2 = (String)list.get(n4);
                    list.set(n4, string2 + string);
                }
            } else {
                this.splitHeader(appendableCharSequence);
                list = this.name;
                if (!(HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase((CharSequence)((Object)list)))) {
                    lastHttpContent.trailingHeaders().add((CharSequence)((Object)list), (Object)this.value);
                }
                charSequence = this.name;
                this.name = null;
                this.value = null;
            }
            if ((appendableCharSequence = this.headerParser.parse(byteBuf)) != null) continue;
            return null;
        }
        this.trailer = null;
        return lastHttpContent;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1);

    protected abstract HttpMessage createInvalidMessage();

    private static int getChunkSize(String string) {
        string = string.trim();
        for (int i3 = 0; i3 < string.length(); ++i3) {
            char c10 = string.charAt(i3);
            if (c10 != ';' && !Character.isWhitespace(c10) && !Character.isISOControl(c10)) continue;
            string = string.substring(0, i3);
            break;
        }
        return Integer.parseInt(string, 16);
    }

    private static String[] splitInitialLine(AppendableCharSequence appendableCharSequence) {
        int n4 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, 0);
        int n7 = HttpObjectDecoder.findWhitespace(appendableCharSequence, n4);
        int n8 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, n7);
        int n10 = HttpObjectDecoder.findWhitespace(appendableCharSequence, n8);
        int n11 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, n10);
        int n12 = HttpObjectDecoder.findEndOfString(appendableCharSequence);
        return new String[]{appendableCharSequence.subStringUnsafe(n4, n7), appendableCharSequence.subStringUnsafe(n8, n10), n11 < n12 ? appendableCharSequence.subStringUnsafe(n11, n12) : EMPTY_VALUE};
    }

    private void splitHeader(AppendableCharSequence appendableCharSequence) {
        int n4;
        int n7;
        char c10;
        int n8;
        int n10 = appendableCharSequence.length();
        for (n8 = n7 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, 0); n8 < n10 && (c10 = appendableCharSequence.charAt(n8)) != ':' && !Character.isWhitespace(c10); ++n8) {
        }
        for (n4 = n8; n4 < n10; ++n4) {
            if (appendableCharSequence.charAt(n4) != ':') continue;
            ++n4;
            break;
        }
        this.name = appendableCharSequence.subStringUnsafe(n7, n8);
        int n11 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, n4);
        if (n11 == n10) {
            this.value = EMPTY_VALUE;
        } else {
            int n12 = HttpObjectDecoder.findEndOfString(appendableCharSequence);
            this.value = appendableCharSequence.subStringUnsafe(n11, n12);
        }
    }

    private static int findNonWhitespace(AppendableCharSequence appendableCharSequence, int n4) {
        for (int i3 = n4; i3 < appendableCharSequence.length(); ++i3) {
            if (Character.isWhitespace(appendableCharSequence.charAtUnsafe(i3))) continue;
            return i3;
        }
        return appendableCharSequence.length();
    }

    private static int findWhitespace(AppendableCharSequence appendableCharSequence, int n4) {
        for (int i3 = n4; i3 < appendableCharSequence.length(); ++i3) {
            if (!Character.isWhitespace(appendableCharSequence.charAtUnsafe(i3))) continue;
            return i3;
        }
        return appendableCharSequence.length();
    }

    private static int findEndOfString(AppendableCharSequence appendableCharSequence) {
        for (int i3 = appendableCharSequence.length() - 1; i3 > 0; --i3) {
            if (Character.isWhitespace(appendableCharSequence.charAtUnsafe(i3))) continue;
            return i3 + 1;
        }
        return 0;
    }
}

