/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;
import io.grpc.netty.shaded.io.netty.util.internal.AppendableCharSequence;

class HttpObjectDecoder$HeaderParser
implements ByteProcessor {
    private final AppendableCharSequence seq;
    private final int maxLength;
    private int size;

    HttpObjectDecoder$HeaderParser(AppendableCharSequence appendableCharSequence, int n4) {
        this.seq = appendableCharSequence;
        this.maxLength = n4;
    }

    public AppendableCharSequence parse(ByteBuf byteBuf) {
        int n4 = this.size;
        this.seq.reset();
        int n7 = byteBuf.forEachByte(this);
        if (n7 == -1) {
            this.size = n4;
            return null;
        }
        byteBuf.readerIndex(n7 + 1);
        return this.seq;
    }

    public void reset() {
        this.size = 0;
    }

    @Override
    public boolean process(byte by2) {
        char c10 = (char)(by2 & 0xFF);
        if (c10 == '\r') {
            return true;
        }
        if (c10 == '\n') {
            return false;
        }
        if (++this.size > this.maxLength) {
            throw this.newException(this.maxLength);
        }
        this.seq.append(c10);
        return true;
    }

    protected TooLongFrameException newException(int n4) {
        return new TooLongFrameException("HTTP header is larger than " + n4 + " bytes.");
    }
}

