/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPipeline;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageAggregator;
import io.grpc.netty.shaded.io.netty.handler.codec.TooLongFrameException;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObject;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectAggregator$1;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectAggregator$2;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectAggregator$AggregatedFullHttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectAggregator$AggregatedFullHttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectAggregator$AggregatedFullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpStatusClass;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class HttpObjectAggregator
extends MessageAggregator<HttpObject, HttpMessage, HttpContent, FullHttpMessage> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpObjectAggregator.class);
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private final boolean closeOnExpectationFailed;

    public HttpObjectAggregator(int n4) {
        this(n4, false);
    }

    public HttpObjectAggregator(int n4, boolean bl3) {
        super(n4);
        this.closeOnExpectationFailed = bl3;
    }

    @Override
    protected boolean isStartMessage(HttpObject httpObject) {
        return httpObject instanceof HttpMessage;
    }

    @Override
    protected boolean isContentMessage(HttpObject httpObject) {
        return httpObject instanceof HttpContent;
    }

    @Override
    protected boolean isLastContentMessage(HttpContent httpContent) {
        return httpContent instanceof LastHttpContent;
    }

    @Override
    protected boolean isAggregated(HttpObject httpObject) {
        return httpObject instanceof FullHttpMessage;
    }

    @Override
    protected boolean isContentLengthInvalid(HttpMessage httpMessage, int n4) {
        try {
            return HttpUtil.getContentLength(httpMessage, -1L) > (long)n4;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static Object continueResponse(HttpMessage httpMessage, int n4, ChannelPipeline channelPipeline) {
        if (HttpUtil.isUnsupportedExpectation(httpMessage)) {
            channelPipeline.fireUserEventTriggered(HttpExpectationFailedEvent.INSTANCE);
            return EXPECTATION_FAILED.retainedDuplicate();
        }
        if (HttpUtil.is100ContinueExpected(httpMessage)) {
            if (HttpUtil.getContentLength(httpMessage, -1L) <= (long)n4) {
                return CONTINUE.retainedDuplicate();
            }
            channelPipeline.fireUserEventTriggered(HttpExpectationFailedEvent.INSTANCE);
            return TOO_LARGE.retainedDuplicate();
        }
        return null;
    }

    @Override
    protected Object newContinueResponse(HttpMessage httpMessage, int n4, ChannelPipeline channelPipeline) {
        Object object = HttpObjectAggregator.continueResponse(httpMessage, n4, channelPipeline);
        if (object != null) {
            httpMessage.headers().remove(HttpHeaderNames.EXPECT);
        }
        return object;
    }

    @Override
    public boolean closeAfterContinueResponse(Object object) {
        return this.closeOnExpectationFailed && this.ignoreContentAfterContinueResponse(object);
    }

    @Override
    public boolean ignoreContentAfterContinueResponse(Object object) {
        if (object instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)object;
            return httpResponse.status().codeClass().equals((Object)HttpStatusClass.CLIENT_ERROR);
        }
        return false;
    }

    @Override
    protected FullHttpMessage beginAggregation(HttpMessage httpMessage, ByteBuf byteBuf) {
        HttpObjectAggregator$AggregatedFullHttpMessage httpObjectAggregator$AggregatedFullHttpMessage;
        assert (!(httpMessage instanceof FullHttpMessage));
        HttpUtil.setTransferEncodingChunked(httpMessage, false);
        if (httpMessage instanceof HttpRequest) {
            httpObjectAggregator$AggregatedFullHttpMessage = new HttpObjectAggregator$AggregatedFullHttpRequest((HttpRequest)httpMessage, byteBuf, null);
        } else if (httpMessage instanceof HttpResponse) {
            httpObjectAggregator$AggregatedFullHttpMessage = new HttpObjectAggregator$AggregatedFullHttpResponse((HttpResponse)httpMessage, byteBuf, null);
        } else {
            throw new Error();
        }
        return httpObjectAggregator$AggregatedFullHttpMessage;
    }

    @Override
    protected void aggregate(FullHttpMessage fullHttpMessage, HttpContent httpContent) {
        if (httpContent instanceof LastHttpContent) {
            ((HttpObjectAggregator$AggregatedFullHttpMessage)fullHttpMessage).setTrailingHeaders(((LastHttpContent)httpContent).trailingHeaders());
        }
    }

    @Override
    protected void finishAggregation(FullHttpMessage fullHttpMessage) {
        if (!HttpUtil.isContentLengthSet(fullHttpMessage)) {
            fullHttpMessage.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(fullHttpMessage.content().readableBytes()));
        }
    }

    @Override
    protected void handleOversizedMessage(ChannelHandlerContext channelHandlerContext, HttpMessage httpMessage) {
        if (httpMessage instanceof HttpRequest) {
            if (httpMessage instanceof FullHttpMessage || !HttpUtil.is100ContinueExpected(httpMessage) && !HttpUtil.isKeepAlive(httpMessage)) {
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(TOO_LARGE_CLOSE.retainedDuplicate());
                channelFuture.addListener(new HttpObjectAggregator$1(this, channelHandlerContext));
            } else {
                channelHandlerContext.writeAndFlush(TOO_LARGE.retainedDuplicate()).addListener(new HttpObjectAggregator$2(this, channelHandlerContext));
            }
        } else {
            if (httpMessage instanceof HttpResponse) {
                channelHandlerContext.close();
                throw new TooLongFrameException("Response entity too large: " + httpMessage);
            }
            throw new IllegalStateException();
        }
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }

    static {
        EXPECTATION_FAILED.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }
}

