/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;

final class HttpHeadersEncoder {
    private static final int COLON_AND_SPACE_SHORT = 14880;

    private HttpHeadersEncoder() {
    }

    static void encoderHeader(CharSequence charSequence, CharSequence charSequence2, ByteBuf byteBuf) {
        int n4 = charSequence.length();
        int n7 = charSequence2.length();
        int n8 = n4 + n7 + 4;
        byteBuf.ensureWritable(n8);
        int n10 = byteBuf.writerIndex();
        HttpHeadersEncoder.writeAscii(byteBuf, n10, charSequence);
        ByteBufUtil.setShortBE(byteBuf, n10 += n4, 14880);
        HttpHeadersEncoder.writeAscii(byteBuf, n10 += 2, charSequence2);
        ByteBufUtil.setShortBE(byteBuf, n10 += n7, 3338);
        byteBuf.writerIndex(n10 += 2);
    }

    private static void writeAscii(ByteBuf byteBuf, int n4, CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)charSequence, 0, byteBuf, n4, charSequence.length());
        } else {
            byteBuf.setCharSequence(n4, charSequence, CharsetUtil.US_ASCII);
        }
    }
}

