/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContentEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpContentEncoder$Result;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;

public class HttpContentCompressor
extends HttpContentEncoder {
    private final int compressionLevel;
    private final int windowBits;
    private final int memLevel;
    private final int contentSizeThreshold;
    private ChannelHandlerContext ctx;

    public HttpContentCompressor() {
        this(6);
    }

    public HttpContentCompressor(int n4) {
        this(n4, 15, 8, 0);
    }

    public HttpContentCompressor(int n4, int n7, int n8) {
        this(n4, n7, n8, 0);
    }

    public HttpContentCompressor(int n4, int n7, int n8, int n10) {
        if (n4 < 0 || n4 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n4 + " (expected: 0-9)");
        }
        if (n7 < 9 || n7 > 15) {
            throw new IllegalArgumentException("windowBits: " + n7 + " (expected: 9-15)");
        }
        if (n8 < 1 || n8 > 9) {
            throw new IllegalArgumentException("memLevel: " + n8 + " (expected: 1-9)");
        }
        if (n10 < 0) {
            throw new IllegalArgumentException("contentSizeThreshold: " + n10 + " (expected: non negative number)");
        }
        this.compressionLevel = n4;
        this.windowBits = n7;
        this.memLevel = n8;
        this.contentSizeThreshold = n10;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    protected HttpContentEncoder$Result beginEncode(HttpResponse httpResponse, String string) {
        String string2;
        if (this.contentSizeThreshold > 0 && httpResponse instanceof HttpContent && ((HttpContent)((Object)httpResponse)).content().readableBytes() < this.contentSizeThreshold) {
            return null;
        }
        String string3 = httpResponse.headers().get(HttpHeaderNames.CONTENT_ENCODING);
        if (string3 != null) {
            return null;
        }
        ZlibWrapper zlibWrapper = this.determineWrapper(string);
        if (zlibWrapper == null) {
            return null;
        }
        switch (zlibWrapper) {
            case GZIP: {
                string2 = "gzip";
                break;
            }
            case ZLIB: {
                string2 = "deflate";
                break;
            }
            default: {
                throw new Error();
            }
        }
        return new HttpContentEncoder$Result(string2, new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibEncoder(zlibWrapper, this.compressionLevel, this.windowBits, this.memLevel)));
    }

    protected ZlibWrapper determineWrapper(String string) {
        float f8 = -1.0f;
        float f9 = -1.0f;
        float f10 = -1.0f;
        for (String string2 : string.split(",")) {
            float f11 = 1.0f;
            int n4 = string2.indexOf(61);
            if (n4 != -1) {
                try {
                    f11 = Float.parseFloat(string2.substring(n4 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    f11 = 0.0f;
                }
            }
            if (string2.contains("*")) {
                f8 = f11;
                continue;
            }
            if (string2.contains("gzip") && f11 > f9) {
                f9 = f11;
                continue;
            }
            if (!string2.contains("deflate") || !(f11 > f10)) continue;
            f10 = f11;
        }
        if (f9 > 0.0f || f10 > 0.0f) {
            if (f9 >= f10) {
                return ZlibWrapper.GZIP;
            }
            return ZlibWrapper.ZLIB;
        }
        if (f8 > 0.0f) {
            if (f9 == -1.0f) {
                return ZlibWrapper.GZIP;
            }
            if (f10 == -1.0f) {
                return ZlibWrapper.ZLIB;
            }
        }
        return null;
    }
}

