/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpClientUpgradeHandler$SourceCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpClientUpgradeHandler$UpgradeCodec;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpClientUpgradeHandler$UpgradeEvent;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObject;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.util.LinkedHashSet;
import java.util.List;

public class HttpClientUpgradeHandler
extends HttpObjectAggregator
implements ChannelOutboundHandler {
    private final HttpClientUpgradeHandler$SourceCodec sourceCodec;
    private final HttpClientUpgradeHandler$UpgradeCodec upgradeCodec;
    private boolean upgradeRequested;

    public HttpClientUpgradeHandler(HttpClientUpgradeHandler$SourceCodec httpClientUpgradeHandler$SourceCodec, HttpClientUpgradeHandler$UpgradeCodec httpClientUpgradeHandler$UpgradeCodec, int n4) {
        super(n4);
        if (httpClientUpgradeHandler$SourceCodec == null) {
            throw new NullPointerException("sourceCodec");
        }
        if (httpClientUpgradeHandler$UpgradeCodec == null) {
            throw new NullPointerException("upgradeCodec");
        }
        this.sourceCodec = httpClientUpgradeHandler$SourceCodec;
        this.upgradeCodec = httpClientUpgradeHandler$UpgradeCodec;
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.read();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!(object instanceof HttpRequest)) {
            channelHandlerContext.write(object, channelPromise);
            return;
        }
        if (this.upgradeRequested) {
            channelPromise.setFailure(new IllegalStateException("Attempting to write HTTP request with upgrade in progress"));
            return;
        }
        this.upgradeRequested = true;
        this.setUpgradeRequestHeaders(channelHandlerContext, (HttpRequest)object);
        channelHandlerContext.write(object, channelPromise);
        channelHandlerContext.fireUserEventTriggered((Object)HttpClientUpgradeHandler$UpgradeEvent.UPGRADE_ISSUED);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        FullHttpResponse fullHttpResponse = null;
        try {
            Object object;
            if (!this.upgradeRequested) {
                throw new IllegalStateException("Read HTTP response without requesting protocol switch");
            }
            if (httpObject instanceof HttpResponse && !HttpResponseStatus.SWITCHING_PROTOCOLS.equals((object = (HttpResponse)httpObject).status())) {
                channelHandlerContext.fireUserEventTriggered((Object)HttpClientUpgradeHandler$UpgradeEvent.UPGRADE_REJECTED);
                HttpClientUpgradeHandler.removeThisHandler(channelHandlerContext);
                channelHandlerContext.fireChannelRead(httpObject);
                return;
            }
            if (httpObject instanceof FullHttpResponse) {
                fullHttpResponse = (FullHttpResponse)httpObject;
                fullHttpResponse.retain();
                list.add(fullHttpResponse);
            } else {
                super.decode(channelHandlerContext, httpObject, list);
                if (list.isEmpty()) {
                    return;
                }
                assert (list.size() == 1);
                fullHttpResponse = (FullHttpResponse)list.get(0);
            }
            object = fullHttpResponse.headers().get(HttpHeaderNames.UPGRADE);
            if (object != null && !AsciiString.contentEqualsIgnoreCase(this.upgradeCodec.protocol(), (CharSequence)object)) {
                throw new IllegalStateException("Switching Protocols response with unexpected UPGRADE protocol: " + object);
            }
            this.sourceCodec.prepareUpgradeFrom(channelHandlerContext);
            this.upgradeCodec.upgradeTo(channelHandlerContext, fullHttpResponse);
            channelHandlerContext.fireUserEventTriggered((Object)HttpClientUpgradeHandler$UpgradeEvent.UPGRADE_SUCCESSFUL);
            this.sourceCodec.upgradeFrom(channelHandlerContext);
            fullHttpResponse.release();
            list.clear();
            HttpClientUpgradeHandler.removeThisHandler(channelHandlerContext);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(fullHttpResponse);
            channelHandlerContext.fireExceptionCaught(throwable);
            HttpClientUpgradeHandler.removeThisHandler(channelHandlerContext);
        }
    }

    private static void removeThisHandler(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.pipeline().remove(channelHandlerContext.name());
    }

    private void setUpgradeRequestHeaders(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        httpRequest.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)this.upgradeCodec.protocol());
        LinkedHashSet<CharSequence> linkedHashSet = new LinkedHashSet<CharSequence>(2);
        linkedHashSet.addAll(this.upgradeCodec.setUpgradeHeaders(channelHandlerContext, httpRequest));
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : linkedHashSet) {
            stringBuilder.append(charSequence);
            stringBuilder.append(',');
        }
        stringBuilder.append(HttpHeaderValues.UPGRADE);
        httpRequest.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)stringBuilder.toString());
    }
}

