/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.handler.codec.http.CombinedHttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpObject;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMessage;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public abstract class DefaultHttpMessage
extends DefaultHttpObject
implements HttpMessage {
    private static final int HASH_CODE_PRIME = 31;
    private HttpVersion version;
    private final HttpHeaders headers;

    protected DefaultHttpMessage(HttpVersion httpVersion) {
        this(httpVersion, true, false);
    }

    protected DefaultHttpMessage(HttpVersion httpVersion, boolean bl3, boolean bl4) {
        this(httpVersion, bl4 ? new CombinedHttpHeaders(bl3) : new DefaultHttpHeaders(bl3));
    }

    protected DefaultHttpMessage(HttpVersion httpVersion, HttpHeaders httpHeaders) {
        this.version = ObjectUtil.checkNotNull(httpVersion, "version");
        this.headers = ObjectUtil.checkNotNull(httpHeaders, "headers");
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    @Deprecated
    public HttpVersion getProtocolVersion() {
        return this.protocolVersion();
    }

    @Override
    public HttpVersion protocolVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        int n4 = 1;
        n4 = 31 * n4 + this.headers.hashCode();
        n4 = 31 * n4 + this.version.hashCode();
        n4 = 31 * n4 + super.hashCode();
        return n4;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttpMessage)) {
            return false;
        }
        DefaultHttpMessage defaultHttpMessage = (DefaultHttpMessage)object;
        return this.headers().equals(defaultHttpMessage.headers()) && this.protocolVersion().equals(defaultHttpMessage.protocolVersion()) && super.equals(object);
    }

    @Override
    public HttpMessage setProtocolVersion(HttpVersion httpVersion) {
        if (httpVersion == null) {
            throw new NullPointerException("version");
        }
        this.version = httpVersion;
        return this;
    }
}

