/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultHttpHeaders$HeaderValueConverter;

final class DefaultHttpHeaders$HeaderValueConverterAndValidator
extends DefaultHttpHeaders$HeaderValueConverter {
    static final DefaultHttpHeaders$HeaderValueConverterAndValidator INSTANCE = new DefaultHttpHeaders$HeaderValueConverterAndValidator();

    private DefaultHttpHeaders$HeaderValueConverterAndValidator() {
        super(null);
    }

    @Override
    public CharSequence convertObject(Object object) {
        CharSequence charSequence = super.convertObject(object);
        int n4 = 0;
        for (int i3 = 0; i3 < charSequence.length(); ++i3) {
            n4 = DefaultHttpHeaders$HeaderValueConverterAndValidator.validateValueChar(charSequence, n4, charSequence.charAt(i3));
        }
        if (n4 != 0) {
            throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + charSequence);
        }
        return charSequence;
    }

    private static int validateValueChar(CharSequence charSequence, int n4, char c10) {
        if ((c10 & 0xFFFFFFF0) == 0) {
            switch (c10) {
                case '\u0000': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\u0000': " + charSequence);
                }
                case '\u000b': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\v': " + charSequence);
                }
                case '\f': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\f': " + charSequence);
                }
            }
        }
        switch (n4) {
            case 0: {
                switch (c10) {
                    case '\r': {
                        return 1;
                    }
                    case '\n': {
                        return 2;
                    }
                }
                break;
            }
            case 1: {
                switch (c10) {
                    case '\n': {
                        return 2;
                    }
                }
                throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + charSequence);
            }
            case 2: {
                switch (c10) {
                    case '\t': 
                    case ' ': {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + charSequence);
            }
        }
        return n4;
    }
}

