/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.http;

import io.grpc.netty.shaded.io.netty.handler.codec.DateFormatter;
import io.grpc.netty.shaded.io.netty.handler.codec.http.Cookie;
import io.grpc.netty.shaded.io.netty.handler.codec.http.CookieUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultCookie;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@Deprecated
public final class CookieDecoder {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    private static final CookieDecoder STRICT = new CookieDecoder(true);
    private static final CookieDecoder LAX = new CookieDecoder(false);
    private static final String COMMENT = "Comment";
    private static final String COMMENTURL = "CommentURL";
    private static final String DISCARD = "Discard";
    private static final String PORT = "Port";
    private static final String VERSION = "Version";
    private final boolean strict;

    public static Set<Cookie> decode(String string) {
        return CookieDecoder.decode(string, true);
    }

    public static Set<Cookie> decode(String string, boolean bl3) {
        return (bl3 ? STRICT : LAX).doDecode(string);
    }

    private Set<Cookie> doDecode(String string) {
        int n4;
        ArrayList<String> arrayList = new ArrayList<String>(8);
        ArrayList<String> arrayList2 = new ArrayList<String>(8);
        CookieDecoder.extractKeyValuePairs(string, arrayList, arrayList2);
        if (arrayList.isEmpty()) {
            return Collections.emptySet();
        }
        int n7 = 0;
        if (((String)arrayList.get(0)).equalsIgnoreCase(VERSION)) {
            try {
                n7 = Integer.parseInt((String)arrayList2.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            n4 = 1;
        } else {
            n4 = 0;
        }
        if (arrayList.size() <= n4) {
            return Collections.emptySet();
        }
        TreeSet<Cookie> treeSet = new TreeSet<Cookie>();
        while (n4 < arrayList.size()) {
            DefaultCookie defaultCookie;
            String string2 = (String)arrayList.get(n4);
            String string3 = (String)arrayList2.get(n4);
            if (string3 == null) {
                string3 = "";
            }
            if ((defaultCookie = this.initCookie(string2, string3)) == null) break;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            long l2 = Long.MIN_VALUE;
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>(2);
            int n8 = n4 + 1;
            while (n8 < arrayList.size()) {
                String[] stringArray;
                string2 = (String)arrayList.get(n8);
                string3 = (String)arrayList2.get(n8);
                if (DISCARD.equalsIgnoreCase(string2)) {
                    bl3 = true;
                } else if ("Secure".equalsIgnoreCase(string2)) {
                    bl4 = true;
                } else if ("HTTPOnly".equalsIgnoreCase(string2)) {
                    bl5 = true;
                } else if (COMMENT.equalsIgnoreCase(string2)) {
                    string4 = string3;
                } else if (COMMENTURL.equalsIgnoreCase(string2)) {
                    string5 = string3;
                } else if ("Domain".equalsIgnoreCase(string2)) {
                    string6 = string3;
                } else if ("Path".equalsIgnoreCase(string2)) {
                    string7 = string3;
                } else if ("Expires".equalsIgnoreCase(string2)) {
                    stringArray = DateFormatter.parseHttpDate(string3);
                    if (stringArray != null) {
                        long l10 = stringArray.getTime() - System.currentTimeMillis();
                        l2 = l10 / 1000L + (long)(l10 % 1000L != 0L ? 1 : 0);
                    }
                } else if ("Max-Age".equalsIgnoreCase(string2)) {
                    l2 = Integer.parseInt(string3);
                } else if (VERSION.equalsIgnoreCase(string2)) {
                    n7 = Integer.parseInt(string3);
                } else {
                    if (!PORT.equalsIgnoreCase(string2)) break;
                    for (String string8 : stringArray = string3.split(",")) {
                        try {
                            arrayList3.add(Integer.valueOf(string8));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                ++n8;
                ++n4;
            }
            defaultCookie.setVersion(n7);
            defaultCookie.setMaxAge(l2);
            defaultCookie.setPath(string7);
            defaultCookie.setDomain(string6);
            defaultCookie.setSecure(bl4);
            defaultCookie.setHttpOnly(bl5);
            if (n7 > 0) {
                defaultCookie.setComment(string4);
            }
            if (n7 > 1) {
                defaultCookie.setCommentUrl(string5);
                defaultCookie.setPorts(arrayList3);
                defaultCookie.setDiscard(bl3);
            }
            treeSet.add(defaultCookie);
            ++n4;
        }
        return treeSet;
    }

    private static void extractKeyValuePairs(String string, List<String> list, List<String> list2) {
        int n4 = string.length();
        int n7 = 0;
        block10: while (n7 != n4) {
            switch (string.charAt(n7)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ';': {
                    ++n7;
                    continue block10;
                }
            }
            while (n7 != n4) {
                String string2;
                String string3;
                if (string.charAt(n7) == '$') {
                    ++n7;
                    continue;
                }
                if (n7 == n4) {
                    string3 = null;
                    string2 = null;
                } else {
                    int n8 = n7;
                    block12: while (true) {
                        switch (string.charAt(n7)) {
                            case ';': {
                                string3 = string.substring(n8, n7);
                                string2 = null;
                                break block12;
                            }
                            case '=': {
                                string3 = string.substring(n8, n7);
                                if (++n7 == n4) {
                                    string2 = "";
                                    break block12;
                                }
                                int n10 = n7;
                                char c10 = string.charAt(n7);
                                if (c10 == '\"' || c10 == '\'') {
                                    StringBuilder stringBuilder = new StringBuilder(string.length() - n7);
                                    char c11 = c10;
                                    boolean bl3 = false;
                                    ++n7;
                                    block13: while (true) {
                                        if (n7 == n4) {
                                            string2 = stringBuilder.toString();
                                            break block12;
                                        }
                                        if (bl3) {
                                            bl3 = false;
                                            c10 = string.charAt(n7++);
                                            switch (c10) {
                                                case '\"': 
                                                case '\'': 
                                                case '\\': {
                                                    stringBuilder.setCharAt(stringBuilder.length() - 1, c10);
                                                    continue block13;
                                                }
                                            }
                                            stringBuilder.append(c10);
                                            continue;
                                        }
                                        if ((c10 = string.charAt(n7++)) == c11) {
                                            string2 = stringBuilder.toString();
                                            break block12;
                                        }
                                        stringBuilder.append(c10);
                                        if (c10 != '\\') continue;
                                        bl3 = true;
                                    }
                                }
                                int n11 = string.indexOf(59, n7);
                                if (n11 > 0) {
                                    string2 = string.substring(n10, n11);
                                    n7 = n11;
                                    break block12;
                                }
                                string2 = string.substring(n10);
                                n7 = n4;
                                break block12;
                            }
                            default: {
                                if (++n7 != n4) continue block12;
                                string3 = string.substring(n8);
                                string2 = null;
                                break block12;
                            }
                        }
                        break;
                    }
                }
                list.add(string3);
                list2.add(string2);
                continue block10;
            }
            break block10;
        }
    }

    private CookieDecoder(boolean bl3) {
        this.strict = bl3;
    }

    private DefaultCookie initCookie(String string, String string2) {
        boolean bl3;
        int n4;
        if (string == null || string.length() == 0) {
            this.logger.debug("Skipping cookie with null name");
            return null;
        }
        if (string2 == null) {
            this.logger.debug("Skipping cookie with null value");
            return null;
        }
        CharSequence charSequence = CookieUtil.unwrapValue(string2);
        if (charSequence == null) {
            this.logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)charSequence);
            return null;
        }
        if (this.strict && (n4 = CookieUtil.firstInvalidCookieNameOctet(string)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)string, (Object)Character.valueOf(string.charAt(n4)));
            }
            return null;
        }
        boolean bl4 = bl3 = charSequence.length() != string2.length();
        if (this.strict && (n4 = CookieUtil.firstInvalidCookieValueOctet(charSequence)) >= 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)charSequence, (Object)Character.valueOf(charSequence.charAt(n4)));
            }
            return null;
        }
        DefaultCookie defaultCookie = new DefaultCookie(string, charSequence.toString());
        defaultCookie.setWrap(bl3);
        return defaultCookie;
    }
}

