/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.Inflater;
import com.jcraft.jzlib.JZlib;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.CompressionException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;

final class ZlibUtil {
    static void fail(Inflater inflater, String string, int n4) {
        throw ZlibUtil.inflaterException(inflater, string, n4);
    }

    static void fail(Deflater deflater, String string, int n4) {
        throw ZlibUtil.deflaterException(deflater, string, n4);
    }

    static DecompressionException inflaterException(Inflater inflater, String string, int n4) {
        return new DecompressionException(string + " (" + n4 + ')' + (inflater.msg != null ? ": " + inflater.msg : ""));
    }

    static CompressionException deflaterException(Deflater deflater, String string, int n4) {
        return new CompressionException(string + " (" + n4 + ')' + (deflater.msg != null ? ": " + deflater.msg : ""));
    }

    static JZlib.WrapperType convertWrapperType(ZlibWrapper zlibWrapper) {
        JZlib.WrapperType wrapperType;
        switch (zlibWrapper) {
            case NONE: {
                wrapperType = JZlib.W_NONE;
                break;
            }
            case ZLIB: {
                wrapperType = JZlib.W_ZLIB;
                break;
            }
            case GZIP: {
                wrapperType = JZlib.W_GZIP;
                break;
            }
            case ZLIB_OR_NONE: {
                wrapperType = JZlib.W_ANY;
                break;
            }
            default: {
                throw new Error();
            }
        }
        return wrapperType;
    }

    static int wrapperOverhead(ZlibWrapper zlibWrapper) {
        int n4;
        switch (zlibWrapper) {
            case NONE: {
                n4 = 0;
                break;
            }
            case ZLIB: 
            case ZLIB_OR_NONE: {
                n4 = 2;
                break;
            }
            case GZIP: {
                n4 = 10;
                break;
            }
            default: {
                throw new Error();
            }
        }
        return n4;
    }

    private ZlibUtil() {
    }
}

