/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.handler.codec.compression.JZlibDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.JZlibEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.JdkZlibDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.JdkZlibEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ZlibCodecFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ZlibCodecFactory.class);
    private static final int DEFAULT_JDK_WINDOW_SIZE = 15;
    private static final int DEFAULT_JDK_MEM_LEVEL = 8;
    private static final boolean noJdkZlibDecoder = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.noJdkZlibDecoder", PlatformDependent.javaVersion() < 7);
    private static final boolean noJdkZlibEncoder;
    private static final boolean supportsWindowSizeAndMemLevel;

    public static boolean isSupportingWindowSizeAndMemLevel() {
        return supportsWindowSizeAndMemLevel;
    }

    public static ZlibEncoder newZlibEncoder(int n4) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(n4);
        }
        return new JdkZlibEncoder(n4);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper zlibWrapper) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(zlibWrapper);
        }
        return new JdkZlibEncoder(zlibWrapper);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper zlibWrapper, int n4) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(zlibWrapper, n4);
        }
        return new JdkZlibEncoder(zlibWrapper, n4);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper zlibWrapper, int n4, int n7, int n8) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder || n7 != 15 || n8 != 8) {
            return new JZlibEncoder(zlibWrapper, n4, n7, n8);
        }
        return new JdkZlibEncoder(zlibWrapper, n4);
    }

    public static ZlibEncoder newZlibEncoder(byte[] byArray) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(byArray);
        }
        return new JdkZlibEncoder(byArray);
    }

    public static ZlibEncoder newZlibEncoder(int n4, byte[] byArray) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(n4, byArray);
        }
        return new JdkZlibEncoder(n4, byArray);
    }

    public static ZlibEncoder newZlibEncoder(int n4, int n7, int n8, byte[] byArray) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder || n7 != 15 || n8 != 8) {
            return new JZlibEncoder(n4, n7, n8, byArray);
        }
        return new JdkZlibEncoder(n4, byArray);
    }

    public static ZlibDecoder newZlibDecoder() {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibDecoder) {
            return new JZlibDecoder();
        }
        return new JdkZlibDecoder(true);
    }

    public static ZlibDecoder newZlibDecoder(ZlibWrapper zlibWrapper) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibDecoder) {
            return new JZlibDecoder(zlibWrapper);
        }
        return new JdkZlibDecoder(zlibWrapper, true);
    }

    public static ZlibDecoder newZlibDecoder(byte[] byArray) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibDecoder) {
            return new JZlibDecoder(byArray);
        }
        return new JdkZlibDecoder(byArray);
    }

    private ZlibCodecFactory() {
    }

    static {
        logger.debug("-Dio.netty.noJdkZlibDecoder: {}", (Object)noJdkZlibDecoder);
        noJdkZlibEncoder = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.noJdkZlibEncoder", false);
        logger.debug("-Dio.netty.noJdkZlibEncoder: {}", (Object)noJdkZlibEncoder);
        supportsWindowSizeAndMemLevel = noJdkZlibDecoder || PlatformDependent.javaVersion() >= 7;
    }
}

