/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.CompressionException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Snappy;

public class SnappyFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final int MIN_COMPRESSIBLE_LENGTH = 18;
    private static final byte[] STREAM_START = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    private final Snappy snappy = new Snappy();
    private boolean started;

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        block6: {
            int n4;
            if (!byteBuf.isReadable()) {
                return;
            }
            if (!this.started) {
                this.started = true;
                byteBuf2.writeBytes(STREAM_START);
            }
            if ((n4 = byteBuf.readableBytes()) > 18) {
                ByteBuf byteBuf3;
                int n7;
                while (true) {
                    n7 = byteBuf2.writerIndex() + 1;
                    if (n4 < 18) {
                        byteBuf3 = byteBuf.readSlice(n4);
                        SnappyFrameEncoder.writeUnencodedChunk(byteBuf3, byteBuf2, n4);
                        break block6;
                    }
                    byteBuf2.writeInt(0);
                    if (n4 <= Short.MAX_VALUE) break;
                    byteBuf3 = byteBuf.readSlice(Short.MAX_VALUE);
                    SnappyFrameEncoder.calculateAndWriteChecksum(byteBuf3, byteBuf2);
                    this.snappy.encode(byteBuf3, byteBuf2, Short.MAX_VALUE);
                    SnappyFrameEncoder.setChunkLength(byteBuf2, n7);
                    n4 -= Short.MAX_VALUE;
                }
                byteBuf3 = byteBuf.readSlice(n4);
                SnappyFrameEncoder.calculateAndWriteChecksum(byteBuf3, byteBuf2);
                this.snappy.encode(byteBuf3, byteBuf2, n4);
                SnappyFrameEncoder.setChunkLength(byteBuf2, n7);
            } else {
                SnappyFrameEncoder.writeUnencodedChunk(byteBuf, byteBuf2, n4);
            }
        }
    }

    private static void writeUnencodedChunk(ByteBuf byteBuf, ByteBuf byteBuf2, int n4) {
        byteBuf2.writeByte(1);
        SnappyFrameEncoder.writeChunkLength(byteBuf2, n4 + 4);
        SnappyFrameEncoder.calculateAndWriteChecksum(byteBuf, byteBuf2);
        byteBuf2.writeBytes(byteBuf, n4);
    }

    private static void setChunkLength(ByteBuf byteBuf, int n4) {
        int n7 = byteBuf.writerIndex() - n4 - 3;
        if (n7 >>> 24 != 0) {
            throw new CompressionException("compressed data too large: " + n7);
        }
        byteBuf.setMediumLE(n4, n7);
    }

    private static void writeChunkLength(ByteBuf byteBuf, int n4) {
        byteBuf.writeMediumLE(n4);
    }

    private static void calculateAndWriteChecksum(ByteBuf byteBuf, ByteBuf byteBuf2) {
        byteBuf2.writeIntLE(Snappy.calculateChecksum(byteBuf));
    }
}

