/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Crc32c;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Snappy$State;

public final class Snappy {
    private static final int MAX_HT_SIZE = 16384;
    private static final int MIN_COMPRESSIBLE_BYTES = 15;
    private static final int PREAMBLE_NOT_FULL = -1;
    private static final int NOT_ENOUGH_INPUT = -1;
    private static final int LITERAL = 0;
    private static final int COPY_1_BYTE_OFFSET = 1;
    private static final int COPY_2_BYTE_OFFSET = 2;
    private static final int COPY_4_BYTE_OFFSET = 3;
    private Snappy$State state = Snappy$State.READY;
    private byte tag;
    private int written;

    public void reset() {
        this.state = Snappy$State.READY;
        this.tag = 0;
        this.written = 0;
    }

    public void encode(ByteBuf byteBuf, ByteBuf byteBuf2, int n4) {
        int n7;
        int n8 = 0;
        while (true) {
            if (((n7 = n4 >>> n8 * 7) & 0xFFFFFF80) == 0) break;
            byteBuf2.writeByte(n7 & 0x7F | 0x80);
            ++n8;
        }
        byteBuf2.writeByte(n7);
        n7 = n8 = byteBuf.readerIndex();
        short[] sArray = Snappy.getHashTable(n4);
        int n10 = Integer.numberOfLeadingZeros(sArray.length) + 1;
        int n11 = n8;
        if (n4 - n8 >= 15) {
            int n12 = Snappy.hash(byteBuf, ++n8, n10);
            block1: while (true) {
                int n13;
                int n14;
                int n15;
                int n16 = 32;
                int n17 = n8;
                do {
                    n8 = n17;
                    n14 = n12;
                    if ((n17 = n8 + (n13 = n16++ >> 5)) > n4 - 4) break block1;
                    n12 = Snappy.hash(byteBuf, n17, n10);
                    n15 = n7 + sArray[n14];
                    sArray[n14] = (short)(n8 - n7);
                } while (byteBuf.getInt(n8) != byteBuf.getInt(n15));
                Snappy.encodeLiteral(byteBuf, byteBuf2, n8 - n11);
                do {
                    n13 = n8;
                    int n18 = 4 + Snappy.findMatchingLength(byteBuf, n15 + 4, n8 + 4, n4);
                    int n19 = n13 - n15;
                    Snappy.encodeCopy(byteBuf2, n19, n18);
                    byteBuf.readerIndex(byteBuf.readerIndex() + n18);
                    n14 = (n8 += n18) - 1;
                    n11 = n8;
                    if (n8 >= n4 - 4) break block1;
                    int n20 = Snappy.hash(byteBuf, n14, n10);
                    sArray[n20] = (short)(n8 - n7 - 1);
                    int n21 = Snappy.hash(byteBuf, n14 + 1, n10);
                    n15 = n7 + sArray[n21];
                    sArray[n21] = (short)(n8 - n7);
                } while (byteBuf.getInt(n14 + 1) == byteBuf.getInt(n15));
                n12 = Snappy.hash(byteBuf, n14 + 2, n10);
                ++n8;
            }
        }
        if (n11 < n4) {
            Snappy.encodeLiteral(byteBuf, byteBuf2, n4 - n11);
        }
    }

    private static int hash(ByteBuf byteBuf, int n4, int n7) {
        return byteBuf.getInt(n4) * 506832829 >>> n7;
    }

    private static short[] getHashTable(int n4) {
        int n7;
        for (n7 = 256; n7 < 16384 && n7 < n4; n7 <<= 1) {
        }
        return new short[n7];
    }

    private static int findMatchingLength(ByteBuf byteBuf, int n4, int n7, int n8) {
        int n10 = 0;
        while (n7 <= n8 - 4 && byteBuf.getInt(n7) == byteBuf.getInt(n4 + n10)) {
            n7 += 4;
            n10 += 4;
        }
        while (n7 < n8 && byteBuf.getByte(n4 + n10) == byteBuf.getByte(n7)) {
            ++n7;
            ++n10;
        }
        return n10;
    }

    private static int bitsToEncode(int n4) {
        int n7 = Integer.highestOneBit(n4);
        int n8 = 0;
        while ((n7 >>= 1) != 0) {
            ++n8;
        }
        return n8;
    }

    static void encodeLiteral(ByteBuf byteBuf, ByteBuf byteBuf2, int n4) {
        if (n4 < 61) {
            byteBuf2.writeByte(n4 - 1 << 2);
        } else {
            int n7 = Snappy.bitsToEncode(n4 - 1);
            int n8 = 1 + n7 / 8;
            byteBuf2.writeByte(59 + n8 << 2);
            for (int i3 = 0; i3 < n8; ++i3) {
                byteBuf2.writeByte(n4 - 1 >> i3 * 8 & 0xFF);
            }
        }
        byteBuf2.writeBytes(byteBuf, n4);
    }

    private static void encodeCopyWithOffset(ByteBuf byteBuf, int n4, int n7) {
        if (n7 < 12 && n4 < 2048) {
            byteBuf.writeByte(1 | n7 - 4 << 2 | n4 >> 8 << 5);
            byteBuf.writeByte(n4 & 0xFF);
        } else {
            byteBuf.writeByte(2 | n7 - 1 << 2);
            byteBuf.writeByte(n4 & 0xFF);
            byteBuf.writeByte(n4 >> 8 & 0xFF);
        }
    }

    private static void encodeCopy(ByteBuf byteBuf, int n4, int n7) {
        while (n7 >= 68) {
            Snappy.encodeCopyWithOffset(byteBuf, n4, 64);
            n7 -= 64;
        }
        if (n7 > 64) {
            Snappy.encodeCopyWithOffset(byteBuf, n4, 60);
            n7 -= 60;
        }
        Snappy.encodeCopyWithOffset(byteBuf, n4, n7);
    }

    public void decode(ByteBuf byteBuf, ByteBuf byteBuf2) {
        while (byteBuf.isReadable()) {
            block0 : switch (this.state) {
                case READY: {
                    this.state = Snappy$State.READING_PREAMBLE;
                }
                case READING_PREAMBLE: {
                    int n4 = Snappy.readPreamble(byteBuf);
                    if (n4 == -1) {
                        return;
                    }
                    if (n4 == 0) {
                        this.state = Snappy$State.READY;
                        return;
                    }
                    byteBuf2.ensureWritable(n4);
                    this.state = Snappy$State.READING_TAG;
                }
                case READING_TAG: {
                    if (!byteBuf.isReadable()) {
                        return;
                    }
                    this.tag = byteBuf.readByte();
                    switch (this.tag & 3) {
                        case 0: {
                            this.state = Snappy$State.READING_LITERAL;
                            break block0;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            this.state = Snappy$State.READING_COPY;
                        }
                    }
                    break;
                }
                case READING_LITERAL: {
                    int n7 = Snappy.decodeLiteral(this.tag, byteBuf, byteBuf2);
                    if (n7 != -1) {
                        this.state = Snappy$State.READING_TAG;
                        this.written += n7;
                        break;
                    }
                    return;
                }
                case READING_COPY: {
                    switch (this.tag & 3) {
                        case 1: {
                            int n8 = Snappy.decodeCopyWith1ByteOffset(this.tag, byteBuf, byteBuf2, this.written);
                            if (n8 != -1) {
                                this.state = Snappy$State.READING_TAG;
                                this.written += n8;
                                break block0;
                            }
                            return;
                        }
                        case 2: {
                            int n8 = Snappy.decodeCopyWith2ByteOffset(this.tag, byteBuf, byteBuf2, this.written);
                            if (n8 != -1) {
                                this.state = Snappy$State.READING_TAG;
                                this.written += n8;
                                break block0;
                            }
                            return;
                        }
                        case 3: {
                            int n8 = Snappy.decodeCopyWith4ByteOffset(this.tag, byteBuf, byteBuf2, this.written);
                            if (n8 != -1) {
                                this.state = Snappy$State.READING_TAG;
                                this.written += n8;
                                break block0;
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    private static int readPreamble(ByteBuf byteBuf) {
        int n4 = 0;
        int n7 = 0;
        while (byteBuf.isReadable()) {
            short s11 = byteBuf.readUnsignedByte();
            n4 |= (s11 & 0x7F) << n7++ * 7;
            if ((s11 & 0x80) == 0) {
                return n4;
            }
            if (n7 < 4) continue;
            throw new DecompressionException("Preamble is greater than 4 bytes");
        }
        return 0;
    }

    static int decodeLiteral(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n4;
        byteBuf.markReaderIndex();
        switch (by2 >> 2 & 0x3F) {
            case 60: {
                if (!byteBuf.isReadable()) {
                    return -1;
                }
                n4 = byteBuf.readUnsignedByte();
                break;
            }
            case 61: {
                if (byteBuf.readableBytes() < 2) {
                    return -1;
                }
                n4 = byteBuf.readUnsignedShortLE();
                break;
            }
            case 62: {
                if (byteBuf.readableBytes() < 3) {
                    return -1;
                }
                n4 = byteBuf.readUnsignedMediumLE();
                break;
            }
            case 63: {
                if (byteBuf.readableBytes() < 4) {
                    return -1;
                }
                n4 = byteBuf.readIntLE();
                break;
            }
            default: {
                n4 = by2 >> 2 & 0x3F;
            }
        }
        if (byteBuf.readableBytes() < ++n4) {
            byteBuf.resetReaderIndex();
            return -1;
        }
        byteBuf2.writeBytes(byteBuf, n4);
        return n4;
    }

    private static int decodeCopyWith1ByteOffset(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2, int n4) {
        if (!byteBuf.isReadable()) {
            return -1;
        }
        int n7 = byteBuf2.writerIndex();
        int n8 = 4 + ((by2 & 0x1C) >> 2);
        int n10 = (by2 & 0xE0) << 8 >> 5 | byteBuf.readUnsignedByte();
        Snappy.validateOffset(n10, n4);
        byteBuf2.markReaderIndex();
        if (n10 < n8) {
            for (int i3 = n8 / n10; i3 > 0; --i3) {
                byteBuf2.readerIndex(n7 - n10);
                byteBuf2.readBytes(byteBuf2, n10);
            }
            if (n8 % n10 != 0) {
                byteBuf2.readerIndex(n7 - n10);
                byteBuf2.readBytes(byteBuf2, n8 % n10);
            }
        } else {
            byteBuf2.readerIndex(n7 - n10);
            byteBuf2.readBytes(byteBuf2, n8);
        }
        byteBuf2.resetReaderIndex();
        return n8;
    }

    private static int decodeCopyWith2ByteOffset(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2, int n4) {
        if (byteBuf.readableBytes() < 2) {
            return -1;
        }
        int n7 = byteBuf2.writerIndex();
        int n8 = 1 + (by2 >> 2 & 0x3F);
        int n10 = byteBuf.readUnsignedShortLE();
        Snappy.validateOffset(n10, n4);
        byteBuf2.markReaderIndex();
        if (n10 < n8) {
            for (int i3 = n8 / n10; i3 > 0; --i3) {
                byteBuf2.readerIndex(n7 - n10);
                byteBuf2.readBytes(byteBuf2, n10);
            }
            if (n8 % n10 != 0) {
                byteBuf2.readerIndex(n7 - n10);
                byteBuf2.readBytes(byteBuf2, n8 % n10);
            }
        } else {
            byteBuf2.readerIndex(n7 - n10);
            byteBuf2.readBytes(byteBuf2, n8);
        }
        byteBuf2.resetReaderIndex();
        return n8;
    }

    private static int decodeCopyWith4ByteOffset(byte by2, ByteBuf byteBuf, ByteBuf byteBuf2, int n4) {
        if (byteBuf.readableBytes() < 4) {
            return -1;
        }
        int n7 = byteBuf2.writerIndex();
        int n8 = 1 + (by2 >> 2 & 0x3F);
        int n10 = byteBuf.readIntLE();
        Snappy.validateOffset(n10, n4);
        byteBuf2.markReaderIndex();
        if (n10 < n8) {
            for (int i3 = n8 / n10; i3 > 0; --i3) {
                byteBuf2.readerIndex(n7 - n10);
                byteBuf2.readBytes(byteBuf2, n10);
            }
            if (n8 % n10 != 0) {
                byteBuf2.readerIndex(n7 - n10);
                byteBuf2.readBytes(byteBuf2, n8 % n10);
            }
        } else {
            byteBuf2.readerIndex(n7 - n10);
            byteBuf2.readBytes(byteBuf2, n8);
        }
        byteBuf2.resetReaderIndex();
        return n8;
    }

    private static void validateOffset(int n4, int n7) {
        if (n4 == 0) {
            throw new DecompressionException("Offset is less than minimum permissible value");
        }
        if (n4 < 0) {
            throw new DecompressionException("Offset is greater than maximum value supported by this implementation");
        }
        if (n4 > n7) {
            throw new DecompressionException("Offset exceeds size of chunk");
        }
    }

    static int calculateChecksum(ByteBuf byteBuf) {
        return Snappy.calculateChecksum(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calculateChecksum(ByteBuf byteBuf, int n4, int n7) {
        Crc32c crc32c = new Crc32c();
        try {
            crc32c.update(byteBuf, n4, n7);
            int n8 = Snappy.maskChecksum((int)crc32c.getValue());
            return n8;
        }
        finally {
            crc32c.reset();
        }
    }

    static void validateChecksum(int n4, ByteBuf byteBuf) {
        Snappy.validateChecksum(n4, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    static void validateChecksum(int n4, ByteBuf byteBuf, int n7, int n8) {
        int n10 = Snappy.calculateChecksum(byteBuf, n7, n8);
        if (n10 != n4) {
            throw new DecompressionException("mismatching checksum: " + Integer.toHexString(n10) + " (expected: " + Integer.toHexString(n4) + ')');
        }
    }

    static int maskChecksum(int n4) {
        return (n4 >> 15 | n4 << 17) + -1568478504;
    }
}

