/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufInputStream;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufOutputStream;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.lzma.Encoder;

public class LzmaFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LzmaFrameEncoder.class);
    private static final int MEDIUM_DICTIONARY_SIZE = 65536;
    private static final int MIN_FAST_BYTES = 5;
    private static final int MEDIUM_FAST_BYTES = 32;
    private static final int MAX_FAST_BYTES = 273;
    private static final int DEFAULT_MATCH_FINDER = 1;
    private static final int DEFAULT_LC = 3;
    private static final int DEFAULT_LP = 0;
    private static final int DEFAULT_PB = 2;
    private final Encoder encoder;
    private final byte properties;
    private final int littleEndianDictionarySize;
    private static boolean warningLogged;

    public LzmaFrameEncoder() {
        this(65536);
    }

    public LzmaFrameEncoder(int n4, int n7, int n8) {
        this(n4, n7, n8, 65536);
    }

    public LzmaFrameEncoder(int n4) {
        this(3, 0, 2, n4);
    }

    public LzmaFrameEncoder(int n4, int n7, int n8, int n10) {
        this(n4, n7, n8, n10, false, 32);
    }

    public LzmaFrameEncoder(int n4, int n7, int n8, int n10, boolean bl3, int n11) {
        if (n4 < 0 || n4 > 8) {
            throw new IllegalArgumentException("lc: " + n4 + " (expected: 0-8)");
        }
        if (n7 < 0 || n7 > 4) {
            throw new IllegalArgumentException("lp: " + n7 + " (expected: 0-4)");
        }
        if (n8 < 0 || n8 > 4) {
            throw new IllegalArgumentException("pb: " + n8 + " (expected: 0-4)");
        }
        if (n4 + n7 > 4 && !warningLogged) {
            logger.warn("The latest versions of LZMA libraries (for example, XZ Utils) has an additional requirement: lc + lp <= 4. Data which don't follow this requirement cannot be decompressed with this libraries.");
            warningLogged = true;
        }
        if (n10 < 0) {
            throw new IllegalArgumentException("dictionarySize: " + n10 + " (expected: 0+)");
        }
        if (n11 < 5 || n11 > 273) {
            throw new IllegalArgumentException(String.format("numFastBytes: %d (expected: %d-%d)", n11, 5, 273));
        }
        this.encoder = new Encoder();
        this.encoder.setDictionarySize(n10);
        this.encoder.setEndMarkerMode(bl3);
        this.encoder.setMatchFinder(1);
        this.encoder.setNumFastBytes(n11);
        this.encoder.setLcLpPb(n4, n7, n8);
        this.properties = (byte)((n8 * 5 + n7) * 9 + n4);
        this.littleEndianDictionarySize = Integer.reverseBytes(n10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n4 = byteBuf.readableBytes();
        ByteBufInputStream byteBufInputStream = null;
        OutputStream outputStream = null;
        try {
            byteBufInputStream = new ByteBufInputStream(byteBuf);
            outputStream = new ByteBufOutputStream(byteBuf2);
            ((ByteBufOutputStream)outputStream).writeByte(this.properties);
            ((ByteBufOutputStream)outputStream).writeInt(this.littleEndianDictionarySize);
            ((ByteBufOutputStream)outputStream).writeLong(Long.reverseBytes(n4));
            this.encoder.code((InputStream)byteBufInputStream, outputStream, -1L, -1L, null);
        }
        finally {
            if (byteBufInputStream != null) {
                ((InputStream)byteBufInputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl3) {
        int n4 = byteBuf.readableBytes();
        int n7 = LzmaFrameEncoder.maxOutputBufferLength(n4);
        return channelHandlerContext.alloc().ioBuffer(n7);
    }

    private static int maxOutputBufferLength(int n4) {
        double d8 = n4 < 200 ? 1.5 : (n4 < 500 ? 1.2 : (n4 < 1000 ? 1.1 : (n4 < 10000 ? 1.05 : 1.02)));
        return 13 + (int)((double)n4 * d8);
    }
}

