/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.LZFEncoder;
import com.ning.compress.lzf.util.ChunkEncoderFactory;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;

public class LzfEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final int MIN_BLOCK_TO_COMPRESS = 16;
    private final ChunkEncoder encoder;
    private final BufferRecycler recycler;

    public LzfEncoder() {
        this(false, 65535);
    }

    public LzfEncoder(boolean bl3) {
        this(bl3, 65535);
    }

    public LzfEncoder(int n4) {
        this(false, n4);
    }

    public LzfEncoder(boolean bl3, int n4) {
        super(false);
        if (n4 < 16 || n4 > 65535) {
            throw new IllegalArgumentException("totalLength: " + n4 + " (expected: " + 16 + '-' + 65535 + ')');
        }
        this.encoder = bl3 ? ChunkEncoderFactory.safeNonAllocatingInstance((int)n4) : ChunkEncoderFactory.optimalNonAllocatingInstance((int)n4);
        this.recycler = BufferRecycler.instance();
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n4;
        byte[] byArray;
        int n7 = byteBuf.readableBytes();
        int n8 = byteBuf.readerIndex();
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n4 = byteBuf.arrayOffset() + n8;
        } else {
            byArray = this.recycler.allocInputBuffer(n7);
            byteBuf.getBytes(n8, byArray, 0, n7);
            n4 = 0;
        }
        int n10 = LZFEncoder.estimateMaxWorkspaceSize((int)n7);
        byteBuf2.ensureWritable(n10);
        byte[] byArray2 = byteBuf2.array();
        int n11 = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
        int n12 = LZFEncoder.appendEncoded((ChunkEncoder)this.encoder, (byte[])byArray, (int)n4, (int)n7, (byte[])byArray2, (int)n11) - n11;
        byteBuf2.writerIndex(byteBuf2.writerIndex() + n12);
        byteBuf.skipBytes(n7);
        if (!byteBuf.hasArray()) {
            this.recycler.releaseInputBuffer(byArray);
        }
    }
}

