/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.EncoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ByteBufChecksum;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.CompressionException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Lz4FrameEncoder$1;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Lz4FrameEncoder$2;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Lz4FrameEncoder$3;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Lz4XXHash32;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;

public class Lz4FrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    static final int DEFAULT_MAX_ENCODE_SIZE = Integer.MAX_VALUE;
    private final int blockSize;
    private final LZ4Compressor compressor;
    private final ByteBufChecksum checksum;
    private final int compressionLevel;
    private ByteBuf buffer;
    private final int maxEncodeSize;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public Lz4FrameEncoder() {
        this(false);
    }

    public Lz4FrameEncoder(boolean bl3) {
        this(LZ4Factory.fastestInstance(), bl3, 65536, new Lz4XXHash32(-1756908916));
    }

    public Lz4FrameEncoder(LZ4Factory lZ4Factory, boolean bl3, int n4, Checksum checksum) {
        this(lZ4Factory, bl3, n4, checksum, Integer.MAX_VALUE);
    }

    public Lz4FrameEncoder(LZ4Factory lZ4Factory, boolean bl3, int n4, Checksum checksum, int n7) {
        if (lZ4Factory == null) {
            throw new NullPointerException("factory");
        }
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.compressor = bl3 ? lZ4Factory.highCompressor() : lZ4Factory.fastCompressor();
        this.checksum = ByteBufChecksum.wrapChecksum(checksum);
        this.compressionLevel = Lz4FrameEncoder.compressionLevel(n4);
        this.blockSize = n4;
        this.maxEncodeSize = ObjectUtil.checkPositive(n7, "maxEncodeSize");
        this.finished = false;
    }

    private static int compressionLevel(int n4) {
        if (n4 < 64 || n4 > 0x2000000) {
            throw new IllegalArgumentException(String.format("blockSize: %d (expected: %d-%d)", n4, 64, 0x2000000));
        }
        int n7 = 32 - Integer.numberOfLeadingZeros(n4 - 1);
        n7 = Math.max(0, n7 - 10);
        return n7;
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl3) {
        return this.allocateBuffer(channelHandlerContext, byteBuf, bl3, true);
    }

    private ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl3, boolean bl4) {
        int n4 = 0;
        int n7 = byteBuf.readableBytes() + this.buffer.readableBytes();
        if (n7 < 0) {
            throw new EncoderException("too much data to allocate a buffer for compression");
        }
        while (n7 > 0) {
            int n8 = Math.min(this.blockSize, n7);
            n7 -= n8;
            n4 += this.compressor.maxCompressedLength(n8) + 21;
        }
        if (n4 > this.maxEncodeSize || 0 > n4) {
            throw new EncoderException(String.format("requested encode buffer size (%d bytes) exceeds the maximum allowable size (%d bytes)", n4, this.maxEncodeSize));
        }
        if (bl4 && n4 < this.blockSize) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (bl3) {
            return channelHandlerContext.alloc().ioBuffer(n4, n4);
        }
        return channelHandlerContext.alloc().heapBuffer(n4, n4);
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n4;
        if (this.finished) {
            if (!byteBuf2.isWritable(byteBuf.readableBytes())) {
                throw new IllegalStateException("encode finished and not enough space to write remaining data");
            }
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        ByteBuf byteBuf3 = this.buffer;
        while ((n4 = byteBuf.readableBytes()) > 0) {
            int n7 = Math.min(n4, byteBuf3.writableBytes());
            byteBuf.readBytes(byteBuf3, n7);
            if (byteBuf3.isWritable()) continue;
            this.flushBufferedData(byteBuf2);
        }
    }

    private void flushBufferedData(ByteBuf byteBuf) {
        int n4;
        int n7;
        int n8 = this.buffer.readableBytes();
        if (n8 == 0) {
            return;
        }
        this.checksum.reset();
        this.checksum.update(this.buffer, this.buffer.readerIndex(), n8);
        int n10 = (int)this.checksum.getValue();
        int n11 = this.compressor.maxCompressedLength(n8) + 21;
        byteBuf.ensureWritable(n11);
        int n12 = byteBuf.writerIndex();
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(n12 + 21, byteBuf.writableBytes() - 21);
            int n13 = byteBuffer.position();
            this.compressor.compress(this.buffer.internalNioBuffer(this.buffer.readerIndex(), n8), byteBuffer);
            n7 = byteBuffer.position() - n13;
        }
        catch (LZ4Exception lZ4Exception) {
            throw new CompressionException(lZ4Exception);
        }
        if (n7 >= n8) {
            n4 = 16;
            n7 = n8;
            byteBuf.setBytes(n12 + 21, this.buffer, 0, n8);
        } else {
            n4 = 32;
        }
        byteBuf.setLong(n12, 5501767354678207339L);
        byteBuf.setByte(n12 + 8, (byte)(n4 | this.compressionLevel));
        byteBuf.setIntLE(n12 + 9, n7);
        byteBuf.setIntLE(n12 + 13, n8);
        byteBuf.setIntLE(n12 + 17, n10);
        byteBuf.writerIndex(n12 + 21 + n7);
        this.buffer.clear();
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.buffer != null && this.buffer.isReadable()) {
            ByteBuf byteBuf = this.allocateBuffer(channelHandlerContext, Unpooled.EMPTY_BUFFER, this.isPreferDirect(), false);
            this.flushBufferedData(byteBuf);
            channelHandlerContext.write(byteBuf);
        }
        channelHandlerContext.flush();
    }

    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        ByteBuf byteBuf = channelHandlerContext.alloc().heapBuffer(this.compressor.maxCompressedLength(this.buffer.readableBytes()) + 21);
        this.flushBufferedData(byteBuf);
        int n4 = byteBuf.writerIndex();
        byteBuf.setLong(n4, 5501767354678207339L);
        byteBuf.setByte(n4 + 8, (byte)(0x10 | this.compressionLevel));
        byteBuf.setInt(n4 + 9, 0);
        byteBuf.setInt(n4 + 13, 0);
        byteBuf.setInt(n4 + 17, 0);
        byteBuf.writerIndex(n4 + 21);
        return channelHandlerContext.writeAndFlush(byteBuf, channelPromise);
    }

    public boolean isClosed() {
        return this.finished;
    }

    public ChannelFuture close() {
        return this.close(this.ctx().newPromise());
    }

    public ChannelFuture close(ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx();
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode(channelHandlerContext, channelPromise);
        }
        eventExecutor.execute(new Lz4FrameEncoder$1(this, channelPromise));
        return channelPromise;
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        channelFuture.addListener(new Lz4FrameEncoder$2(this, channelHandlerContext, channelPromise));
        if (!channelFuture.isDone()) {
            channelHandlerContext.executor().schedule(new Lz4FrameEncoder$3(this, channelHandlerContext, channelPromise), 10L, TimeUnit.SECONDS);
        }
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        this.buffer = Unpooled.wrappedBuffer(new byte[this.blockSize]);
        this.buffer.clear();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved(channelHandlerContext);
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    final ByteBuf getBackingBuffer() {
        return this.buffer;
    }

    static /* synthetic */ ChannelHandlerContext access$000(Lz4FrameEncoder lz4FrameEncoder) {
        return lz4FrameEncoder.ctx();
    }

    static /* synthetic */ ChannelFuture access$100(Lz4FrameEncoder lz4FrameEncoder, ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        return lz4FrameEncoder.finishEncode(channelHandlerContext, channelPromise);
    }
}

