/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ByteBufChecksum;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.CompressionUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Lz4FrameDecoder$State;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Lz4XXHash32;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import java.util.List;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class Lz4FrameDecoder
extends ByteToMessageDecoder {
    private Lz4FrameDecoder$State currentState = Lz4FrameDecoder$State.INIT_BLOCK;
    private LZ4FastDecompressor decompressor;
    private ByteBufChecksum checksum;
    private int blockType;
    private int compressedLength;
    private int decompressedLength;
    private int currentChecksum;

    public Lz4FrameDecoder() {
        this(false);
    }

    public Lz4FrameDecoder(boolean bl3) {
        this(LZ4Factory.fastestInstance(), bl3);
    }

    public Lz4FrameDecoder(LZ4Factory lZ4Factory, boolean bl3) {
        this(lZ4Factory, bl3 ? new Lz4XXHash32(-1756908916) : null);
    }

    public Lz4FrameDecoder(LZ4Factory lZ4Factory, Checksum checksum) {
        if (lZ4Factory == null) {
            throw new NullPointerException("factory");
        }
        this.decompressor = lZ4Factory.fastDecompressor();
        this.checksum = checksum == null ? null : ByteBufChecksum.wrapChecksum(checksum);
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch (this.currentState) {
                case INIT_BLOCK: {
                    if (byteBuf.readableBytes() < 21) break;
                    long l2 = byteBuf.readLong();
                    if (l2 != 5501767354678207339L) {
                        throw new DecompressionException("unexpected block identifier");
                    }
                    byte by2 = byteBuf.readByte();
                    int n4 = (by2 & 0xF) + 10;
                    int n7 = by2 & 0xF0;
                    int n8 = Integer.reverseBytes(byteBuf.readInt());
                    if (n8 < 0 || n8 > 0x2000000) {
                        throw new DecompressionException(String.format("invalid compressedLength: %d (expected: 0-%d)", n8, 0x2000000));
                    }
                    int n10 = Integer.reverseBytes(byteBuf.readInt());
                    int n11 = 1 << n4;
                    if (n10 < 0 || n10 > n11) {
                        throw new DecompressionException(String.format("invalid decompressedLength: %d (expected: 0-%d)", n10, n11));
                    }
                    if (n10 == 0 && n8 != 0 || n10 != 0 && n8 == 0 || n7 == 16 && n10 != n8) {
                        throw new DecompressionException(String.format("stream corrupted: compressedLength(%d) and decompressedLength(%d) mismatch", n8, n10));
                    }
                    int n12 = Integer.reverseBytes(byteBuf.readInt());
                    if (n10 == 0 && n8 == 0) {
                        if (n12 != 0) {
                            throw new DecompressionException("stream corrupted: checksum error");
                        }
                        this.currentState = Lz4FrameDecoder$State.FINISHED;
                        this.decompressor = null;
                        this.checksum = null;
                        break;
                    }
                    this.blockType = n7;
                    this.compressedLength = n8;
                    this.decompressedLength = n10;
                    this.currentChecksum = n12;
                    this.currentState = Lz4FrameDecoder$State.DECOMPRESS_DATA;
                }
                case DECOMPRESS_DATA: {
                    int n7 = this.blockType;
                    int n8 = this.compressedLength;
                    int n10 = this.decompressedLength;
                    int n12 = this.currentChecksum;
                    if (byteBuf.readableBytes() < n8) break;
                    ByteBufChecksum byteBufChecksum = this.checksum;
                    ReferenceCounted referenceCounted = null;
                    try {
                        switch (n7) {
                            case 16: {
                                referenceCounted = byteBuf.retainedSlice(byteBuf.readerIndex(), n10);
                                break;
                            }
                            case 32: {
                                referenceCounted = channelHandlerContext.alloc().buffer(n10, n10);
                                this.decompressor.decompress(CompressionUtil.safeNioBuffer(byteBuf), ((ByteBuf)referenceCounted).internalNioBuffer(((ByteBuf)referenceCounted).writerIndex(), n10));
                                ((ByteBuf)referenceCounted).writerIndex(((ByteBuf)referenceCounted).writerIndex() + n10);
                                break;
                            }
                            default: {
                                throw new DecompressionException(String.format("unexpected blockType: %d (expected: %d or %d)", n7, 16, 32));
                            }
                        }
                        byteBuf.skipBytes(n8);
                        if (byteBufChecksum != null) {
                            CompressionUtil.checkChecksum(byteBufChecksum, (ByteBuf)referenceCounted, n12);
                        }
                        list.add(referenceCounted);
                        referenceCounted = null;
                        this.currentState = Lz4FrameDecoder$State.INIT_BLOCK;
                        break;
                    }
                    catch (LZ4Exception lZ4Exception) {
                        throw new DecompressionException(lZ4Exception);
                    }
                    finally {
                        if (referenceCounted != null) {
                            referenceCounted.release();
                        }
                    }
                }
                case FINISHED: 
                case CORRUPTED: {
                    byteBuf.skipBytes(byteBuf.readableBytes());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception exception) {
            this.currentState = Lz4FrameDecoder$State.CORRUPTED;
            throw exception;
        }
    }

    public boolean isClosed() {
        return this.currentState == Lz4FrameDecoder$State.FINISHED;
    }
}

