/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.JdkZlibEncoder$1;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.JdkZlibEncoder$2;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.JdkZlibEncoder$3;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class JdkZlibEncoder
extends ZlibEncoder {
    private final ZlibWrapper wrapper;
    private final Deflater deflater;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;
    private final CRC32 crc = new CRC32();
    private static final byte[] gzipHeader = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private boolean writeHeader = true;

    public JdkZlibEncoder() {
        this(6);
    }

    public JdkZlibEncoder(int n4) {
        this(ZlibWrapper.ZLIB, n4);
    }

    public JdkZlibEncoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, 6);
    }

    public JdkZlibEncoder(ZlibWrapper zlibWrapper, int n4) {
        if (n4 < 0 || n4 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n4 + " (expected: 0-9)");
        }
        if (zlibWrapper == null) {
            throw new NullPointerException("wrapper");
        }
        if (zlibWrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        this.wrapper = zlibWrapper;
        this.deflater = new Deflater(n4, zlibWrapper != ZlibWrapper.ZLIB);
    }

    public JdkZlibEncoder(byte[] byArray) {
        this(6, byArray);
    }

    public JdkZlibEncoder(int n4, byte[] byArray) {
        if (n4 < 0 || n4 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n4 + " (expected: 0-9)");
        }
        if (byArray == null) {
            throw new NullPointerException("dictionary");
        }
        this.wrapper = ZlibWrapper.ZLIB;
        this.deflater = new Deflater(n4);
        this.deflater.setDictionary(byArray);
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.ctx().newPromise());
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx();
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode(channelHandlerContext, channelPromise);
        }
        ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
        eventExecutor.execute(new JdkZlibEncoder$1(this, channelPromise2, channelPromise));
        return channelPromise2;
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n4;
        byte[] byArray;
        if (this.finished) {
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        int n7 = byteBuf.readableBytes();
        if (n7 == 0) {
            return;
        }
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n4 = byteBuf.arrayOffset() + byteBuf.readerIndex();
            byteBuf.skipBytes(n7);
        } else {
            byArray = new byte[n7];
            byteBuf.readBytes(byArray);
            n4 = 0;
        }
        if (this.writeHeader) {
            this.writeHeader = false;
            if (this.wrapper == ZlibWrapper.GZIP) {
                byteBuf2.writeBytes(gzipHeader);
            }
        }
        if (this.wrapper == ZlibWrapper.GZIP) {
            this.crc.update(byArray, n4, n7);
        }
        this.deflater.setInput(byArray, n4, n7);
        while (true) {
            this.deflate(byteBuf2);
            if (this.deflater.needsInput()) break;
            if (byteBuf2.isWritable()) continue;
            byteBuf2.ensureWritable(byteBuf2.writerIndex());
        }
    }

    @Override
    protected final ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl3) {
        int n4 = (int)Math.ceil((double)byteBuf.readableBytes() * 1.001) + 12;
        if (this.writeHeader) {
            switch (this.wrapper) {
                case GZIP: {
                    n4 += gzipHeader.length;
                    break;
                }
                case ZLIB: {
                    n4 += 2;
                    break;
                }
            }
        }
        return channelHandlerContext.alloc().heapBuffer(n4);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        channelFuture.addListener(new JdkZlibEncoder$2(this, channelHandlerContext, channelPromise));
        if (!channelFuture.isDone()) {
            channelHandlerContext.executor().schedule(new JdkZlibEncoder$3(this, channelHandlerContext, channelPromise), 10L, TimeUnit.SECONDS);
        }
    }

    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        ByteBuf byteBuf = channelHandlerContext.alloc().heapBuffer();
        if (this.writeHeader && this.wrapper == ZlibWrapper.GZIP) {
            this.writeHeader = false;
            byteBuf.writeBytes(gzipHeader);
        }
        this.deflater.finish();
        while (!this.deflater.finished()) {
            this.deflate(byteBuf);
            if (byteBuf.isWritable()) continue;
            channelHandlerContext.write(byteBuf);
            byteBuf = channelHandlerContext.alloc().heapBuffer();
        }
        if (this.wrapper == ZlibWrapper.GZIP) {
            int n4 = (int)this.crc.getValue();
            int n7 = this.deflater.getTotalIn();
            byteBuf.writeByte(n4);
            byteBuf.writeByte(n4 >>> 8);
            byteBuf.writeByte(n4 >>> 16);
            byteBuf.writeByte(n4 >>> 24);
            byteBuf.writeByte(n7);
            byteBuf.writeByte(n7 >>> 8);
            byteBuf.writeByte(n7 >>> 16);
            byteBuf.writeByte(n7 >>> 24);
        }
        this.deflater.end();
        return channelHandlerContext.writeAndFlush(byteBuf, channelPromise);
    }

    private void deflate(ByteBuf byteBuf) {
        int n4;
        do {
            int n7 = byteBuf.writerIndex();
            n4 = this.deflater.deflate(byteBuf.array(), byteBuf.arrayOffset() + n7, byteBuf.writableBytes(), 2);
            byteBuf.writerIndex(n7 + n4);
        } while (n4 > 0);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    static /* synthetic */ ChannelHandlerContext access$000(JdkZlibEncoder jdkZlibEncoder) {
        return jdkZlibEncoder.ctx();
    }

    static /* synthetic */ ChannelFuture access$100(JdkZlibEncoder jdkZlibEncoder, ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        return jdkZlibEncoder.finishEncode(channelHandlerContext, channelPromise);
    }
}

