/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ByteBufChecksum;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.JdkZlibDecoder$GzipState;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class JdkZlibDecoder
extends ZlibDecoder {
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int FRESERVED = 224;
    private Inflater inflater;
    private final byte[] dictionary;
    private final ByteBufChecksum crc;
    private final boolean decompressConcatenated;
    private JdkZlibDecoder$GzipState gzipState = JdkZlibDecoder$GzipState.HEADER_START;
    private int flags = -1;
    private int xlen = -1;
    private volatile boolean finished;
    private boolean decideZlibOrNone;

    public JdkZlibDecoder() {
        this(ZlibWrapper.ZLIB, null, false);
    }

    public JdkZlibDecoder(byte[] byArray) {
        this(ZlibWrapper.ZLIB, byArray, false);
    }

    public JdkZlibDecoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, null, false);
    }

    public JdkZlibDecoder(ZlibWrapper zlibWrapper, boolean bl3) {
        this(zlibWrapper, null, bl3);
    }

    public JdkZlibDecoder(boolean bl3) {
        this(ZlibWrapper.GZIP, null, bl3);
    }

    private JdkZlibDecoder(ZlibWrapper zlibWrapper, byte[] byArray, boolean bl3) {
        if (zlibWrapper == null) {
            throw new NullPointerException("wrapper");
        }
        this.decompressConcatenated = bl3;
        switch (zlibWrapper) {
            case GZIP: {
                this.inflater = new Inflater(true);
                this.crc = ByteBufChecksum.wrapChecksum(new CRC32());
                break;
            }
            case NONE: {
                this.inflater = new Inflater(true);
                this.crc = null;
                break;
            }
            case ZLIB: {
                this.inflater = new Inflater();
                this.crc = null;
                break;
            }
            case ZLIB_OR_NONE: {
                this.decideZlibOrNone = true;
                this.crc = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only GZIP or ZLIB is supported, but you used " + (Object)((Object)zlibWrapper));
            }
        }
        this.dictionary = byArray;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.finished) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        int n4 = byteBuf.readableBytes();
        if (n4 == 0) {
            return;
        }
        if (this.decideZlibOrNone) {
            if (n4 < 2) {
                return;
            }
            boolean bl3 = !JdkZlibDecoder.looksLikeZlib(byteBuf.getShort(byteBuf.readerIndex()));
            this.inflater = new Inflater(bl3);
            this.decideZlibOrNone = false;
        }
        if (this.crc != null) {
            switch (this.gzipState) {
                case FOOTER_START: {
                    if (this.readGZIPFooter(byteBuf)) {
                        this.finished = true;
                    }
                    return;
                }
            }
            if (this.gzipState != JdkZlibDecoder$GzipState.HEADER_END && !this.readGZIPHeader(byteBuf)) {
                return;
            }
            n4 = byteBuf.readableBytes();
        }
        if (byteBuf.hasArray()) {
            this.inflater.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), n4);
        } else {
            byte[] byArray = new byte[n4];
            byteBuf.getBytes(byteBuf.readerIndex(), byArray);
            this.inflater.setInput(byArray);
        }
        ByteBuf byteBuf2 = channelHandlerContext.alloc().heapBuffer(this.inflater.getRemaining() << 1);
        try {
            boolean bl4 = false;
            while (!this.inflater.needsInput()) {
                byte[] byArray = byteBuf2.array();
                int n7 = byteBuf2.writerIndex();
                int n8 = byteBuf2.arrayOffset() + n7;
                int n10 = this.inflater.inflate(byArray, n8, byteBuf2.writableBytes());
                if (n10 > 0) {
                    byteBuf2.writerIndex(n7 + n10);
                    if (this.crc != null) {
                        this.crc.update(byArray, n8, n10);
                    }
                } else if (this.inflater.needsDictionary()) {
                    if (this.dictionary == null) {
                        throw new DecompressionException("decompression failure, unable to set dictionary as non was specified");
                    }
                    this.inflater.setDictionary(this.dictionary);
                }
                if (this.inflater.finished()) {
                    if (this.crc == null) {
                        this.finished = true;
                        break;
                    }
                    bl4 = true;
                    break;
                }
                byteBuf2.ensureWritable(this.inflater.getRemaining() << 1);
            }
            byteBuf.skipBytes(n4 - this.inflater.getRemaining());
            if (bl4) {
                this.gzipState = JdkZlibDecoder$GzipState.FOOTER_START;
                if (this.readGZIPFooter(byteBuf)) {
                    boolean bl5 = this.finished = !this.decompressConcatenated;
                    if (!this.finished) {
                        this.inflater.reset();
                        this.crc.reset();
                        this.gzipState = JdkZlibDecoder$GzipState.HEADER_START;
                    }
                }
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new DecompressionException("decompression failure", dataFormatException);
        }
        finally {
            if (byteBuf2.isReadable()) {
                list.add(byteBuf2);
            } else {
                byteBuf2.release();
            }
        }
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved0(channelHandlerContext);
        if (this.inflater != null) {
            this.inflater.end();
        }
    }

    private boolean readGZIPHeader(ByteBuf byteBuf) {
        switch (this.gzipState) {
            case HEADER_START: {
                if (byteBuf.readableBytes() < 10) {
                    return false;
                }
                byte by2 = byteBuf.readByte();
                byte by3 = byteBuf.readByte();
                if (by2 != 31) {
                    throw new DecompressionException("Input is not in the GZIP format");
                }
                this.crc.update(by2);
                this.crc.update(by3);
                short s11 = byteBuf.readUnsignedByte();
                if (s11 != 8) {
                    throw new DecompressionException("Unsupported compression method " + s11 + " in the GZIP header");
                }
                this.crc.update(s11);
                this.flags = byteBuf.readUnsignedByte();
                this.crc.update(this.flags);
                if ((this.flags & 0xE0) != 0) {
                    throw new DecompressionException("Reserved flags are set in the GZIP header");
                }
                this.crc.update(byteBuf, byteBuf.readerIndex(), 4);
                byteBuf.skipBytes(4);
                this.crc.update(byteBuf.readUnsignedByte());
                this.crc.update(byteBuf.readUnsignedByte());
                this.gzipState = JdkZlibDecoder$GzipState.FLG_READ;
            }
            case FLG_READ: {
                short s12;
                if ((this.flags & 4) != 0) {
                    if (byteBuf.readableBytes() < 2) {
                        return false;
                    }
                    s12 = byteBuf.readUnsignedByte();
                    short s13 = byteBuf.readUnsignedByte();
                    this.crc.update(s12);
                    this.crc.update(s13);
                    this.xlen |= s12 << 8 | s13;
                }
                this.gzipState = JdkZlibDecoder$GzipState.XLEN_READ;
            }
            case XLEN_READ: {
                if (this.xlen != -1) {
                    if (byteBuf.readableBytes() < this.xlen) {
                        return false;
                    }
                    this.crc.update(byteBuf, byteBuf.readerIndex(), this.xlen);
                    byteBuf.skipBytes(this.xlen);
                }
                this.gzipState = JdkZlibDecoder$GzipState.SKIP_FNAME;
            }
            case SKIP_FNAME: {
                short s12;
                if ((this.flags & 8) != 0) {
                    if (!byteBuf.isReadable()) {
                        return false;
                    }
                    do {
                        s12 = byteBuf.readUnsignedByte();
                        this.crc.update(s12);
                    } while (s12 != 0 && byteBuf.isReadable());
                }
                this.gzipState = JdkZlibDecoder$GzipState.SKIP_COMMENT;
            }
            case SKIP_COMMENT: {
                short s12;
                if ((this.flags & 0x10) != 0) {
                    if (!byteBuf.isReadable()) {
                        return false;
                    }
                    do {
                        s12 = byteBuf.readUnsignedByte();
                        this.crc.update(s12);
                    } while (s12 != 0 && byteBuf.isReadable());
                }
                this.gzipState = JdkZlibDecoder$GzipState.PROCESS_FHCRC;
            }
            case PROCESS_FHCRC: {
                if ((this.flags & 2) != 0) {
                    if (byteBuf.readableBytes() < 4) {
                        return false;
                    }
                    this.verifyCrc(byteBuf);
                }
                this.crc.reset();
                this.gzipState = JdkZlibDecoder$GzipState.HEADER_END;
            }
            case HEADER_END: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean readGZIPFooter(ByteBuf byteBuf) {
        int n4;
        if (byteBuf.readableBytes() < 8) {
            return false;
        }
        this.verifyCrc(byteBuf);
        int n7 = 0;
        for (n4 = 0; n4 < 4; ++n4) {
            n7 |= byteBuf.readUnsignedByte() << n4 * 8;
        }
        n4 = this.inflater.getTotalOut();
        if (n7 != n4) {
            throw new DecompressionException("Number of bytes mismatch. Expected: " + n7 + ", Got: " + n4);
        }
        return true;
    }

    private void verifyCrc(ByteBuf byteBuf) {
        long l2 = 0L;
        for (int i3 = 0; i3 < 4; ++i3) {
            l2 |= (long)byteBuf.readUnsignedByte() << i3 * 8;
        }
        long l10 = this.crc.getValue();
        if (l2 != l10) {
            throw new DecompressionException("CRC value mismatch. Expected: " + l2 + ", Got: " + l10);
        }
    }

    private static boolean looksLikeZlib(short s11) {
        return (s11 & 0x7800) == 30720 && s11 % 31 == 0;
    }
}

