/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import com.jcraft.jzlib.Inflater;
import com.jcraft.jzlib.JZlib;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibUtil;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import java.util.List;

public class JZlibDecoder
extends ZlibDecoder {
    private final Inflater z = new Inflater();
    private byte[] dictionary;
    private volatile boolean finished;

    public JZlibDecoder() {
        this(ZlibWrapper.ZLIB);
    }

    public JZlibDecoder(ZlibWrapper zlibWrapper) {
        if (zlibWrapper == null) {
            throw new NullPointerException("wrapper");
        }
        int n4 = this.z.init(ZlibUtil.convertWrapperType(zlibWrapper));
        if (n4 != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n4);
        }
    }

    public JZlibDecoder(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("dictionary");
        }
        this.dictionary = byArray;
        int n4 = this.z.inflateInit(JZlib.W_ZLIB);
        if (n4 != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n4);
        }
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.finished) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        int n4 = byteBuf.readableBytes();
        if (n4 == 0) {
            return;
        }
        try {
            this.z.avail_in = n4;
            if (byteBuf.hasArray()) {
                this.z.next_in = byteBuf.array();
                this.z.next_in_index = byteBuf.arrayOffset() + byteBuf.readerIndex();
            } else {
                byte[] byArray = new byte[n4];
                byteBuf.getBytes(byteBuf.readerIndex(), byArray);
                this.z.next_in = byArray;
                this.z.next_in_index = 0;
            }
            int n7 = this.z.next_in_index;
            ByteBuf byteBuf2 = channelHandlerContext.alloc().heapBuffer(n4 << 1);
            block12: while (true) {
                block13: while (true) {
                    byteBuf2.ensureWritable(this.z.avail_in << 1);
                    this.z.avail_out = byteBuf2.writableBytes();
                    this.z.next_out = byteBuf2.array();
                    int n8 = this.z.next_out_index = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
                    int n10 = this.z.inflate(2);
                    int n11 = this.z.next_out_index - n8;
                    if (n11 > 0) {
                        byteBuf2.writerIndex(byteBuf2.writerIndex() + n11);
                    }
                    switch (n10) {
                        case 2: {
                            if (this.dictionary == null) {
                                ZlibUtil.fail(this.z, "decompression failure", n10);
                                continue block12;
                            }
                            n10 = this.z.inflateSetDictionary(this.dictionary, this.dictionary.length);
                            if (n10 == 0) continue block12;
                            ZlibUtil.fail(this.z, "failed to set the dictionary", n10);
                            continue block12;
                        }
                        case 1: {
                            this.finished = true;
                            this.z.inflateEnd();
                            return;
                        }
                        case 0: {
                            continue block12;
                        }
                        case -5: {
                            if (this.z.avail_in <= 0) return;
                            continue block12;
                        }
                        default: {
                            ZlibUtil.fail(this.z, "decompression failure", n10);
                            continue block13;
                        }
                    }
                    break;
                }
                break;
            }
            finally {
                byteBuf.skipBytes(this.z.next_in_index - n7);
                if (byteBuf2.isReadable()) {
                    list.add(byteBuf2);
                } else {
                    byteBuf2.release();
                }
            }
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
        }
    }
}

