/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.MessageToByteEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.FastLz;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int level;
    private final Checksum checksum;

    public FastLzFrameEncoder() {
        this(0, null);
    }

    public FastLzFrameEncoder(int n4) {
        this(n4, null);
    }

    public FastLzFrameEncoder(boolean bl3) {
        this(0, bl3 ? new Adler32() : null);
    }

    public FastLzFrameEncoder(int n4, Checksum checksum) {
        super(false);
        if (n4 != 0 && n4 != 1 && n4 != 2) {
            throw new IllegalArgumentException(String.format("level: %d (expected: %d or %d or %d)", n4, 0, 1, 2));
        }
        this.level = n4;
        this.checksum = checksum;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        Checksum checksum = this.checksum;
        while (byteBuf.isReadable()) {
            int n4;
            int n7;
            byte[] byArray;
            int n8;
            int n10 = byteBuf.readerIndex();
            int n11 = Math.min(byteBuf.readableBytes(), 65535);
            int n12 = byteBuf2.writerIndex();
            byteBuf2.setMedium(n12, 4607066);
            int n13 = n12 + 4 + (checksum != null ? 4 : 0);
            if (n11 < 32) {
                n8 = 0;
                byteBuf2.ensureWritable(n13 + 2 + n11);
                byArray = byteBuf2.array();
                n7 = byteBuf2.arrayOffset() + n13 + 2;
                if (checksum != null) {
                    int n14;
                    byte[] byArray2;
                    if (byteBuf.hasArray()) {
                        byArray2 = byteBuf.array();
                        n14 = byteBuf.arrayOffset() + n10;
                    } else {
                        byArray2 = new byte[n11];
                        byteBuf.getBytes(n10, byArray2);
                        n14 = 0;
                    }
                    checksum.reset();
                    checksum.update(byArray2, n14, n11);
                    byteBuf2.setInt(n12 + 4, (int)checksum.getValue());
                    System.arraycopy(byArray2, n14, byArray, n7, n11);
                } else {
                    byteBuf.getBytes(n10, byArray, n7, n11);
                }
                n4 = n11;
            } else {
                if (byteBuf.hasArray()) {
                    byArray = byteBuf.array();
                    n7 = byteBuf.arrayOffset() + n10;
                } else {
                    byArray = new byte[n11];
                    byteBuf.getBytes(n10, byArray);
                    n7 = 0;
                }
                if (checksum != null) {
                    checksum.reset();
                    checksum.update(byArray, n7, n11);
                    byteBuf2.setInt(n12 + 4, (int)checksum.getValue());
                }
                int n15 = FastLz.calculateOutputBufferLength(n11);
                byteBuf2.ensureWritable(n13 + 4 + n15);
                byte[] byArray3 = byteBuf2.array();
                int n16 = byteBuf2.arrayOffset() + n13 + 4;
                int n17 = FastLz.compress(byArray, n7, n11, byArray3, n16, this.level);
                if (n17 < n11) {
                    n8 = 1;
                    n4 = n17;
                    byteBuf2.setShort(n13, n4);
                    n13 += 2;
                } else {
                    n8 = 0;
                    System.arraycopy(byArray, n7, byArray3, n16 - 2, n11);
                    n4 = n11;
                }
            }
            byteBuf2.setShort(n13, n11);
            byteBuf2.setByte(n12 + 3, n8 | (checksum != null ? 16 : 0));
            byteBuf2.writerIndex(n13 + 2 + n4);
            byteBuf.skipBytes(n11);
        }
        return;
    }
}

