/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.FastLz;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.FastLzFrameDecoder$State;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameDecoder
extends ByteToMessageDecoder {
    private FastLzFrameDecoder$State currentState = FastLzFrameDecoder$State.INIT_BLOCK;
    private final Checksum checksum;
    private int chunkLength;
    private int originalLength;
    private boolean isCompressed;
    private boolean hasChecksum;
    private int currentChecksum;

    public FastLzFrameDecoder() {
        this(false);
    }

    public FastLzFrameDecoder(boolean bl3) {
        this(bl3 ? new Adler32() : null);
    }

    public FastLzFrameDecoder(Checksum checksum) {
        this.checksum = checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            switch (this.currentState) {
                case INIT_BLOCK: {
                    if (byteBuf.readableBytes() < 4) break;
                    int n4 = byteBuf.readUnsignedMedium();
                    if (n4 != 4607066) {
                        throw new DecompressionException("unexpected block identifier");
                    }
                    byte by2 = byteBuf.readByte();
                    this.isCompressed = (by2 & 1) == 1;
                    this.hasChecksum = (by2 & 0x10) == 16;
                    this.currentState = FastLzFrameDecoder$State.INIT_BLOCK_PARAMS;
                }
                case INIT_BLOCK_PARAMS: {
                    if (byteBuf.readableBytes() < 2 + (this.isCompressed ? 2 : 0) + (this.hasChecksum ? 4 : 0)) break;
                    this.currentChecksum = this.hasChecksum ? byteBuf.readInt() : 0;
                    this.chunkLength = byteBuf.readUnsignedShort();
                    this.originalLength = this.isCompressed ? byteBuf.readUnsignedShort() : this.chunkLength;
                    this.currentState = FastLzFrameDecoder$State.DECOMPRESS_DATA;
                }
                case DECOMPRESS_DATA: {
                    int n7;
                    byte[] byArray;
                    ByteBuf byteBuf2;
                    int n8 = this.chunkLength;
                    if (byteBuf.readableBytes() < n8) break;
                    int n10 = byteBuf.readerIndex();
                    int n11 = this.originalLength;
                    if (n11 != 0) {
                        byteBuf2 = channelHandlerContext.alloc().heapBuffer(n11, n11);
                        byArray = byteBuf2.array();
                        n7 = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
                    } else {
                        byteBuf2 = null;
                        byArray = EmptyArrays.EMPTY_BYTES;
                        n7 = 0;
                    }
                    boolean bl3 = false;
                    try {
                        int n12;
                        Object object;
                        if (this.isCompressed) {
                            if (byteBuf.hasArray()) {
                                object = byteBuf.array();
                                n12 = byteBuf.arrayOffset() + n10;
                            } else {
                                object = new byte[n8];
                                byteBuf.getBytes(n10, (byte[])object);
                                n12 = 0;
                            }
                            int n13 = FastLz.decompress((byte[])object, n12, n8, byArray, n7, n11);
                            if (n11 != n13) {
                                throw new DecompressionException(String.format("stream corrupted: originalLength(%d) and actual length(%d) mismatch", n11, n13));
                            }
                        } else {
                            byteBuf.getBytes(n10, byArray, n7, n8);
                        }
                        object = this.checksum;
                        if (this.hasChecksum && object != null) {
                            object.reset();
                            object.update(byArray, n7, n11);
                            n12 = (int)object.getValue();
                            if (n12 != this.currentChecksum) {
                                throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", n12, this.currentChecksum));
                            }
                        }
                        if (byteBuf2 != null) {
                            byteBuf2.writerIndex(byteBuf2.writerIndex() + n11);
                            list.add(byteBuf2);
                        }
                        byteBuf.skipBytes(n8);
                        this.currentState = FastLzFrameDecoder$State.INIT_BLOCK;
                        bl3 = true;
                        break;
                    }
                    finally {
                        if (!bl3 && byteBuf2 != null) {
                            byteBuf2.release();
                        }
                    }
                }
                case CORRUPTED: {
                    byteBuf.skipBytes(byteBuf.readableBytes());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception exception) {
            this.currentState = FastLzFrameDecoder$State.CORRUPTED;
            throw exception;
        }
    }
}

