/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;

final class FastLz {
    private static final int MAX_DISTANCE = 8191;
    private static final int MAX_FARDISTANCE = 73725;
    private static final int HASH_LOG = 13;
    private static final int HASH_SIZE = 8192;
    private static final int HASH_MASK = 8191;
    private static final int MAX_COPY = 32;
    private static final int MAX_LEN = 264;
    private static final int MIN_RECOMENDED_LENGTH_FOR_LEVEL_2 = 65536;
    static final int MAGIC_NUMBER = 4607066;
    static final byte BLOCK_TYPE_NON_COMPRESSED = 0;
    static final byte BLOCK_TYPE_COMPRESSED = 1;
    static final byte BLOCK_WITHOUT_CHECKSUM = 0;
    static final byte BLOCK_WITH_CHECKSUM = 16;
    static final int OPTIONS_OFFSET = 3;
    static final int CHECKSUM_OFFSET = 4;
    static final int MAX_CHUNK_LENGTH = 65535;
    static final int MIN_LENGTH_TO_COMPRESSION = 32;
    static final int LEVEL_AUTO = 0;
    static final int LEVEL_1 = 1;
    static final int LEVEL_2 = 2;

    static int calculateOutputBufferLength(int n4) {
        int n7 = (int)((double)n4 * 1.06);
        return Math.max(n7, 66);
    }

    static int compress(byte[] byArray, int n4, int n7, byte[] byArray2, int n8, int n10) {
        int n11;
        int n12 = n10 == 0 ? (n7 < 65536 ? 1 : 2) : n10;
        int n13 = 0;
        int n14 = n13 + n7 - 2;
        int n15 = n13 + n7 - 12;
        int n16 = 0;
        int[] nArray = new int[8192];
        if (n7 < 4) {
            if (n7 != 0) {
                byArray2[n8 + n16++] = (byte)(n7 - 1);
                ++n14;
                while (n13 <= n14) {
                    byArray2[n8 + n16++] = byArray[n4 + n13++];
                }
                return n7 + 1;
            }
            return 0;
        }
        for (n11 = 0; n11 < 8192; ++n11) {
            nArray[n11] = n13;
        }
        int n17 = 2;
        byArray2[n8 + n16++] = 31;
        byArray2[n8 + n16++] = byArray[n4 + n13++];
        byArray2[n8 + n16++] = byArray[n4 + n13++];
        while (n13 < n15) {
            int n18;
            int n19;
            long l2;
            int n20;
            block37: {
                int n21;
                block39: {
                    block38: {
                        n20 = 0;
                        l2 = 0L;
                        n19 = 3;
                        n21 = n13;
                        boolean bl3 = false;
                        if (n12 == 2 && byArray[n4 + n13] == byArray[n4 + n13 - 1] && FastLz.readU16(byArray, n4 + n13 - 1) == FastLz.readU16(byArray, n4 + n13 + 1)) {
                            l2 = 1L;
                            n13 += 3;
                            n20 = n21 + 2;
                            bl3 = true;
                        }
                        if (bl3) break block37;
                        n11 = n18 = FastLz.hashFunction(byArray, n4 + n13);
                        n20 = nArray[n18];
                        l2 = n21 - n20;
                        nArray[n11] = n21;
                        if (l2 == 0L || (n12 != 1 ? l2 >= 73725L : l2 >= 8191L)) break block38;
                        if (byArray[n4 + n20++] == byArray[n4 + n13++] && byArray[n4 + n20++] == byArray[n4 + n13++] && byArray[n4 + n20++] == byArray[n4 + n13++]) break block39;
                    }
                    byArray2[n8 + n16++] = byArray[n4 + n21++];
                    n13 = n21;
                    if (++n17 != 32) continue;
                    n17 = 0;
                    byArray2[n8 + n16++] = 31;
                    continue;
                }
                if (n12 == 2 && l2 >= 8191L) {
                    if (byArray[n4 + n13++] != byArray[n4 + n20++] || byArray[n4 + n13++] != byArray[n4 + n20++]) {
                        byArray2[n8 + n16++] = byArray[n4 + n21++];
                        n13 = n21;
                        if (++n17 != 32) continue;
                        n17 = 0;
                        byArray2[n8 + n16++] = 31;
                        continue;
                    }
                    n19 += 2;
                }
            }
            if (--l2 == 0L) {
                byte by2 = byArray[n4 + n13 - 1];
                for (n13 = n21 + n19; n13 < n14 && byArray[n4 + n20++] == by2; ++n13) {
                }
            } else if (byArray[n4 + n20++] == byArray[n4 + n13++] && byArray[n4 + n20++] == byArray[n4 + n13++] && byArray[n4 + n20++] == byArray[n4 + n13++] && byArray[n4 + n20++] == byArray[n4 + n13++] && byArray[n4 + n20++] == byArray[n4 + n13++] && byArray[n4 + n20++] == byArray[n4 + n13++] && byArray[n4 + n20++] == byArray[n4 + n13++] && byArray[n4 + n20++] == byArray[n4 + n13++]) {
                while (n13 < n14 && byArray[n4 + n20++] == byArray[n4 + n13++]) {
                }
            }
            if (n17 != 0) {
                byArray2[n8 + n16 - n17 - 1] = (byte)(n17 - 1);
            } else {
                --n16;
            }
            n17 = 0;
            if (n12 == 2) {
                if (l2 < 8191L) {
                    if (n19 < 7) {
                        byArray2[n8 + n16++] = (byte)((long)(n19 << 5) + (l2 >>> 8));
                        byArray2[n8 + n16++] = (byte)(l2 & 0xFFL);
                    } else {
                        byArray2[n8 + n16++] = (byte)(224L + (l2 >>> 8));
                        n19 -= 7;
                        while (n19 >= 255) {
                            byArray2[n8 + n16++] = -1;
                            n19 -= 255;
                        }
                        byArray2[n8 + n16++] = (byte)n19;
                        byArray2[n8 + n16++] = (byte)(l2 & 0xFFL);
                    }
                } else if (n19 < 7) {
                    byArray2[n8 + n16++] = (byte)((n19 << 5) + 31);
                    byArray2[n8 + n16++] = -1;
                    byArray2[n8 + n16++] = (byte)((l2 -= 8191L) >>> 8);
                    byArray2[n8 + n16++] = (byte)(l2 & 0xFFL);
                } else {
                    l2 -= 8191L;
                    byArray2[n8 + n16++] = -1;
                    n19 -= 7;
                    while (n19 >= 255) {
                        byArray2[n8 + n16++] = -1;
                        n19 -= 255;
                    }
                    byArray2[n8 + n16++] = (byte)n19;
                    byArray2[n8 + n16++] = -1;
                    byArray2[n8 + n16++] = (byte)(l2 >>> 8);
                    byArray2[n8 + n16++] = (byte)(l2 & 0xFFL);
                }
            } else {
                if (n19 > 262) {
                    for (n19 = (n13 -= 3) - n21; n19 > 262; n19 -= 262) {
                        byArray2[n8 + n16++] = (byte)(224L + (l2 >>> 8));
                        byArray2[n8 + n16++] = -3;
                        byArray2[n8 + n16++] = (byte)(l2 & 0xFFL);
                    }
                }
                if (n19 < 7) {
                    byArray2[n8 + n16++] = (byte)((long)(n19 << 5) + (l2 >>> 8));
                    byArray2[n8 + n16++] = (byte)(l2 & 0xFFL);
                } else {
                    byArray2[n8 + n16++] = (byte)(224L + (l2 >>> 8));
                    byArray2[n8 + n16++] = (byte)(n19 - 7);
                    byArray2[n8 + n16++] = (byte)(l2 & 0xFFL);
                }
            }
            n18 = FastLz.hashFunction(byArray, n4 + n13);
            nArray[n18] = n13++;
            n18 = FastLz.hashFunction(byArray, n4 + n13);
            nArray[n18] = n13++;
            byArray2[n8 + n16++] = 31;
        }
        ++n14;
        while (n13 <= n14) {
            byArray2[n8 + n16++] = byArray[n4 + n13++];
            if (++n17 != 32) continue;
            n17 = 0;
            byArray2[n8 + n16++] = 31;
        }
        if (n17 != 0) {
            byArray2[n8 + n16 - n17 - 1] = (byte)(n17 - 1);
        } else {
            --n16;
        }
        if (n12 == 2) {
            int n22 = n8;
            byArray2[n22] = (byte)(byArray2[n22] | 0x20);
        }
        return n16;
    }

    static int decompress(byte[] byArray, int n4, int n7, byte[] byArray2, int n8, int n10) {
        int n11 = (byArray[n4] >> 5) + 1;
        if (n11 != 1 && n11 != 2) {
            throw new DecompressionException(String.format("invalid level: %d (expected: %d or %d)", n11, 1, 2));
        }
        int n12 = 0;
        int n13 = 0;
        long l2 = byArray[n4 + n12++] & 0x1F;
        boolean bl3 = true;
        do {
            int n14 = n13;
            long l10 = l2 >> 5;
            long l11 = (l2 & 0x1FL) << 8;
            if (l2 >= 32L) {
                int n15;
                n14 = (int)((long)n14 - l11);
                if (--l10 == 6L) {
                    if (n11 == 1) {
                        l10 += (long)(byArray[n4 + n12++] & 0xFF);
                    } else {
                        do {
                            n15 = byArray[n4 + n12++] & 0xFF;
                            l10 += (long)n15;
                        } while (n15 == 255);
                    }
                }
                if (n11 == 1) {
                    n14 -= byArray[n4 + n12++] & 0xFF;
                } else {
                    n15 = byArray[n4 + n12++] & 0xFF;
                    n14 -= n15;
                    if (n15 == 255 && l11 == 7936L) {
                        l11 = (byArray[n4 + n12++] & 0xFF) << 8;
                        n14 = (int)((long)n13 - (l11 += (long)(byArray[n4 + n12++] & 0xFF)) - 8191L);
                    }
                }
                if ((long)n13 + l10 + 3L > (long)n10) {
                    return 0;
                }
                if (n14 - 1 < 0) {
                    return 0;
                }
                if (n12 < n7) {
                    l2 = byArray[n4 + n12++] & 0xFF;
                } else {
                    bl3 = false;
                }
                if (n14 == n13) {
                    byte by2 = byArray2[n8 + n14 - 1];
                    byArray2[n8 + n13++] = by2;
                    byArray2[n8 + n13++] = by2;
                    byArray2[n8 + n13++] = by2;
                    while (l10 != 0L) {
                        byArray2[n8 + n13++] = by2;
                        --l10;
                    }
                } else {
                    int n16 = n13++;
                    int n17 = --n14;
                    byArray2[n8 + n16] = byArray2[n8 + n17];
                    int n18 = n13++;
                    int n19 = ++n14;
                    byArray2[n8 + n18] = byArray2[n8 + n19];
                    int n20 = n13++;
                    int n21 = ++n14;
                    ++n14;
                    byArray2[n8 + n20] = byArray2[n8 + n21];
                    while (l10 != 0L) {
                        byArray2[n8 + n13++] = byArray2[n8 + n14++];
                        --l10;
                    }
                }
            } else {
                if ((long)n13 + ++l2 > (long)n10) {
                    return 0;
                }
                if ((long)n12 + l2 > (long)n7) {
                    return 0;
                }
                byArray2[n8 + n13++] = byArray[n4 + n12++];
                --l2;
                while (l2 != 0L) {
                    byArray2[n8 + n13++] = byArray[n4 + n12++];
                    --l2;
                }
                boolean bl4 = bl3 = n12 < n7;
                if (!bl3) continue;
                l2 = byArray[n4 + n12++] & 0xFF;
            }
        } while (bl3);
        return n13;
    }

    private static int hashFunction(byte[] byArray, int n4) {
        int n7 = FastLz.readU16(byArray, n4);
        n7 ^= FastLz.readU16(byArray, n4 + 1) ^ n7 >> 3;
        return n7 &= 0x1FFF;
    }

    private static int readU16(byte[] byArray, int n4) {
        if (n4 + 1 >= byArray.length) {
            return byArray[n4] & 0xFF;
        }
        return (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4] & 0xFF;
    }

    private FastLz() {
    }
}

