/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.ByteBufChecksum;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;
import java.nio.ByteBuffer;

final class CompressionUtil {
    private CompressionUtil() {
    }

    static void checkChecksum(ByteBufChecksum byteBufChecksum, ByteBuf byteBuf, int n4) {
        byteBufChecksum.reset();
        byteBufChecksum.update(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
        int n7 = (int)byteBufChecksum.getValue();
        if (n7 != n4) {
            throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", n7, n4));
        }
    }

    static ByteBuffer safeNioBuffer(ByteBuf byteBuf) {
        return byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes()) : byteBuf.nioBuffer();
    }

    static ByteBuffer safeNioBuffer(ByteBuf byteBuf, int n4, int n7) {
        return byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(n4, n7) : byteBuf.nioBuffer(n4, n7);
    }
}

