/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2MoveToFrontTable;

final class Bzip2MTFAndRLE2StageEncoder {
    private final int[] bwtBlock;
    private final int bwtLength;
    private final boolean[] bwtValuesPresent;
    private final char[] mtfBlock;
    private int mtfLength;
    private final int[] mtfSymbolFrequencies = new int[258];
    private int alphabetSize;

    Bzip2MTFAndRLE2StageEncoder(int[] nArray, int n4, boolean[] blArray) {
        this.bwtBlock = nArray;
        this.bwtLength = n4;
        this.bwtValuesPresent = blArray;
        this.mtfBlock = new char[n4 + 1];
    }

    void encode() {
        int n4;
        int n7 = this.bwtLength;
        boolean[] blArray = this.bwtValuesPresent;
        int[] nArray = this.bwtBlock;
        char[] cArray = this.mtfBlock;
        int[] nArray2 = this.mtfSymbolFrequencies;
        byte[] byArray = new byte[256];
        Bzip2MoveToFrontTable bzip2MoveToFrontTable = new Bzip2MoveToFrontTable();
        int n8 = 0;
        for (n4 = 0; n4 < byArray.length; ++n4) {
            if (!blArray[n4]) continue;
            byArray[n4] = (byte)n8++;
        }
        n4 = n8 + 1;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (int i3 = 0; i3 < n7; ++i3) {
            int n14 = bzip2MoveToFrontTable.valueToFront(byArray[nArray[i3] & 0xFF]);
            if (n14 == 0) {
                ++n11;
                continue;
            }
            if (n11 > 0) {
                --n11;
                while (true) {
                    if ((n11 & 1) == 0) {
                        cArray[n10++] = '\u0000';
                        ++n12;
                    } else {
                        cArray[n10++] = '\u0001';
                        ++n13;
                    }
                    if (n11 <= 1) break;
                    n11 = n11 - 2 >>> 1;
                }
                n11 = 0;
            }
            cArray[n10++] = (char)(n14 + 1);
            int n15 = n14 + 1;
            nArray2[n15] = nArray2[n15] + 1;
        }
        if (n11 > 0) {
            --n11;
            while (true) {
                if ((n11 & 1) == 0) {
                    cArray[n10++] = '\u0000';
                    ++n12;
                } else {
                    cArray[n10++] = '\u0001';
                    ++n13;
                }
                if (n11 <= 1) break;
                n11 = n11 - 2 >>> 1;
            }
        }
        cArray[n10] = (char)n4;
        int n16 = n4;
        nArray2[n16] = nArray2[n16] + 1;
        nArray2[0] = nArray2[0] + n12;
        nArray2[1] = nArray2[1] + n13;
        this.mtfLength = n10 + 1;
        this.alphabetSize = n4 + 1;
    }

    char[] mtfBlock() {
        return this.mtfBlock;
    }

    int mtfLength() {
        return this.mtfLength;
    }

    int mtfAlphabetSize() {
        return this.alphabetSize;
    }

    int[] mtfSymbolFrequencies() {
        return this.mtfSymbolFrequencies;
    }
}

