/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2BitWriter;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2HuffmanAllocator;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import java.util.Arrays;

final class Bzip2HuffmanStageEncoder {
    private static final int HUFFMAN_HIGH_SYMBOL_COST = 15;
    private final Bzip2BitWriter writer;
    private final char[] mtfBlock;
    private final int mtfLength;
    private final int mtfAlphabetSize;
    private final int[] mtfSymbolFrequencies;
    private final int[][] huffmanCodeLengths;
    private final int[][] huffmanMergedCodeSymbols;
    private final byte[] selectors;

    Bzip2HuffmanStageEncoder(Bzip2BitWriter bzip2BitWriter, char[] cArray, int n4, int n7, int[] nArray) {
        this.writer = bzip2BitWriter;
        this.mtfBlock = cArray;
        this.mtfLength = n4;
        this.mtfAlphabetSize = n7;
        this.mtfSymbolFrequencies = nArray;
        int n8 = Bzip2HuffmanStageEncoder.selectTableCount(n4);
        this.huffmanCodeLengths = new int[n8][n7];
        this.huffmanMergedCodeSymbols = new int[n8][n7];
        this.selectors = new byte[(n4 + 50 - 1) / 50];
    }

    private static int selectTableCount(int n4) {
        if (n4 >= 2400) {
            return 6;
        }
        if (n4 >= 1200) {
            return 5;
        }
        if (n4 >= 600) {
            return 4;
        }
        if (n4 >= 200) {
            return 3;
        }
        return 2;
    }

    private static void generateHuffmanCodeLengths(int n4, int[] nArray, int[] nArray2) {
        int n7;
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        for (n7 = 0; n7 < n4; ++n7) {
            nArray3[n7] = nArray[n7] << 9 | n7;
        }
        Arrays.sort(nArray3);
        for (n7 = 0; n7 < n4; ++n7) {
            nArray4[n7] = nArray3[n7] >>> 9;
        }
        Bzip2HuffmanAllocator.allocateHuffmanCodeLengths(nArray4, 20);
        for (n7 = 0; n7 < n4; ++n7) {
            nArray2[nArray3[n7] & 0x1FF] = nArray4[n7];
        }
    }

    private void generateHuffmanOptimisationSeeds() {
        int[][] nArray = this.huffmanCodeLengths;
        int[] nArray2 = this.mtfSymbolFrequencies;
        int n4 = this.mtfAlphabetSize;
        int n7 = nArray.length;
        int n8 = this.mtfLength;
        int n10 = -1;
        for (int i3 = 0; i3 < n7; ++i3) {
            int n11;
            int n12 = n8 / (n7 - i3);
            int n13 = n10 + 1;
            for (n11 = 0; n11 < n12 && n10 < n4 - 1; n11 += nArray2[++n10]) {
            }
            if (n10 > n13 && i3 != 0 && i3 != n7 - 1 && (n7 - i3 & 1) == 0) {
                n11 -= nArray2[n10--];
            }
            int[] nArray3 = nArray[i3];
            for (int i8 = 0; i8 < n4; ++i8) {
                if (i8 >= n13 && i8 <= n10) continue;
                nArray3[i8] = 15;
            }
            n8 -= n11;
        }
    }

    private void optimiseSelectorsAndHuffmanTables(boolean bl3) {
        char[] cArray = this.mtfBlock;
        byte[] byArray = this.selectors;
        int[][] nArray = this.huffmanCodeLengths;
        int n4 = this.mtfLength;
        int n7 = this.mtfAlphabetSize;
        int n8 = nArray.length;
        int[][] nArray2 = new int[n8][n7];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n4) {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16 = Math.min(n11 + 50, n4) - 1;
            short[] sArray = new short[n8];
            for (n15 = n11; n15 <= n16; ++n15) {
                n14 = cArray[n15];
                for (n13 = 0; n13 < n8; ++n13) {
                    int n17 = n13;
                    sArray[n17] = (short)(sArray[n17] + nArray[n13][n14]);
                }
            }
            n15 = 0;
            n14 = sArray[0];
            for (n13 = 1; n13 < n8; n13 = (int)((byte)(n13 + 1))) {
                n12 = sArray[n13];
                if (n12 >= n14) continue;
                n14 = n12;
                n15 = n13;
            }
            int[] nArray3 = nArray2[n15];
            for (n12 = n11; n12 <= n16; ++n12) {
                char c10 = cArray[n12];
                nArray3[c10] = nArray3[c10] + 1;
            }
            if (bl3) {
                byArray[n10++] = n15;
            }
            n11 = n16 + 1;
        }
        for (n11 = 0; n11 < n8; ++n11) {
            Bzip2HuffmanStageEncoder.generateHuffmanCodeLengths(n7, nArray2[n11], nArray[n11]);
        }
    }

    private void assignHuffmanCodeSymbols() {
        int[][] nArray = this.huffmanMergedCodeSymbols;
        int[][] nArray2 = this.huffmanCodeLengths;
        int n4 = this.mtfAlphabetSize;
        int n7 = nArray2.length;
        for (int i3 = 0; i3 < n7; ++i3) {
            int n8;
            int n10;
            int[] nArray3 = nArray2[i3];
            int n11 = 32;
            int n12 = 0;
            for (n10 = 0; n10 < n4; ++n10) {
                n8 = nArray3[n10];
                if (n8 > n12) {
                    n12 = n8;
                }
                if (n8 >= n11) continue;
                n11 = n8;
            }
            n10 = 0;
            for (n8 = n11; n8 <= n12; ++n8) {
                for (int i8 = 0; i8 < n4; ++i8) {
                    if ((nArray2[i3][i8] & 0xFF) != n8) continue;
                    nArray[i3][i8] = n8 << 24 | n10;
                    ++n10;
                }
                n10 <<= 1;
            }
        }
    }

    private void writeSelectorsAndHuffmanTables(ByteBuf byteBuf) {
        Bzip2BitWriter bzip2BitWriter = this.writer;
        byte[] byArray = this.selectors;
        int n4 = byArray.length;
        int[][] nArray = this.huffmanCodeLengths;
        int n7 = nArray.length;
        int n8 = this.mtfAlphabetSize;
        bzip2BitWriter.writeBits(byteBuf, 3, n7);
        bzip2BitWriter.writeBits(byteBuf, 15, n4);
        Bzip2MoveToFrontTable bzip2MoveToFrontTable = new Bzip2MoveToFrontTable();
        for (byte by3 : byArray) {
            bzip2BitWriter.writeUnary(byteBuf, bzip2MoveToFrontTable.valueToFront(by3));
        }
        for (int[] nArray2 : nArray) {
            int n10 = nArray2[0];
            bzip2BitWriter.writeBits(byteBuf, 5, n10);
            for (int i3 = 0; i3 < n8; ++i3) {
                int n11 = nArray2[i3];
                int n12 = n10 < n11 ? 2 : 3;
                int n13 = Math.abs(n11 - n10);
                while (n13-- > 0) {
                    bzip2BitWriter.writeBits(byteBuf, 2, n12);
                }
                bzip2BitWriter.writeBoolean(byteBuf, false);
                n10 = n11;
            }
        }
    }

    private void writeBlockData(ByteBuf byteBuf) {
        Bzip2BitWriter bzip2BitWriter = this.writer;
        int[][] nArray = this.huffmanMergedCodeSymbols;
        byte[] byArray = this.selectors;
        char[] cArray = this.mtfBlock;
        int n4 = this.mtfLength;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            int n10 = Math.min(n8 + 50, n4) - 1;
            int[] nArray2 = nArray[byArray[n7++]];
            while (n8 <= n10) {
                int n11 = nArray2[cArray[n8++]];
                bzip2BitWriter.writeBits(byteBuf, n11 >>> 24, n11);
            }
        }
    }

    void encode(ByteBuf byteBuf) {
        this.generateHuffmanOptimisationSeeds();
        for (int i3 = 3; i3 >= 0; --i3) {
            this.optimiseSelectorsAndHuffmanTables(i3 == 0);
        }
        this.assignHuffmanCodeSymbols();
        this.writeSelectorsAndHuffmanTables(byteBuf);
        this.writeBlockData(byteBuf);
    }
}

