/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2BitReader;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;

final class Bzip2HuffmanStageDecoder {
    private final Bzip2BitReader reader;
    byte[] selectors;
    private final int[] minimumLengths;
    private final int[][] codeBases;
    private final int[][] codeLimits;
    private final int[][] codeSymbols;
    private int currentTable;
    private int groupIndex = -1;
    private int groupPosition = -1;
    final int totalTables;
    final int alphabetSize;
    final Bzip2MoveToFrontTable tableMTF = new Bzip2MoveToFrontTable();
    int currentSelector;
    final byte[][] tableCodeLengths;
    int currentGroup;
    int currentLength = -1;
    int currentAlpha;
    boolean modifyLength;

    Bzip2HuffmanStageDecoder(Bzip2BitReader bzip2BitReader, int n4, int n7) {
        this.reader = bzip2BitReader;
        this.totalTables = n4;
        this.alphabetSize = n7;
        this.minimumLengths = new int[n4];
        this.codeBases = new int[n4][25];
        this.codeLimits = new int[n4][24];
        this.codeSymbols = new int[n4][258];
        this.tableCodeLengths = new byte[n4][258];
    }

    void createHuffmanDecodingTables() {
        int n4 = this.alphabetSize;
        for (int i3 = 0; i3 < this.tableCodeLengths.length; ++i3) {
            int n7;
            int n8;
            int n10;
            int[] nArray = this.codeBases[i3];
            int[] nArray2 = this.codeLimits[i3];
            int[] nArray3 = this.codeSymbols[i3];
            byte[] byArray = this.tableCodeLengths[i3];
            int n11 = 23;
            int n12 = 0;
            for (n10 = 0; n10 < n4; ++n10) {
                n8 = byArray[n10];
                n12 = Math.max(n8, n12);
                n11 = Math.min(n8, n11);
            }
            this.minimumLengths[i3] = n11;
            for (n10 = 0; n10 < n4; ++n10) {
                int n13 = byArray[n10] + 1;
                nArray[n13] = nArray[n13] + 1;
            }
            n8 = nArray[0];
            for (n10 = 1; n10 < 25; ++n10) {
                nArray[n10] = n8 += nArray[n10];
            }
            n8 = 0;
            for (n10 = n11; n10 <= n12; ++n10) {
                n7 = n8;
                nArray[n10] = n7 - nArray[n10];
                nArray2[n10] = (n8 += nArray[n10 + 1] - nArray[n10]) - 1;
                n8 <<= 1;
            }
            n8 = 0;
            for (n10 = n11; n10 <= n12; ++n10) {
                for (n7 = 0; n7 < n4; ++n7) {
                    if (byArray[n7] != n10) continue;
                    nArray3[n8++] = n7;
                }
            }
        }
        this.currentTable = this.selectors[0];
    }

    int nextSymbol() {
        int n4;
        if (++this.groupPosition % 50 == 0) {
            ++this.groupIndex;
            if (this.groupIndex == this.selectors.length) {
                throw new DecompressionException("error decoding block");
            }
            this.currentTable = this.selectors[this.groupIndex] & 0xFF;
        }
        Bzip2BitReader bzip2BitReader = this.reader;
        int n7 = this.currentTable;
        int[] nArray = this.codeLimits[n7];
        int[] nArray2 = this.codeBases[n7];
        int[] nArray3 = this.codeSymbols[n7];
        int n8 = bzip2BitReader.readBits(n4);
        for (n4 = this.minimumLengths[n7]; n4 <= 23; ++n4) {
            if (n8 <= nArray[n4]) {
                return nArray3[n8 - nArray2[n4]];
            }
            n8 = n8 << 1 | bzip2BitReader.readBits(1);
        }
        throw new DecompressionException("a valid code was not recognised");
    }
}

