/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

final class Bzip2HuffmanAllocator {
    private static int first(int[] nArray, int n4, int n7) {
        int n8 = nArray.length;
        int n10 = n4;
        int n11 = nArray.length - 2;
        while (n4 >= n7 && nArray[n4] % n8 > n10) {
            n11 = n4;
            n4 -= n10 - n4 + 1;
        }
        n4 = Math.max(n7 - 1, n4);
        while (n11 > n4 + 1) {
            int n12 = n4 + n11 >>> 1;
            if (nArray[n12] % n8 > n10) {
                n11 = n12;
                continue;
            }
            n4 = n12;
        }
        return n11;
    }

    private static void setExtendedParentPointers(int[] nArray) {
        int n4 = nArray.length;
        nArray[0] = nArray[0] + nArray[1];
        int n7 = 0;
        int n8 = 2;
        for (int i3 = 1; i3 < n4 - 1; ++i3) {
            int n10;
            if (n8 >= n4 || nArray[n7] < nArray[n8]) {
                n10 = nArray[n7];
                nArray[n7++] = i3;
            } else {
                n10 = nArray[n8++];
            }
            if (n8 >= n4 || n7 < i3 && nArray[n7] < nArray[n8]) {
                n10 += nArray[n7];
                nArray[n7++] = i3 + n4;
            } else {
                n10 += nArray[n8++];
            }
            nArray[i3] = n10;
        }
    }

    private static int findNodesToRelocate(int[] nArray, int n4) {
        int n7 = nArray.length - 2;
        for (int i3 = 1; i3 < n4 - 1 && n7 > 1; ++i3) {
            n7 = Bzip2HuffmanAllocator.first(nArray, n7 - 1, 0);
        }
        return n7;
    }

    private static void allocateNodeLengths(int[] nArray) {
        int n4 = nArray.length - 2;
        int n7 = nArray.length - 1;
        int n8 = 1;
        int n10 = 2;
        while (n10 > 0) {
            int n11 = n4;
            n4 = Bzip2HuffmanAllocator.first(nArray, n11 - 1, 0);
            for (int i3 = n10 - (n11 - n4); i3 > 0; --i3) {
                nArray[n7--] = n8;
            }
            n10 = n11 - n4 << 1;
            ++n8;
        }
    }

    private static void allocateNodeLengthsWithRelocation(int[] nArray, int n4, int n7) {
        int n8 = nArray.length - 2;
        int n10 = nArray.length - 1;
        int n11 = n7 == 1 ? 2 : 1;
        int n12 = n7 == 1 ? n4 - 2 : n4;
        int n13 = n11 << 1;
        while (n13 > 0) {
            int n14 = n8;
            n8 = n8 <= n4 ? n8 : Bzip2HuffmanAllocator.first(nArray, n14 - 1, n4);
            int n15 = 0;
            if (n11 >= n7) {
                n15 = Math.min(n12, 1 << n11 - n7);
            } else if (n11 == n7 - 1) {
                n15 = 1;
                if (nArray[n8] == n14) {
                    ++n8;
                }
            }
            for (int i3 = n13 - (n14 - n8 + n15); i3 > 0; --i3) {
                nArray[n10--] = n11;
            }
            n12 -= n15;
            n13 = n14 - n8 + n15 << 1;
            ++n11;
        }
    }

    static void allocateHuffmanCodeLengths(int[] nArray, int n4) {
        switch (nArray.length) {
            case 2: {
                nArray[1] = 1;
            }
            case 1: {
                nArray[0] = 1;
                return;
            }
        }
        Bzip2HuffmanAllocator.setExtendedParentPointers(nArray);
        int n7 = Bzip2HuffmanAllocator.findNodesToRelocate(nArray, n4);
        if (nArray[0] % nArray.length >= n7) {
            Bzip2HuffmanAllocator.allocateNodeLengths(nArray);
        } else {
            int n8 = n4 - (32 - Integer.numberOfLeadingZeros(n7 - 1));
            Bzip2HuffmanAllocator.allocateNodeLengthsWithRelocation(nArray, n7, n8);
        }
    }

    private Bzip2HuffmanAllocator() {
    }
}

