/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2DivSufSort$PartitionResult;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2DivSufSort$StackEntry;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2DivSufSort$TRBudget;

final class Bzip2DivSufSort {
    private static final int STACK_SIZE = 64;
    private static final int BUCKET_A_SIZE = 256;
    private static final int BUCKET_B_SIZE = 65536;
    private static final int SS_BLOCKSIZE = 1024;
    private static final int INSERTIONSORT_THRESHOLD = 8;
    private static final int[] LOG_2_TABLE = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private final int[] SA;
    private final byte[] T;
    private final int n;

    Bzip2DivSufSort(byte[] byArray, int[] nArray, int n4) {
        this.T = byArray;
        this.SA = nArray;
        this.n = n4;
    }

    private static void swapElements(int[] nArray, int n4, int[] nArray2, int n7) {
        int n8 = nArray[n4];
        nArray[n4] = nArray2[n7];
        nArray2[n7] = n8;
    }

    private int ssCompare(int n4, int n7, int n8) {
        int n10;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n11 = nArray[n4 + 1] + 2;
        int n12 = nArray[n7 + 1] + 2;
        int n13 = n8 + nArray[n4];
        for (n10 = n8 + nArray[n7]; n13 < n11 && n10 < n12 && byArray[n13] == byArray[n10]; ++n13, ++n10) {
        }
        return n13 < n11 ? (n10 < n12 ? (byArray[n13] & 0xFF) - (byArray[n10] & 0xFF) : 1) : (n10 < n12 ? -1 : 0);
    }

    private int ssCompareLast(int n4, int n7, int n8, int n10, int n11) {
        int n12;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n13 = n10 + nArray[n7];
        int n14 = n11;
        int n15 = nArray[n8 + 1] + 2;
        for (n12 = n10 + nArray[n8]; n13 < n14 && n12 < n15 && byArray[n13] == byArray[n12]; ++n13, ++n12) {
        }
        if (n13 < n14) {
            return n12 < n15 ? (byArray[n13] & 0xFF) - (byArray[n12] & 0xFF) : 1;
        }
        if (n12 == n15) {
            return 1;
        }
        n13 %= n11;
        n14 = nArray[n4] + 2;
        while (n13 < n14 && n12 < n15 && byArray[n13] == byArray[n12]) {
            ++n13;
            ++n12;
        }
        return n13 < n14 ? (n12 < n15 ? (byArray[n13] & 0xFF) - (byArray[n12] & 0xFF) : 1) : (n12 < n15 ? -1 : 0);
    }

    private void ssInsertionSort(int n4, int n7, int n8, int n10) {
        int[] nArray = this.SA;
        for (int i3 = n8 - 2; n7 <= i3; --i3) {
            int n11;
            int n12 = nArray[i3];
            int n13 = i3 + 1;
            while (0 < (n11 = this.ssCompare(n4 + n12, n4 + nArray[n13], n10))) {
                do {
                    nArray[n13 - 1] = nArray[n13];
                } while (++n13 < n8 && nArray[n13] < 0);
                if (n8 > n13) continue;
            }
            if (n11 == 0) {
                nArray[n13] = ~nArray[n13];
            }
            nArray[n13 - 1] = n12;
        }
    }

    private void ssFixdown(int n4, int n7, int n8, int n10, int n11) {
        int n12;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n13 = nArray[n8 + n10];
        int n14 = byArray[n4 + nArray[n7 + n13]] & 0xFF;
        while ((n12 = 2 * n10 + 1) < n11) {
            int n15;
            int n16;
            int n17;
            if ((n17 = byArray[n4 + nArray[n7 + nArray[n8 + (n16 = n12++)]]] & 0xFF) < (n15 = byArray[n4 + nArray[n7 + nArray[n8 + n12]]] & 0xFF)) {
                n16 = n12;
                n17 = n15;
            }
            if (n17 <= n14) break;
            nArray[n8 + n10] = nArray[n8 + n16];
            n10 = n16;
        }
        nArray[n8 + n10] = n13;
    }

    private void ssHeapSort(int n4, int n7, int n8, int n10) {
        int n11;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n12 = n10;
        if (n10 % 2 == 0 && (byArray[n4 + nArray[n7 + nArray[n8 + --n12 / 2]]] & 0xFF) < (byArray[n4 + nArray[n7 + nArray[n8 + n12]]] & 0xFF)) {
            Bzip2DivSufSort.swapElements(nArray, n8 + n12, nArray, n8 + n12 / 2);
        }
        for (n11 = n12 / 2 - 1; 0 <= n11; --n11) {
            this.ssFixdown(n4, n7, n8, n11, n12);
        }
        if (n10 % 2 == 0) {
            Bzip2DivSufSort.swapElements(nArray, n8, nArray, n8 + n12);
            this.ssFixdown(n4, n7, n8, 0, n12);
        }
        for (n11 = n12 - 1; 0 < n11; --n11) {
            int n13 = nArray[n8];
            nArray[n8] = nArray[n8 + n11];
            this.ssFixdown(n4, n7, n8, 0, n11);
            nArray[n8 + n11] = n13;
        }
    }

    private int ssMedian3(int n4, int n7, int n8, int n10, int n11) {
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n12 = byArray[n4 + nArray[n7 + nArray[n8]]] & 0xFF;
        int n13 = byArray[n4 + nArray[n7 + nArray[n10]]] & 0xFF;
        int n14 = byArray[n4 + nArray[n7 + nArray[n11]]] & 0xFF;
        if (n12 > n13) {
            int n15 = n8;
            n8 = n10;
            n10 = n15;
            int n16 = n12;
            n12 = n13;
            n13 = n16;
        }
        if (n13 > n14) {
            if (n12 > n14) {
                return n8;
            }
            return n11;
        }
        return n10;
    }

    private int ssMedian5(int n4, int n7, int n8, int n10, int n11, int n12, int n13) {
        int n14;
        int n15;
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n16 = byArray[n4 + nArray[n7 + nArray[n8]]] & 0xFF;
        int n17 = byArray[n4 + nArray[n7 + nArray[n10]]] & 0xFF;
        int n18 = byArray[n4 + nArray[n7 + nArray[n11]]] & 0xFF;
        int n19 = byArray[n4 + nArray[n7 + nArray[n12]]] & 0xFF;
        int n20 = byArray[n4 + nArray[n7 + nArray[n13]]] & 0xFF;
        if (n17 > n18) {
            n15 = n10;
            n10 = n11;
            n11 = n15;
            n14 = n17;
            n17 = n18;
            n18 = n14;
        }
        if (n19 > n20) {
            n15 = n12;
            n12 = n13;
            n13 = n15;
            n14 = n19;
            n19 = n20;
            n20 = n14;
        }
        if (n17 > n19) {
            n12 = n15 = n10;
            n19 = n14 = n17;
            n15 = n11;
            n11 = n13;
            n13 = n15;
            n14 = n18;
            n18 = n20;
            n20 = n14;
        }
        if (n16 > n18) {
            n15 = n8;
            n8 = n11;
            n11 = n15;
            n14 = n16;
            n16 = n18;
            n18 = n14;
        }
        if (n16 > n19) {
            n12 = n15 = n8;
            n19 = n14 = n16;
            n11 = n13;
            n18 = n20;
        }
        if (n18 > n19) {
            return n12;
        }
        return n11;
    }

    private int ssPivot(int n4, int n7, int n8, int n10) {
        int n11 = n10 - n8;
        int n12 = n8 + n11 / 2;
        if (n11 <= 512) {
            if (n11 <= 32) {
                return this.ssMedian3(n4, n7, n8, n12, n10 - 1);
            }
            return this.ssMedian5(n4, n7, n8, n8 + (n11 >>= 2), n12, n10 - 1 - n11, n10 - 1);
        }
        return this.ssMedian3(n4, n7, this.ssMedian3(n4, n7, n8, n8 + (n11 >>= 3), n8 + (n11 << 1)), this.ssMedian3(n4, n7, n12 - n11, n12, n12 + n11), this.ssMedian3(n4, n7, n10 - 1 - (n11 << 1), n10 - 1 - n11, n10 - 1));
    }

    private static int ssLog(int n4) {
        return (n4 & 0xFF00) != 0 ? 8 + LOG_2_TABLE[n4 >> 8 & 0xFF] : LOG_2_TABLE[n4 & 0xFF];
    }

    private int ssSubstringPartition(int n4, int n7, int n8, int n10) {
        int[] nArray = this.SA;
        int n11 = n7 - 1;
        int n12 = n8;
        while (true) {
            if (++n11 < n12 && nArray[n4 + nArray[n11]] + n10 >= nArray[n4 + nArray[n11] + 1] + 1) {
                nArray[n11] = ~nArray[n11];
                continue;
            }
            --n12;
            while (n11 < n12 && nArray[n4 + nArray[n12]] + n10 < nArray[n4 + nArray[n12] + 1] + 1) {
                --n12;
            }
            if (n12 <= n11) break;
            int n13 = ~nArray[n12];
            nArray[n12] = nArray[n11];
            nArray[n11] = n13;
        }
        if (n7 < n11) {
            nArray[n7] = ~nArray[n7];
        }
        return n11;
    }

    private void ssMultiKeyIntroSort(int n4, int n7, int n8, int n10) {
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        Bzip2DivSufSort$StackEntry[] bzip2DivSufSort$StackEntryArray = new Bzip2DivSufSort$StackEntry[64];
        int n11 = 0;
        int n12 = 0;
        int n13 = Bzip2DivSufSort.ssLog(n8 - n7);
        while (true) {
            int n14;
            int n15;
            int n16;
            int n17;
            if (n8 - n7 <= 8) {
                if (1 < n8 - n7) {
                    this.ssInsertionSort(n4, n7, n8, n10);
                }
                if (n12 == 0) {
                    return;
                }
                Bzip2DivSufSort$StackEntry bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n12];
                n7 = bzip2DivSufSort$StackEntry.a;
                n8 = bzip2DivSufSort$StackEntry.b;
                n10 = bzip2DivSufSort$StackEntry.c;
                n13 = bzip2DivSufSort$StackEntry.d;
                continue;
            }
            int n18 = n10;
            if (n13-- == 0) {
                this.ssHeapSort(n18, n4, n7, n8 - n7);
            }
            if (n13 < 0) {
                n17 = byArray[n18 + nArray[n4 + nArray[n7]]] & 0xFF;
                for (n16 = n7 + 1; n16 < n8; ++n16) {
                    n11 = byArray[n18 + nArray[n4 + nArray[n16]]] & 0xFF;
                    if (n11 == n17) continue;
                    if (1 < n16 - n7) break;
                    n17 = n11;
                    n7 = n16;
                }
                if ((byArray[n18 + nArray[n4 + nArray[n7]] - 1] & 0xFF) < n17) {
                    n7 = this.ssSubstringPartition(n4, n7, n16, n10);
                }
                if (n16 - n7 <= n8 - n16) {
                    if (1 < n16 - n7) {
                        bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n16, n8, n10, -1);
                        n8 = n16;
                        ++n10;
                        n13 = Bzip2DivSufSort.ssLog(n16 - n7);
                        continue;
                    }
                    n7 = n16;
                    n13 = -1;
                    continue;
                }
                if (1 < n8 - n16) {
                    bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n7, n16, n10 + 1, Bzip2DivSufSort.ssLog(n16 - n7));
                    n7 = n16;
                    n13 = -1;
                    continue;
                }
                n8 = n16;
                ++n10;
                n13 = Bzip2DivSufSort.ssLog(n16 - n7);
                continue;
            }
            n16 = this.ssPivot(n18, n4, n7, n8);
            n17 = byArray[n18 + nArray[n4 + nArray[n16]]] & 0xFF;
            Bzip2DivSufSort.swapElements(nArray, n7, nArray, n16);
            for (n15 = n7 + 1; n15 < n8 && (n11 = byArray[n18 + nArray[n4 + nArray[n15]]] & 0xFF) == n17; ++n15) {
            }
            n16 = n15;
            if (n16 < n8 && n11 < n17) {
                while (++n15 < n8 && (n11 = byArray[n18 + nArray[n4 + nArray[n15]]] & 0xFF) <= n17) {
                    if (n11 != n17) continue;
                    Bzip2DivSufSort.swapElements(nArray, n15, nArray, n16);
                    ++n16;
                }
            }
            for (n14 = n8 - 1; n15 < n14 && (n11 = byArray[n18 + nArray[n4 + nArray[n14]]] & 0xFF) == n17; --n14) {
            }
            int n19 = n14;
            if (n15 < n19 && n11 > n17) {
                while (n15 < --n14 && (n11 = byArray[n18 + nArray[n4 + nArray[n14]]] & 0xFF) >= n17) {
                    if (n11 != n17) continue;
                    Bzip2DivSufSort.swapElements(nArray, n14, nArray, n19);
                    --n19;
                }
            }
            while (n15 < n14) {
                Bzip2DivSufSort.swapElements(nArray, n15, nArray, n14);
                while (++n15 < n14 && (n11 = byArray[n18 + nArray[n4 + nArray[n15]]] & 0xFF) <= n17) {
                    if (n11 != n17) continue;
                    Bzip2DivSufSort.swapElements(nArray, n15, nArray, n16);
                    ++n16;
                }
                while (n15 < --n14 && (n11 = byArray[n18 + nArray[n4 + nArray[n14]]] & 0xFF) >= n17) {
                    if (n11 != n17) continue;
                    Bzip2DivSufSort.swapElements(nArray, n14, nArray, n19);
                    --n19;
                }
            }
            if (n16 <= n19) {
                n14 = n15 - 1;
                int n20 = n16 - n7;
                int n21 = n15 - n16;
                if (n20 > n21) {
                    n20 = n21;
                }
                int n22 = n7;
                int n23 = n15 - n20;
                while (0 < n20) {
                    Bzip2DivSufSort.swapElements(nArray, n22, nArray, n23);
                    --n20;
                    ++n22;
                    ++n23;
                }
                n20 = n19 - n14;
                n21 = n8 - n19 - 1;
                if (n20 > n21) {
                    n20 = n21;
                }
                n22 = n15;
                n23 = n8 - n20;
                while (0 < n20) {
                    Bzip2DivSufSort.swapElements(nArray, n22, nArray, n23);
                    --n20;
                    ++n22;
                    ++n23;
                }
                n16 = n7 + (n15 - n16);
                n14 = n8 - (n19 - n14);
                int n24 = n15 = n17 <= (byArray[n18 + nArray[n4 + nArray[n16]] - 1] & 0xFF) ? n16 : this.ssSubstringPartition(n4, n16, n14, n10);
                if (n16 - n7 <= n8 - n14) {
                    if (n8 - n14 <= n14 - n15) {
                        bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n15, n14, n10 + 1, Bzip2DivSufSort.ssLog(n14 - n15));
                        bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n14, n8, n10, n13);
                        n8 = n16;
                        continue;
                    }
                    if (n16 - n7 <= n14 - n15) {
                        bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n14, n8, n10, n13);
                        bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n15, n14, n10 + 1, Bzip2DivSufSort.ssLog(n14 - n15));
                        n8 = n16;
                        continue;
                    }
                    bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n14, n8, n10, n13);
                    bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n7, n16, n10, n13);
                    n7 = n15;
                    n8 = n14;
                    ++n10;
                    n13 = Bzip2DivSufSort.ssLog(n14 - n15);
                    continue;
                }
                if (n16 - n7 <= n14 - n15) {
                    bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n15, n14, n10 + 1, Bzip2DivSufSort.ssLog(n14 - n15));
                    bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n7, n16, n10, n13);
                    n7 = n14;
                    continue;
                }
                if (n8 - n14 <= n14 - n15) {
                    bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n7, n16, n10, n13);
                    bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n15, n14, n10 + 1, Bzip2DivSufSort.ssLog(n14 - n15));
                    n7 = n14;
                    continue;
                }
                bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n7, n16, n10, n13);
                bzip2DivSufSort$StackEntryArray[n12++] = new Bzip2DivSufSort$StackEntry(n14, n8, n10, n13);
                n7 = n15;
                n8 = n14;
                ++n10;
                n13 = Bzip2DivSufSort.ssLog(n14 - n15);
                continue;
            }
            ++n13;
            if ((byArray[n18 + nArray[n4 + nArray[n7]] - 1] & 0xFF) < n17) {
                n7 = this.ssSubstringPartition(n4, n7, n8, n10);
                n13 = Bzip2DivSufSort.ssLog(n8 - n7);
            }
            ++n10;
        }
    }

    private static void ssBlockSwap(int[] nArray, int n4, int[] nArray2, int n7, int n8) {
        int n10 = n8;
        int n11 = n4;
        int n12 = n7;
        while (0 < n10) {
            Bzip2DivSufSort.swapElements(nArray, n11, nArray2, n12);
            --n10;
            ++n11;
            ++n12;
        }
    }

    private void ssMergeForward(int n4, int[] nArray, int n7, int n8, int n10, int n11, int n12) {
        int[] nArray2 = this.SA;
        int n13 = n7 + (n10 - n8) - 1;
        Bzip2DivSufSort.ssBlockSwap(nArray, n7, nArray2, n8, n10 - n8);
        int n14 = nArray2[n8];
        int n15 = n8;
        int n16 = n7;
        int n17 = n10;
        while (true) {
            int n18;
            if ((n18 = this.ssCompare(n4 + nArray[n16], n4 + nArray2[n17], n12)) < 0) {
                do {
                    nArray2[n15++] = nArray[n16];
                    if (n13 <= n16) {
                        nArray[n16] = n14;
                        return;
                    }
                    nArray[n16++] = nArray2[n15];
                } while (nArray[n16] < 0);
                continue;
            }
            if (n18 > 0) {
                do {
                    nArray2[n15++] = nArray2[n17];
                    nArray2[n17++] = nArray2[n15];
                    if (n11 > n17) continue;
                    while (n16 < n13) {
                        nArray2[n15++] = nArray[n16];
                        nArray[n16++] = nArray2[n15];
                    }
                    nArray2[n15] = nArray[n16];
                    nArray[n16] = n14;
                    return;
                } while (nArray2[n17] < 0);
                continue;
            }
            nArray2[n17] = ~nArray2[n17];
            do {
                nArray2[n15++] = nArray[n16];
                if (n13 <= n16) {
                    nArray[n16] = n14;
                    return;
                }
                nArray[n16++] = nArray2[n15];
            } while (nArray[n16] < 0);
            do {
                nArray2[n15++] = nArray2[n17];
                nArray2[n17++] = nArray2[n15];
                if (n11 > n17) continue;
                while (n16 < n13) {
                    nArray2[n15++] = nArray[n16];
                    nArray[n16++] = nArray2[n15];
                }
                nArray2[n15] = nArray[n16];
                nArray[n16] = n14;
                return;
            } while (nArray2[n17] < 0);
        }
    }

    private void ssMergeBackward(int n4, int[] nArray, int n7, int n8, int n10, int n11, int n12) {
        int n13;
        int n14;
        int[] nArray2 = this.SA;
        int n15 = n7 + (n11 - n10);
        Bzip2DivSufSort.ssBlockSwap(nArray, n7, nArray2, n10, n11 - n10);
        int n16 = 0;
        if (nArray[n15 - 1] < 0) {
            n16 |= 1;
            n14 = n4 + ~nArray[n15 - 1];
        } else {
            n14 = n4 + nArray[n15 - 1];
        }
        if (nArray2[n10 - 1] < 0) {
            n16 |= 2;
            n13 = n4 + ~nArray2[n10 - 1];
        } else {
            n13 = n4 + nArray2[n10 - 1];
        }
        int n17 = nArray2[n11 - 1];
        int n18 = n11 - 1;
        int n19 = n15 - 1;
        int n20 = n10 - 1;
        while (true) {
            int n21;
            if ((n21 = this.ssCompare(n14, n13, n12)) > 0) {
                if ((n16 & 1) != 0) {
                    do {
                        nArray2[n18--] = nArray[n19];
                        nArray[n19--] = nArray2[n18];
                    } while (nArray[n19] < 0);
                    n16 ^= 1;
                }
                nArray2[n18--] = nArray[n19];
                if (n19 <= n7) {
                    nArray[n19] = n17;
                    return;
                }
                nArray[n19--] = nArray2[n18];
                if (nArray[n19] < 0) {
                    n16 |= 1;
                    n14 = n4 + ~nArray[n19];
                    continue;
                }
                n14 = n4 + nArray[n19];
                continue;
            }
            if (n21 < 0) {
                if ((n16 & 2) != 0) {
                    do {
                        nArray2[n18--] = nArray2[n20];
                        nArray2[n20--] = nArray2[n18];
                    } while (nArray2[n20] < 0);
                    n16 ^= 2;
                }
                nArray2[n18--] = nArray2[n20];
                nArray2[n20--] = nArray2[n18];
                if (n20 < n8) {
                    while (n7 < n19) {
                        nArray2[n18--] = nArray[n19];
                        nArray[n19--] = nArray2[n18];
                    }
                    nArray2[n18] = nArray[n19];
                    nArray[n19] = n17;
                    return;
                }
                if (nArray2[n20] < 0) {
                    n16 |= 2;
                    n13 = n4 + ~nArray2[n20];
                    continue;
                }
                n13 = n4 + nArray2[n20];
                continue;
            }
            if ((n16 & 1) != 0) {
                do {
                    nArray2[n18--] = nArray[n19];
                    nArray[n19--] = nArray2[n18];
                } while (nArray[n19] < 0);
                n16 ^= 1;
            }
            nArray2[n18--] = ~nArray[n19];
            if (n19 <= n7) {
                nArray[n19] = n17;
                return;
            }
            nArray[n19--] = nArray2[n18];
            if ((n16 & 2) != 0) {
                do {
                    nArray2[n18--] = nArray2[n20];
                    nArray2[n20--] = nArray2[n18];
                } while (nArray2[n20] < 0);
                n16 ^= 2;
            }
            nArray2[n18--] = nArray2[n20];
            nArray2[n20--] = nArray2[n18];
            if (n20 < n8) {
                while (n7 < n19) {
                    nArray2[n18--] = nArray[n19];
                    nArray[n19--] = nArray2[n18];
                }
                nArray2[n18] = nArray[n19];
                nArray[n19] = n17;
                return;
            }
            if (nArray[n19] < 0) {
                n16 |= 1;
                n14 = n4 + ~nArray[n19];
            } else {
                n14 = n4 + nArray[n19];
            }
            if (nArray2[n20] < 0) {
                n16 |= 2;
                n13 = n4 + ~nArray2[n20];
                continue;
            }
            n13 = n4 + nArray2[n20];
        }
    }

    private static int getIDX(int n4) {
        return 0 <= n4 ? n4 : ~n4;
    }

    private void ssMergeCheckEqual(int n4, int n7, int n8) {
        int[] nArray = this.SA;
        if (0 <= nArray[n8] && this.ssCompare(n4 + Bzip2DivSufSort.getIDX(nArray[n8 - 1]), n4 + nArray[n8], n7) == 0) {
            nArray[n8] = ~nArray[n8];
        }
    }

    private void ssMerge(int n4, int n7, int n8, int n10, int[] nArray, int n11, int n12, int n13) {
        int[] nArray2 = this.SA;
        Bzip2DivSufSort$StackEntry[] bzip2DivSufSort$StackEntryArray = new Bzip2DivSufSort$StackEntry[64];
        int n14 = 0;
        int n15 = 0;
        while (true) {
            Bzip2DivSufSort$StackEntry bzip2DivSufSort$StackEntry;
            if (n10 - n8 <= n12) {
                if (n7 < n8 && n8 < n10) {
                    this.ssMergeBackward(n4, nArray, n11, n7, n8, n10, n13);
                }
                if (n14 & true) {
                    this.ssMergeCheckEqual(n4, n13, n7);
                }
                if ((n14 & 2) != 0) {
                    this.ssMergeCheckEqual(n4, n13, n10);
                }
                if (n15 == 0) {
                    return;
                }
                bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n15];
                n7 = bzip2DivSufSort$StackEntry.a;
                n8 = bzip2DivSufSort$StackEntry.b;
                n10 = bzip2DivSufSort$StackEntry.c;
                n14 = bzip2DivSufSort$StackEntry.d;
                continue;
            }
            if (n8 - n7 <= n12) {
                if (n7 < n8) {
                    this.ssMergeForward(n4, nArray, n11, n7, n8, n10, n13);
                }
                if ((n14 & 1) != 0) {
                    this.ssMergeCheckEqual(n4, n13, n7);
                }
                if ((n14 & 2) != 0) {
                    this.ssMergeCheckEqual(n4, n13, n10);
                }
                if (n15 == 0) {
                    return;
                }
                bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n15];
                n7 = bzip2DivSufSort$StackEntry.a;
                n8 = bzip2DivSufSort$StackEntry.b;
                n10 = bzip2DivSufSort$StackEntry.c;
                n14 = bzip2DivSufSort$StackEntry.d;
                continue;
            }
            int n16 = 0;
            int n17 = Math.min(n8 - n7, n10 - n8);
            int n18 = n17 >> 1;
            while (0 < n17) {
                if (this.ssCompare(n4 + Bzip2DivSufSort.getIDX(nArray2[n8 + n16 + n18]), n4 + Bzip2DivSufSort.getIDX(nArray2[n8 - n16 - n18 - 1]), n13) < 0) {
                    n16 += n18 + 1;
                    n18 -= n17 & 1 ^ 1;
                }
                n17 = n18;
                n18 >>= 1;
            }
            if (0 < n16) {
                int n19;
                Bzip2DivSufSort.ssBlockSwap(nArray2, n8 - n16, nArray2, n8, n16);
                int n20 = n19 = n8;
                int n21 = 0;
                if (n8 + n16 < n10) {
                    if (nArray2[n8 + n16] < 0) {
                        while (nArray2[n20 - 1] < 0) {
                            --n20;
                        }
                        nArray2[n8 + n16] = ~nArray2[n8 + n16];
                    }
                    n19 = n8;
                    while (nArray2[n19] < 0) {
                        ++n19;
                    }
                    n21 = 1;
                }
                if (n20 - n7 <= n10 - n19) {
                    bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n19, n8 + n16, n10, n14 & 2 | n21 & 1);
                    n8 -= n16;
                    n10 = n20;
                    n14 &= 1;
                    continue;
                }
                if (n20 == n8 && n8 == n19) {
                    n21 <<= 1;
                }
                bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n8 - n16, n20, n14 & 1 | n21 & 2);
                n7 = n19;
                n8 += n16;
                n14 = n14 & 2 | n21 & 1;
                continue;
            }
            if ((n14 & 1) != 0) {
                this.ssMergeCheckEqual(n4, n13, n7);
            }
            this.ssMergeCheckEqual(n4, n13, n8);
            if ((n14 & 2) != 0) {
                this.ssMergeCheckEqual(n4, n13, n10);
            }
            if (n15 == 0) {
                return;
            }
            bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n15];
            n7 = bzip2DivSufSort$StackEntry.a;
            n8 = bzip2DivSufSort$StackEntry.b;
            n10 = bzip2DivSufSort$StackEntry.c;
            n14 = bzip2DivSufSort$StackEntry.d;
        }
    }

    private void subStringSort(int n4, int n7, int n8, int[] nArray, int n10, int n11, int n12, boolean bl3, int n13) {
        int n14;
        int[] nArray2 = this.SA;
        if (bl3) {
            ++n7;
        }
        int n15 = n7;
        int n16 = 0;
        while (n15 + 1024 < n8) {
            this.ssMultiKeyIntroSort(n4, n15, n15 + 1024, n12);
            int[] nArray3 = nArray2;
            int n17 = n15 + 1024;
            int n18 = n8 - (n15 + 1024);
            if (n18 <= n11) {
                n18 = n11;
                nArray3 = nArray;
                n17 = n10;
            }
            int n19 = n15;
            n14 = 1024;
            int n20 = n16;
            while ((n20 & 1) != 0) {
                this.ssMerge(n4, n19 - n14, n19, n19 + n14, nArray3, n17, n18, n12);
                n19 -= n14;
                n14 <<= 1;
                n20 >>>= 1;
            }
            n15 += 1024;
            ++n16;
        }
        this.ssMultiKeyIntroSort(n4, n15, n8, n12);
        n14 = 1024;
        while (n16 != 0) {
            if (n16 & true) {
                this.ssMerge(n4, n15 - n14, n15, n8, nArray, n10, n11, n12);
                n15 -= n14;
            }
            n14 <<= 1;
            n16 >>= 1;
        }
        if (bl3) {
            n16 = nArray2[n7 - 1];
            int n21 = 1;
            for (n15 = n7; n15 < n8 && (nArray2[n15] < 0 || 0 < (n21 = this.ssCompareLast(n4, n4 + n16, n4 + nArray2[n15], n12, n13))); ++n15) {
                nArray2[n15 - 1] = nArray2[n15];
            }
            if (n21 == 0) {
                nArray2[n15] = ~nArray2[n15];
            }
            nArray2[n15 - 1] = n16;
        }
    }

    private int trGetC(int n4, int n7, int n8, int n10) {
        return n7 + n10 < n8 ? this.SA[n7 + n10] : this.SA[n4 + (n7 - n4 + n10) % (n8 - n4)];
    }

    private void trFixdown(int n4, int n7, int n8, int n10, int n11, int n12) {
        int n13;
        int[] nArray = this.SA;
        int n14 = nArray[n10 + n11];
        int n15 = this.trGetC(n4, n7, n8, n14);
        while ((n13 = 2 * n11 + 1) < n12) {
            int n16;
            int n17;
            int n18;
            if ((n18 = this.trGetC(n4, n7, n8, nArray[n10 + (n17 = n13++)])) < (n16 = this.trGetC(n4, n7, n8, nArray[n10 + n13]))) {
                n17 = n13;
                n18 = n16;
            }
            if (n18 <= n15) break;
            nArray[n10 + n11] = nArray[n10 + n17];
            n11 = n17;
        }
        nArray[n10 + n11] = n14;
    }

    private void trHeapSort(int n4, int n7, int n8, int n10, int n11) {
        int n12;
        int[] nArray = this.SA;
        int n13 = n11;
        if (n11 % 2 == 0 && this.trGetC(n4, n7, n8, nArray[n10 + --n13 / 2]) < this.trGetC(n4, n7, n8, nArray[n10 + n13])) {
            Bzip2DivSufSort.swapElements(nArray, n10 + n13, nArray, n10 + n13 / 2);
        }
        for (n12 = n13 / 2 - 1; 0 <= n12; --n12) {
            this.trFixdown(n4, n7, n8, n10, n12, n13);
        }
        if (n11 % 2 == 0) {
            Bzip2DivSufSort.swapElements(nArray, n10, nArray, n10 + n13);
            this.trFixdown(n4, n7, n8, n10, 0, n13);
        }
        for (n12 = n13 - 1; 0 < n12; --n12) {
            int n14 = nArray[n10];
            nArray[n10] = nArray[n10 + n12];
            this.trFixdown(n4, n7, n8, n10, 0, n12);
            nArray[n10 + n12] = n14;
        }
    }

    private void trInsertionSort(int n4, int n7, int n8, int n10, int n11) {
        int[] nArray = this.SA;
        for (int i3 = n10 + 1; i3 < n11; ++i3) {
            int n12;
            int n13 = nArray[i3];
            int n14 = i3 - 1;
            while (0 > (n12 = this.trGetC(n4, n7, n8, n13) - this.trGetC(n4, n7, n8, nArray[n14]))) {
                do {
                    nArray[n14 + 1] = nArray[n14];
                } while (n10 <= --n14 && nArray[n14] < 0);
                if (n14 >= n10) continue;
            }
            if (n12 == 0) {
                nArray[n14] = ~nArray[n14];
            }
            nArray[n14 + 1] = n13;
        }
    }

    private static int trLog(int n4) {
        return (n4 & 0xFFFF0000) != 0 ? ((n4 & 0xFF000000) != 0 ? 24 + LOG_2_TABLE[n4 >> 24 & 0xFF] : LOG_2_TABLE[n4 >> 16 & 0x10F]) : ((n4 & 0xFF00) != 0 ? 8 + LOG_2_TABLE[n4 >> 8 & 0xFF] : LOG_2_TABLE[n4 & 0xFF]);
    }

    private int trMedian3(int n4, int n7, int n8, int n10, int n11, int n12) {
        int[] nArray = this.SA;
        int n13 = this.trGetC(n4, n7, n8, nArray[n10]);
        int n14 = this.trGetC(n4, n7, n8, nArray[n11]);
        int n15 = this.trGetC(n4, n7, n8, nArray[n12]);
        if (n13 > n14) {
            int n16 = n10;
            n10 = n11;
            n11 = n16;
            int n17 = n13;
            n13 = n14;
            n14 = n17;
        }
        if (n14 > n15) {
            if (n13 > n15) {
                return n10;
            }
            return n12;
        }
        return n11;
    }

    private int trMedian5(int n4, int n7, int n8, int n10, int n11, int n12, int n13, int n14) {
        int n15;
        int n16;
        int[] nArray = this.SA;
        int n17 = this.trGetC(n4, n7, n8, nArray[n10]);
        int n18 = this.trGetC(n4, n7, n8, nArray[n11]);
        int n19 = this.trGetC(n4, n7, n8, nArray[n12]);
        int n20 = this.trGetC(n4, n7, n8, nArray[n13]);
        int n21 = this.trGetC(n4, n7, n8, nArray[n14]);
        if (n18 > n19) {
            n16 = n11;
            n11 = n12;
            n12 = n16;
            n15 = n18;
            n18 = n19;
            n19 = n15;
        }
        if (n20 > n21) {
            n16 = n13;
            n13 = n14;
            n14 = n16;
            n15 = n20;
            n20 = n21;
            n21 = n15;
        }
        if (n18 > n20) {
            n13 = n16 = n11;
            n20 = n15 = n18;
            n16 = n12;
            n12 = n14;
            n14 = n16;
            n15 = n19;
            n19 = n21;
            n21 = n15;
        }
        if (n17 > n19) {
            n16 = n10;
            n10 = n12;
            n12 = n16;
            n15 = n17;
            n17 = n19;
            n19 = n15;
        }
        if (n17 > n20) {
            n13 = n16 = n10;
            n20 = n15 = n17;
            n12 = n14;
            n19 = n21;
        }
        if (n19 > n20) {
            return n13;
        }
        return n12;
    }

    private int trPivot(int n4, int n7, int n8, int n10, int n11) {
        int n12 = n11 - n10;
        int n13 = n10 + n12 / 2;
        if (n12 <= 512) {
            if (n12 <= 32) {
                return this.trMedian3(n4, n7, n8, n10, n13, n11 - 1);
            }
            return this.trMedian5(n4, n7, n8, n10, n10 + (n12 >>= 2), n13, n11 - 1 - n12, n11 - 1);
        }
        return this.trMedian3(n4, n7, n8, this.trMedian3(n4, n7, n8, n10, n10 + (n12 >>= 3), n10 + (n12 << 1)), this.trMedian3(n4, n7, n8, n13 - n12, n13, n13 + n12), this.trMedian3(n4, n7, n8, n11 - 1 - (n12 << 1), n11 - 1 - n12, n11 - 1));
    }

    private void lsUpdateGroup(int n4, int n7, int n8) {
        int[] nArray = this.SA;
        for (int i3 = n7; i3 < n8; ++i3) {
            int n10;
            if (0 <= nArray[i3]) {
                n10 = i3;
                do {
                    nArray[n4 + nArray[i3]] = i3;
                } while (++i3 < n8 && 0 <= nArray[i3]);
                nArray[n10] = n10 - i3;
                if (n8 <= i3) break;
            }
            n10 = i3;
            do {
                nArray[i3] = ~nArray[i3];
            } while (nArray[++i3] < 0);
            int n11 = i3;
            do {
                nArray[n4 + nArray[n10]] = n11;
            } while (++n10 <= i3);
        }
    }

    private void lsIntroSort(int n4, int n7, int n8, int n10, int n11) {
        int[] nArray = this.SA;
        Bzip2DivSufSort$StackEntry[] bzip2DivSufSort$StackEntryArray = new Bzip2DivSufSort$StackEntry[64];
        int n12 = 0;
        int n13 = 0;
        int n14 = Bzip2DivSufSort.trLog(n11 - n10);
        while (true) {
            int n15;
            int n16;
            int n17;
            Bzip2DivSufSort$StackEntry bzip2DivSufSort$StackEntry;
            if (n11 - n10 <= 8) {
                if (1 < n11 - n10) {
                    this.trInsertionSort(n4, n7, n8, n10, n11);
                    this.lsUpdateGroup(n4, n10, n11);
                } else if (n11 - n10 == 1) {
                    nArray[n10] = -1;
                }
                if (n13 == 0) {
                    return;
                }
                bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n13];
                n10 = bzip2DivSufSort$StackEntry.a;
                n11 = bzip2DivSufSort$StackEntry.b;
                n14 = bzip2DivSufSort$StackEntry.c;
                continue;
            }
            if (n14-- == 0) {
                this.trHeapSort(n4, n7, n8, n10, n11 - n10);
                n17 = n11 - 1;
                while (n10 < n17) {
                    n12 = this.trGetC(n4, n7, n8, nArray[n17]);
                    for (n16 = n17 - 1; n10 <= n16 && this.trGetC(n4, n7, n8, nArray[n16]) == n12; --n16) {
                        nArray[n16] = ~nArray[n16];
                    }
                    n17 = n16;
                }
                this.lsUpdateGroup(n4, n10, n11);
                if (n13 == 0) {
                    return;
                }
                bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n13];
                n10 = bzip2DivSufSort$StackEntry.a;
                n11 = bzip2DivSufSort$StackEntry.b;
                n14 = bzip2DivSufSort$StackEntry.c;
                continue;
            }
            n17 = this.trPivot(n4, n7, n8, n10, n11);
            Bzip2DivSufSort.swapElements(nArray, n10, nArray, n17);
            int n18 = this.trGetC(n4, n7, n8, nArray[n10]);
            for (n16 = n10 + 1; n16 < n11 && (n12 = this.trGetC(n4, n7, n8, nArray[n16])) == n18; ++n16) {
            }
            n17 = n16;
            if (n17 < n11 && n12 < n18) {
                while (++n16 < n11 && (n12 = this.trGetC(n4, n7, n8, nArray[n16])) <= n18) {
                    if (n12 != n18) continue;
                    Bzip2DivSufSort.swapElements(nArray, n16, nArray, n17);
                    ++n17;
                }
            }
            for (n15 = n11 - 1; n16 < n15 && (n12 = this.trGetC(n4, n7, n8, nArray[n15])) == n18; --n15) {
            }
            int n19 = n15;
            if (n16 < n19 && n12 > n18) {
                while (n16 < --n15 && (n12 = this.trGetC(n4, n7, n8, nArray[n15])) >= n18) {
                    if (n12 != n18) continue;
                    Bzip2DivSufSort.swapElements(nArray, n15, nArray, n19);
                    --n19;
                }
            }
            while (n16 < n15) {
                Bzip2DivSufSort.swapElements(nArray, n16, nArray, n15);
                while (++n16 < n15 && (n12 = this.trGetC(n4, n7, n8, nArray[n16])) <= n18) {
                    if (n12 != n18) continue;
                    Bzip2DivSufSort.swapElements(nArray, n16, nArray, n17);
                    ++n17;
                }
                while (n16 < --n15 && (n12 = this.trGetC(n4, n7, n8, nArray[n15])) >= n18) {
                    if (n12 != n18) continue;
                    Bzip2DivSufSort.swapElements(nArray, n15, nArray, n19);
                    --n19;
                }
            }
            if (n17 <= n19) {
                n15 = n16 - 1;
                int n20 = n17 - n10;
                int n21 = n16 - n17;
                if (n20 > n21) {
                    n20 = n21;
                }
                int n22 = n10;
                int n23 = n16 - n20;
                while (0 < n20) {
                    Bzip2DivSufSort.swapElements(nArray, n22, nArray, n23);
                    --n20;
                    ++n22;
                    ++n23;
                }
                n20 = n19 - n15;
                n21 = n11 - n19 - 1;
                if (n20 > n21) {
                    n20 = n21;
                }
                n22 = n16;
                n23 = n11 - n20;
                while (0 < n20) {
                    Bzip2DivSufSort.swapElements(nArray, n22, nArray, n23);
                    --n20;
                    ++n22;
                    ++n23;
                }
                n17 = n10 + (n16 - n17);
                n16 = n11 - (n19 - n15);
                n18 = n17 - 1;
                for (n15 = n10; n15 < n17; ++n15) {
                    nArray[n4 + nArray[n15]] = n18;
                }
                if (n16 < n11) {
                    n18 = n16 - 1;
                    for (n15 = n17; n15 < n16; ++n15) {
                        nArray[n4 + nArray[n15]] = n18;
                    }
                }
                if (n16 - n17 == 1) {
                    nArray[n17] = -1;
                }
                if (n17 - n10 <= n11 - n16) {
                    if (n10 < n17) {
                        bzip2DivSufSort$StackEntryArray[n13++] = new Bzip2DivSufSort$StackEntry(n16, n11, n14, 0);
                        n11 = n17;
                        continue;
                    }
                    n10 = n16;
                    continue;
                }
                if (n16 < n11) {
                    bzip2DivSufSort$StackEntryArray[n13++] = new Bzip2DivSufSort$StackEntry(n10, n17, n14, 0);
                    n10 = n16;
                    continue;
                }
                n11 = n17;
                continue;
            }
            if (n13 == 0) {
                return;
            }
            bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n13];
            n10 = bzip2DivSufSort$StackEntry.a;
            n11 = bzip2DivSufSort$StackEntry.b;
            n14 = bzip2DivSufSort$StackEntry.c;
        }
    }

    private void lsSort(int n4, int n7, int n8) {
        int[] nArray = this.SA;
        int n10 = n4 + n8;
        while (-n7 < nArray[0]) {
            int n11;
            int n12;
            int n13 = 0;
            int n14 = 0;
            do {
                if ((n12 = nArray[n13]) < 0) {
                    n13 -= n12;
                    n14 += n12;
                    continue;
                }
                if (n14 != 0) {
                    nArray[n13 + n14] = n14;
                    n14 = 0;
                }
                n11 = nArray[n4 + n12] + 1;
                this.lsIntroSort(n4, n10, n4 + n7, n13, n11);
                n13 = n11;
            } while (n13 < n7);
            if (n14 != 0) {
                nArray[n13 + n14] = n14;
            }
            if (n7 < n10 - n4) {
                n13 = 0;
                do {
                    if ((n12 = nArray[n13]) < 0) {
                        n13 -= n12;
                        continue;
                    }
                    n11 = nArray[n4 + n12] + 1;
                    for (int i3 = n13; i3 < n11; ++i3) {
                        nArray[n4 + nArray[i3]] = i3;
                    }
                    n13 = n11;
                } while (n13 < n7);
                break;
            }
            n10 += n10 - n4;
        }
    }

    private Bzip2DivSufSort$PartitionResult trPartition(int n4, int n7, int n8, int n10, int n11, int n12) {
        int n13;
        int n14;
        int[] nArray = this.SA;
        int n15 = 0;
        for (n14 = n10; n14 < n11 && (n15 = this.trGetC(n4, n7, n8, nArray[n14])) == n12; ++n14) {
        }
        int n16 = n14;
        if (n16 < n11 && n15 < n12) {
            while (++n14 < n11 && (n15 = this.trGetC(n4, n7, n8, nArray[n14])) <= n12) {
                if (n15 != n12) continue;
                Bzip2DivSufSort.swapElements(nArray, n14, nArray, n16);
                ++n16;
            }
        }
        for (n13 = n11 - 1; n14 < n13 && (n15 = this.trGetC(n4, n7, n8, nArray[n13])) == n12; --n13) {
        }
        int n17 = n13;
        if (n14 < n17 && n15 > n12) {
            while (n14 < --n13 && (n15 = this.trGetC(n4, n7, n8, nArray[n13])) >= n12) {
                if (n15 != n12) continue;
                Bzip2DivSufSort.swapElements(nArray, n13, nArray, n17);
                --n17;
            }
        }
        while (n14 < n13) {
            Bzip2DivSufSort.swapElements(nArray, n14, nArray, n13);
            while (++n14 < n13 && (n15 = this.trGetC(n4, n7, n8, nArray[n14])) <= n12) {
                if (n15 != n12) continue;
                Bzip2DivSufSort.swapElements(nArray, n14, nArray, n16);
                ++n16;
            }
            while (n14 < --n13 && (n15 = this.trGetC(n4, n7, n8, nArray[n13])) >= n12) {
                if (n15 != n12) continue;
                Bzip2DivSufSort.swapElements(nArray, n13, nArray, n17);
                --n17;
            }
        }
        if (n16 <= n17) {
            n13 = n14 - 1;
            int n18 = n16 - n10;
            int n19 = n14 - n16;
            if (n18 > n19) {
                n18 = n19;
            }
            int n20 = n10;
            int n21 = n14 - n18;
            while (0 < n18) {
                Bzip2DivSufSort.swapElements(nArray, n20, nArray, n21);
                --n18;
                ++n20;
                ++n21;
            }
            n18 = n17 - n13;
            n19 = n11 - n17 - 1;
            if (n18 > n19) {
                n18 = n19;
            }
            n20 = n14;
            n21 = n11 - n18;
            while (0 < n18) {
                Bzip2DivSufSort.swapElements(nArray, n20, nArray, n21);
                --n18;
                ++n20;
                ++n21;
            }
            n10 += n14 - n16;
            n11 -= n17 - n13;
        }
        return new Bzip2DivSufSort$PartitionResult(n10, n11);
    }

    private void trCopy(int n4, int n7, int n8, int n10, int n11, int n12, int n13) {
        int n14;
        int n15;
        int[] nArray = this.SA;
        int n16 = n11 - 1;
        int n17 = n10 - 1;
        for (n15 = n8; n15 <= n17; ++n15) {
            n14 = nArray[n15] - n13;
            if (n14 < 0) {
                n14 += n7 - n4;
            }
            if (nArray[n4 + n14] != n16) continue;
            nArray[++n17] = n14;
            nArray[n4 + n14] = n17;
        }
        n15 = n12 - 1;
        int n18 = n17 + 1;
        n17 = n11;
        while (n18 < n17) {
            n14 = nArray[n15] - n13;
            if (n14 < 0) {
                n14 += n7 - n4;
            }
            if (nArray[n4 + n14] == n16) {
                nArray[--n17] = n14;
                nArray[n4 + n14] = n17;
            }
            --n15;
        }
    }

    private void trIntroSort(int n4, int n7, int n8, int n10, int n11, Bzip2DivSufSort$TRBudget bzip2DivSufSort$TRBudget, int n12) {
        int n13;
        int[] nArray = this.SA;
        Bzip2DivSufSort$StackEntry[] bzip2DivSufSort$StackEntryArray = new Bzip2DivSufSort$StackEntry[64];
        int n14 = 0;
        int n15 = 0;
        int n16 = Bzip2DivSufSort.trLog(n11 - n10);
        while (true) {
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            Object object;
            if (n16 < 0) {
                if (n16 == -1) {
                    Bzip2DivSufSort$StackEntry bzip2DivSufSort$StackEntry;
                    if (!bzip2DivSufSort$TRBudget.update(n12, n11 - n10)) break;
                    object = this.trPartition(n4, n7 - 1, n8, n10, n11, n11 - 1);
                    n21 = ((Bzip2DivSufSort$PartitionResult)object).first;
                    n20 = ((Bzip2DivSufSort$PartitionResult)object).last;
                    if (n10 < n21 || n20 < n11) {
                        if (n21 < n11) {
                            n19 = n21 - 1;
                            for (n18 = n10; n18 < n21; ++n18) {
                                nArray[n4 + nArray[n18]] = n19;
                            }
                        }
                        if (n20 < n11) {
                            n19 = n20 - 1;
                            for (n18 = n21; n18 < n20; ++n18) {
                                nArray[n4 + nArray[n18]] = n19;
                            }
                        }
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(0, n21, n20, 0);
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7 - 1, n10, n11, -2);
                        if (n21 - n10 <= n11 - n20) {
                            if (1 < n21 - n10) {
                                bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n20, n11, Bzip2DivSufSort.trLog(n11 - n20));
                                n11 = n21;
                                n16 = Bzip2DivSufSort.trLog(n21 - n10);
                                continue;
                            }
                            if (1 < n11 - n20) {
                                n10 = n20;
                                n16 = Bzip2DivSufSort.trLog(n11 - n20);
                                continue;
                            }
                            if (n15 == 0) {
                                return;
                            }
                            bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n15];
                            n7 = bzip2DivSufSort$StackEntry.a;
                            n10 = bzip2DivSufSort$StackEntry.b;
                            n11 = bzip2DivSufSort$StackEntry.c;
                            n16 = bzip2DivSufSort$StackEntry.d;
                            continue;
                        }
                        if (1 < n11 - n20) {
                            bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n10, n21, Bzip2DivSufSort.trLog(n21 - n10));
                            n10 = n20;
                            n16 = Bzip2DivSufSort.trLog(n11 - n20);
                            continue;
                        }
                        if (1 < n21 - n10) {
                            n11 = n21;
                            n16 = Bzip2DivSufSort.trLog(n21 - n10);
                            continue;
                        }
                        if (n15 == 0) {
                            return;
                        }
                        bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n15];
                        n7 = bzip2DivSufSort$StackEntry.a;
                        n10 = bzip2DivSufSort$StackEntry.b;
                        n11 = bzip2DivSufSort$StackEntry.c;
                        n16 = bzip2DivSufSort$StackEntry.d;
                        continue;
                    }
                    for (n18 = n10; n18 < n11; ++n18) {
                        nArray[n4 + nArray[n18]] = n18;
                    }
                    if (n15 == 0) {
                        return;
                    }
                    bzip2DivSufSort$StackEntry = bzip2DivSufSort$StackEntryArray[--n15];
                    n7 = bzip2DivSufSort$StackEntry.a;
                    n10 = bzip2DivSufSort$StackEntry.b;
                    n11 = bzip2DivSufSort$StackEntry.c;
                    n16 = bzip2DivSufSort$StackEntry.d;
                    continue;
                }
                if (n16 == -2) {
                    n21 = bzip2DivSufSort$StackEntryArray[--n15].b;
                    n20 = bzip2DivSufSort$StackEntryArray[n15].c;
                    this.trCopy(n4, n8, n10, n21, n20, n11, n7 - n4);
                    if (n15 == 0) {
                        return;
                    }
                    object = bzip2DivSufSort$StackEntryArray[--n15];
                    n7 = ((Bzip2DivSufSort$StackEntry)object).a;
                    n10 = ((Bzip2DivSufSort$StackEntry)object).b;
                    n11 = ((Bzip2DivSufSort$StackEntry)object).c;
                    n16 = ((Bzip2DivSufSort$StackEntry)object).d;
                    continue;
                }
                if (0 <= nArray[n10]) {
                    n21 = n10;
                    do {
                        nArray[n4 + nArray[n21]] = n21;
                    } while (++n21 < n11 && 0 <= nArray[n21]);
                    n10 = n21;
                }
                if (n10 < n11) {
                    n21 = n10;
                    do {
                        nArray[n21] = ~nArray[n21];
                    } while (nArray[++n21] < 0);
                    int n22 = n17 = nArray[n4 + nArray[n21]] != nArray[n7 + nArray[n21]] ? Bzip2DivSufSort.trLog(n21 - n10 + 1) : -1;
                    if (++n21 < n11) {
                        n19 = n21 - 1;
                        for (n20 = n10; n20 < n21; ++n20) {
                            nArray[n4 + nArray[n20]] = n19;
                        }
                    }
                    if (n21 - n10 <= n11 - n21) {
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n21, n11, -3);
                        ++n7;
                        n11 = n21;
                        n16 = n17;
                        continue;
                    }
                    if (1 < n11 - n21) {
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7 + 1, n10, n21, n17);
                        n10 = n21;
                        n16 = -3;
                        continue;
                    }
                    ++n7;
                    n11 = n21;
                    n16 = n17;
                    continue;
                }
                if (n15 == 0) {
                    return;
                }
                object = bzip2DivSufSort$StackEntryArray[--n15];
                n7 = ((Bzip2DivSufSort$StackEntry)object).a;
                n10 = ((Bzip2DivSufSort$StackEntry)object).b;
                n11 = ((Bzip2DivSufSort$StackEntry)object).c;
                n16 = ((Bzip2DivSufSort$StackEntry)object).d;
                continue;
            }
            if (n11 - n10 <= 8) {
                if (!bzip2DivSufSort$TRBudget.update(n12, n11 - n10)) break;
                this.trInsertionSort(n4, n7, n8, n10, n11);
                n16 = -3;
                continue;
            }
            if (n16-- == 0) {
                if (!bzip2DivSufSort$TRBudget.update(n12, n11 - n10)) break;
                this.trHeapSort(n4, n7, n8, n10, n11 - n10);
                n21 = n11 - 1;
                while (n10 < n21) {
                    n14 = this.trGetC(n4, n7, n8, nArray[n21]);
                    for (n20 = n21 - 1; n10 <= n20 && this.trGetC(n4, n7, n8, nArray[n20]) == n14; --n20) {
                        nArray[n20] = ~nArray[n20];
                    }
                    n21 = n20;
                }
                n16 = -3;
                continue;
            }
            n21 = this.trPivot(n4, n7, n8, n10, n11);
            Bzip2DivSufSort.swapElements(nArray, n10, nArray, n21);
            n19 = this.trGetC(n4, n7, n8, nArray[n10]);
            for (n20 = n10 + 1; n20 < n11 && (n14 = this.trGetC(n4, n7, n8, nArray[n20])) == n19; ++n20) {
            }
            n21 = n20;
            if (n21 < n11 && n14 < n19) {
                while (++n20 < n11 && (n14 = this.trGetC(n4, n7, n8, nArray[n20])) <= n19) {
                    if (n14 != n19) continue;
                    Bzip2DivSufSort.swapElements(nArray, n20, nArray, n21);
                    ++n21;
                }
            }
            for (n18 = n11 - 1; n20 < n18 && (n14 = this.trGetC(n4, n7, n8, nArray[n18])) == n19; --n18) {
            }
            int n23 = n18;
            if (n20 < n23 && n14 > n19) {
                while (n20 < --n18 && (n14 = this.trGetC(n4, n7, n8, nArray[n18])) >= n19) {
                    if (n14 != n19) continue;
                    Bzip2DivSufSort.swapElements(nArray, n18, nArray, n23);
                    --n23;
                }
            }
            while (n20 < n18) {
                Bzip2DivSufSort.swapElements(nArray, n20, nArray, n18);
                while (++n20 < n18 && (n14 = this.trGetC(n4, n7, n8, nArray[n20])) <= n19) {
                    if (n14 != n19) continue;
                    Bzip2DivSufSort.swapElements(nArray, n20, nArray, n21);
                    ++n21;
                }
                while (n20 < --n18 && (n14 = this.trGetC(n4, n7, n8, nArray[n18])) >= n19) {
                    if (n14 != n19) continue;
                    Bzip2DivSufSort.swapElements(nArray, n18, nArray, n23);
                    --n23;
                }
            }
            if (n21 <= n23) {
                n18 = n20 - 1;
                n13 = n21 - n10;
                int n24 = n20 - n21;
                if (n13 > n24) {
                    n13 = n24;
                }
                int n26 = n10;
                int n27 = n20 - n13;
                while (0 < n13) {
                    Bzip2DivSufSort.swapElements(nArray, n26, nArray, n27);
                    --n13;
                    ++n26;
                    ++n27;
                }
                n13 = n23 - n18;
                n24 = n11 - n23 - 1;
                if (n13 > n24) {
                    n13 = n24;
                }
                n26 = n20;
                n27 = n11 - n13;
                while (0 < n13) {
                    Bzip2DivSufSort.swapElements(nArray, n26, nArray, n27);
                    --n13;
                    ++n26;
                    ++n27;
                }
                n21 = n10 + (n20 - n21);
                n20 = n11 - (n23 - n18);
                n17 = nArray[n4 + nArray[n21]] != n19 ? Bzip2DivSufSort.trLog(n20 - n21) : -1;
                n19 = n21 - 1;
                for (n18 = n10; n18 < n21; ++n18) {
                    nArray[n4 + nArray[n18]] = n19;
                }
                if (n20 < n11) {
                    n19 = n20 - 1;
                    for (n18 = n21; n18 < n20; ++n18) {
                        nArray[n4 + nArray[n18]] = n19;
                    }
                }
                if (n21 - n10 <= n11 - n20) {
                    if (n11 - n20 <= n20 - n21) {
                        if (1 < n21 - n10) {
                            bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7 + 1, n21, n20, n17);
                            bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n20, n11, n16);
                            n11 = n21;
                            continue;
                        }
                        if (1 < n11 - n20) {
                            bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7 + 1, n21, n20, n17);
                            n10 = n20;
                            continue;
                        }
                        if (1 < n20 - n21) {
                            ++n7;
                            n10 = n21;
                            n11 = n20;
                            n16 = n17;
                            continue;
                        }
                        if (n15 == 0) {
                            return;
                        }
                        object = bzip2DivSufSort$StackEntryArray[--n15];
                        n7 = ((Bzip2DivSufSort$StackEntry)object).a;
                        n10 = ((Bzip2DivSufSort$StackEntry)object).b;
                        n11 = ((Bzip2DivSufSort$StackEntry)object).c;
                        n16 = ((Bzip2DivSufSort$StackEntry)object).d;
                        continue;
                    }
                    if (n21 - n10 <= n20 - n21) {
                        if (1 < n21 - n10) {
                            bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n20, n11, n16);
                            bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7 + 1, n21, n20, n17);
                            n11 = n21;
                            continue;
                        }
                        if (1 < n20 - n21) {
                            bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n20, n11, n16);
                            ++n7;
                            n10 = n21;
                            n11 = n20;
                            n16 = n17;
                            continue;
                        }
                        n10 = n20;
                        continue;
                    }
                    if (1 < n20 - n21) {
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n20, n11, n16);
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n10, n21, n16);
                        ++n7;
                        n10 = n21;
                        n11 = n20;
                        n16 = n17;
                        continue;
                    }
                    bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n20, n11, n16);
                    n11 = n21;
                    continue;
                }
                if (n21 - n10 <= n20 - n21) {
                    if (1 < n11 - n20) {
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7 + 1, n21, n20, n17);
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n10, n21, n16);
                        n10 = n20;
                        continue;
                    }
                    if (1 < n21 - n10) {
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7 + 1, n21, n20, n17);
                        n11 = n21;
                        continue;
                    }
                    if (1 < n20 - n21) {
                        ++n7;
                        n10 = n21;
                        n11 = n20;
                        n16 = n17;
                        continue;
                    }
                    bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n10, n11, n16);
                    continue;
                }
                if (n11 - n20 <= n20 - n21) {
                    if (1 < n11 - n20) {
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n10, n21, n16);
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7 + 1, n21, n20, n17);
                        n10 = n20;
                        continue;
                    }
                    if (1 < n20 - n21) {
                        bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n10, n21, n16);
                        ++n7;
                        n10 = n21;
                        n11 = n20;
                        n16 = n17;
                        continue;
                    }
                    n11 = n21;
                    continue;
                }
                if (1 < n20 - n21) {
                    bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n10, n21, n16);
                    bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n20, n11, n16);
                    ++n7;
                    n10 = n21;
                    n11 = n20;
                    n16 = n17;
                    continue;
                }
                bzip2DivSufSort$StackEntryArray[n15++] = new Bzip2DivSufSort$StackEntry(n7, n10, n21, n16);
                n10 = n20;
                continue;
            }
            if (!bzip2DivSufSort$TRBudget.update(n12, n11 - n10)) break;
            ++n16;
            ++n7;
        }
        for (n13 = 0; n13 < n15; ++n13) {
            if (bzip2DivSufSort$StackEntryArray[n13].d != -3) continue;
            this.lsUpdateGroup(n4, bzip2DivSufSort$StackEntryArray[n13].b, bzip2DivSufSort$StackEntryArray[n13].c);
        }
    }

    private void trSort(int n4, int n7, int n8) {
        int[] nArray = this.SA;
        int n10 = 0;
        if (-n7 < nArray[0]) {
            Bzip2DivSufSort$TRBudget bzip2DivSufSort$TRBudget = new Bzip2DivSufSort$TRBudget(n7, Bzip2DivSufSort.trLog(n7) * 2 / 3 + 1);
            do {
                int n11;
                if ((n11 = nArray[n10]) < 0) {
                    n10 -= n11;
                    continue;
                }
                int n12 = nArray[n4 + n11] + 1;
                if (1 < n12 - n10) {
                    this.trIntroSort(n4, n4 + n8, n4 + n7, n10, n12, bzip2DivSufSort$TRBudget, n7);
                    if (bzip2DivSufSort$TRBudget.chance == 0) {
                        if (0 < n10) {
                            nArray[0] = -n10;
                        }
                        this.lsSort(n4, n7, n8);
                        break;
                    }
                }
                n10 = n12;
            } while (n10 < n7);
        }
    }

    private static int BUCKET_B(int n4, int n7) {
        return n7 << 8 | n4;
    }

    private static int BUCKET_BSTAR(int n4, int n7) {
        return n4 << 8 | n7;
    }

    private int sortTypeBstar(int[] nArray, int[] nArray2) {
        int n4;
        int n7;
        int n8;
        int n10;
        int n11;
        byte[] byArray = this.T;
        int[] nArray3 = this.SA;
        int n12 = this.n;
        int[] nArray4 = new int[256];
        boolean bl3 = true;
        for (n11 = 1; n11 < n12; ++n11) {
            if (byArray[n11 - 1] == byArray[n11]) continue;
            if ((byArray[n11 - 1] & 0xFF) <= (byArray[n11] & 0xFF)) break;
            bl3 = false;
            break;
        }
        n11 = n12 - 1;
        int n13 = n12;
        int n14 = byArray[n11] & 0xFF;
        int n15 = byArray[0] & 0xFF;
        if (n14 < n15 || byArray[n11] == byArray[0] && bl3) {
            if (!bl3) {
                int n16 = Bzip2DivSufSort.BUCKET_BSTAR(n14, n15);
                nArray2[n16] = nArray2[n16] + 1;
                nArray3[--n13] = n11;
            } else {
                int n17 = Bzip2DivSufSort.BUCKET_B(n14, n15);
                nArray2[n17] = nArray2[n17] + 1;
            }
            --n11;
            while (0 <= n11 && (n14 = byArray[n11] & 0xFF) <= (n10 = byArray[n11 + 1] & 0xFF)) {
                int n18 = Bzip2DivSufSort.BUCKET_B(n14, n10);
                nArray2[n18] = nArray2[n18] + 1;
                --n11;
            }
        }
        while (0 <= n11) {
            do {
                int n19 = byArray[n11] & 0xFF;
                nArray[n19] = nArray[n19] + 1;
            } while (0 <= --n11 && (byArray[n11] & 0xFF) >= (byArray[n11 + 1] & 0xFF));
            if (0 > n11) continue;
            int n20 = Bzip2DivSufSort.BUCKET_BSTAR(byArray[n11] & 0xFF, byArray[n11 + 1] & 0xFF);
            nArray2[n20] = nArray2[n20] + 1;
            nArray3[--n13] = n11--;
            while (0 <= n11 && (n14 = byArray[n11] & 0xFF) <= (n10 = byArray[n11 + 1] & 0xFF)) {
                int n21 = Bzip2DivSufSort.BUCKET_B(n14, n10);
                nArray2[n21] = nArray2[n21] + 1;
                --n11;
            }
        }
        if ((n13 = n12 - n13) == 0) {
            for (n11 = 0; n11 < n12; ++n11) {
                nArray3[n11] = n11;
            }
            return 0;
        }
        n11 = -1;
        int n22 = 0;
        for (n8 = 0; n8 < 256; ++n8) {
            n7 = n11 + nArray[n8];
            nArray[n8] = n11 + n22;
            n11 = n7 + nArray2[Bzip2DivSufSort.BUCKET_B(n8, n8)];
            for (n4 = n8 + 1; n4 < 256; ++n4) {
                nArray2[n8 << 8 | n4] = n22 += nArray2[Bzip2DivSufSort.BUCKET_BSTAR(n8, n4)];
                n11 += nArray2[Bzip2DivSufSort.BUCKET_B(n8, n4)];
            }
        }
        int n23 = n12 - n13;
        int n24 = n13;
        n11 = n13 - 2;
        while (0 <= n11) {
            n7 = nArray3[n23 + n11];
            n8 = byArray[n7] & 0xFF;
            n4 = byArray[n7 + 1] & 0xFF;
            int n26 = Bzip2DivSufSort.BUCKET_BSTAR(n8, n4);
            int n27 = nArray2[n26] - 1;
            nArray2[n26] = n27;
            nArray3[n27] = n11--;
        }
        n7 = nArray3[n23 + n13 - 1];
        n8 = byArray[n7] & 0xFF;
        n4 = byArray[n7 + 1] & 0xFF;
        int n28 = Bzip2DivSufSort.BUCKET_BSTAR(n8, n4);
        int n29 = nArray2[n28] - 1;
        nArray2[n28] = n29;
        nArray3[n29] = n13 - 1;
        int[] nArray5 = nArray3;
        int n30 = n13;
        int n31 = n12 - 2 * n13;
        if (n31 <= 256) {
            nArray5 = nArray4;
            n30 = 0;
            n31 = 256;
        }
        n8 = 255;
        n22 = n13;
        while (0 < n22) {
            for (n4 = 255; n8 < n4; --n4) {
                n11 = nArray2[Bzip2DivSufSort.BUCKET_BSTAR(n8, n4)];
                if (1 < n22 - n11) {
                    this.subStringSort(n23, n11, n22, nArray5, n30, n31, 2, nArray3[n11] == n13 - 1, n12);
                }
                n22 = n11;
            }
            --n8;
        }
        for (n11 = n13 - 1; 0 <= n11; --n11) {
            if (0 <= nArray3[n11]) {
                n22 = n11;
                do {
                    nArray3[n24 + nArray3[n11]] = n11;
                } while (0 <= --n11 && 0 <= nArray3[n11]);
                nArray3[n11 + 1] = n11 - n22;
                if (n11 <= 0) break;
            }
            n22 = n11;
            do {
                nArray3[n11] = ~nArray3[n11];
                nArray3[n24 + nArray3[n11]] = n22;
            } while (nArray3[--n11] < 0);
            nArray3[n24 + nArray3[n11]] = n22;
        }
        this.trSort(n24, n13, 1);
        n11 = n12 - 1;
        n22 = n13;
        if ((byArray[n11] & 0xFF) < (byArray[0] & 0xFF) || byArray[n11] == byArray[0] && bl3) {
            if (!bl3) {
                nArray3[nArray3[n24 + --n22]] = n11;
            }
            --n11;
            while (0 <= n11 && (byArray[n11] & 0xFF) <= (byArray[n11 + 1] & 0xFF)) {
                --n11;
            }
        }
        while (0 <= n11) {
            --n11;
            while (0 <= n11 && (byArray[n11] & 0xFF) >= (byArray[n11 + 1] & 0xFF)) {
                --n11;
            }
            if (0 > n11) continue;
            nArray3[nArray3[n24 + --n22]] = n11--;
            while (0 <= n11 && (byArray[n11] & 0xFF) <= (byArray[n11 + 1] & 0xFF)) {
                --n11;
            }
        }
        n11 = n12 - 1;
        int n32 = n13 - 1;
        for (n8 = 255; 0 <= n8; --n8) {
            for (n4 = 255; n8 < n4; --n4) {
                n7 = n11 - nArray2[Bzip2DivSufSort.BUCKET_B(n8, n4)];
                nArray2[Bzip2DivSufSort.BUCKET_B((int)n8, (int)n4)] = n11 + 1;
                n11 = n7;
                n22 = nArray2[Bzip2DivSufSort.BUCKET_BSTAR(n8, n4)];
                while (n22 <= n32) {
                    nArray3[n11] = nArray3[n32];
                    --n11;
                    --n32;
                }
            }
            n7 = n11 - nArray2[Bzip2DivSufSort.BUCKET_B(n8, n8)];
            nArray2[Bzip2DivSufSort.BUCKET_B((int)n8, (int)n8)] = n11 + 1;
            if (n8 < 255) {
                nArray2[Bzip2DivSufSort.BUCKET_BSTAR((int)n8, (int)(n8 + 1))] = n7 + 1;
            }
            n11 = nArray[n8];
        }
        return n13;
    }

    private int constructBWT(int[] nArray, int[] nArray2) {
        int n4;
        int n7;
        int n8;
        int n10;
        byte[] byArray = this.T;
        int[] nArray3 = this.SA;
        int n11 = this.n;
        int n12 = 0;
        int n13 = 0;
        int n14 = -1;
        for (int i3 = 254; 0 <= i3; --i3) {
            n10 = nArray2[Bzip2DivSufSort.BUCKET_BSTAR(i3, i3 + 1)];
            n12 = 0;
            n13 = -1;
            for (int i8 = nArray[i3 + 1]; n10 <= i8; --i8) {
                n7 = n8 = nArray3[i8];
                if (0 <= n8) {
                    if (--n8 < 0) {
                        n8 = n11 - 1;
                    }
                    if ((n4 = byArray[n8] & 0xFF) > i3) continue;
                    nArray3[i8] = ~n7;
                    if (0 < n8 && (byArray[n8 - 1] & 0xFF) > n4) {
                        n8 ^= 0xFFFFFFFF;
                    }
                    if (n13 == n4) {
                        nArray3[--n12] = n8;
                        continue;
                    }
                    if (0 <= n13) {
                        nArray2[Bzip2DivSufSort.BUCKET_B((int)n13, (int)i3)] = n12;
                    }
                    n13 = n4;
                    n12 = nArray2[Bzip2DivSufSort.BUCKET_B(n13, i3)] - 1;
                    nArray3[n12] = n8;
                    continue;
                }
                nArray3[i8] = ~n8;
            }
        }
        for (n10 = 0; n10 < n11; ++n10) {
            n7 = n8 = nArray3[n10];
            if (0 <= n8) {
                if (--n8 < 0) {
                    n8 = n11 - 1;
                }
                if ((n4 = byArray[n8] & 0xFF) >= (byArray[n8 + 1] & 0xFF)) {
                    if (0 < n8 && (byArray[n8 - 1] & 0xFF) < n4) {
                        n8 ^= 0xFFFFFFFF;
                    }
                    if (n4 == n13) {
                        nArray3[++n12] = n8;
                    } else {
                        if (n13 != -1) {
                            nArray[n13] = n12;
                        }
                        n13 = n4;
                        n12 = nArray[n13] + 1;
                        nArray3[n12] = n8;
                    }
                }
            } else {
                n7 ^= 0xFFFFFFFF;
            }
            if (n7 == 0) {
                nArray3[n10] = byArray[n11 - 1];
                n14 = n10;
                continue;
            }
            nArray3[n10] = byArray[n7 - 1];
        }
        return n14;
    }

    public int bwt() {
        int[] nArray = this.SA;
        byte[] byArray = this.T;
        int n4 = this.n;
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[65536];
        if (n4 == 0) {
            return 0;
        }
        if (n4 == 1) {
            nArray[0] = byArray[0];
            return 0;
        }
        int n7 = this.sortTypeBstar(nArray2, nArray3);
        if (0 < n7) {
            return this.constructBWT(nArray2, nArray3);
        }
        return 0;
    }
}

