/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2BitReader;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2BlockDecompressor;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2Decoder$State;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2HuffmanStageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;
import java.util.List;

public class Bzip2Decoder
extends ByteToMessageDecoder {
    private Bzip2Decoder$State currentState = Bzip2Decoder$State.INIT;
    private final Bzip2BitReader reader = new Bzip2BitReader();
    private Bzip2BlockDecompressor blockDecompressor;
    private Bzip2HuffmanStageDecoder huffmanStageDecoder;
    private int blockSize;
    private int blockCRC;
    private int streamCRC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (!byteBuf.isReadable()) {
            return;
        }
        Bzip2BitReader bzip2BitReader = this.reader;
        bzip2BitReader.setByteBuf(byteBuf);
        block15: while (true) {
            switch (this.currentState) {
                case INIT: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    int n4 = byteBuf.readUnsignedMedium();
                    if (n4 != 4348520) {
                        throw new DecompressionException("Unexpected stream identifier contents. Mismatched bzip2 protocol version?");
                    }
                    int n7 = byteBuf.readByte() - 48;
                    if (n7 < 1 || n7 > 9) {
                        throw new DecompressionException("block size is invalid");
                    }
                    this.blockSize = n7 * 100000;
                    this.streamCRC = 0;
                    this.currentState = Bzip2Decoder$State.INIT_BLOCK;
                }
                case INIT_BLOCK: {
                    int n8;
                    if (!bzip2BitReader.hasReadableBytes(10)) {
                        return;
                    }
                    int n10 = bzip2BitReader.readBits(24);
                    int n11 = bzip2BitReader.readBits(24);
                    if (n10 == 1536581 && n11 == 3690640) {
                        n8 = bzip2BitReader.readInt();
                        if (n8 != this.streamCRC) {
                            throw new DecompressionException("stream CRC error");
                        }
                        this.currentState = Bzip2Decoder$State.EOF;
                        continue block15;
                    }
                    if (n10 != 3227993 || n11 != 2511705) {
                        throw new DecompressionException("bad block header");
                    }
                    this.blockCRC = bzip2BitReader.readInt();
                    this.currentState = Bzip2Decoder$State.INIT_BLOCK_PARAMS;
                }
                case INIT_BLOCK_PARAMS: {
                    if (!bzip2BitReader.hasReadableBits(25)) {
                        return;
                    }
                    int n8 = bzip2BitReader.readBoolean();
                    int n12 = bzip2BitReader.readBits(24);
                    this.blockDecompressor = new Bzip2BlockDecompressor(this.blockSize, this.blockCRC, n8 != 0, n12, bzip2BitReader);
                    this.currentState = Bzip2Decoder$State.RECEIVE_HUFFMAN_USED_MAP;
                }
                case RECEIVE_HUFFMAN_USED_MAP: {
                    if (!bzip2BitReader.hasReadableBits(16)) {
                        return;
                    }
                    this.blockDecompressor.huffmanInUse16 = bzip2BitReader.readBits(16);
                    this.currentState = Bzip2Decoder$State.RECEIVE_HUFFMAN_USED_BITMAPS;
                }
                case RECEIVE_HUFFMAN_USED_BITMAPS: {
                    int n13;
                    int n14;
                    int n15;
                    Bzip2BlockDecompressor bzip2BlockDecompressor = this.blockDecompressor;
                    int n16 = bzip2BlockDecompressor.huffmanInUse16;
                    int n17 = Integer.bitCount(n16);
                    byte[] byArray = bzip2BlockDecompressor.huffmanSymbolMap;
                    if (!bzip2BitReader.hasReadableBits(n17 * 16 + 3)) {
                        return;
                    }
                    int n18 = 0;
                    if (n17 > 0) {
                        for (n15 = 0; n15 < 16; ++n15) {
                            if ((n16 & 32768 >>> n15) == 0) continue;
                            n14 = 0;
                            n13 = n15 << 4;
                            while (n14 < 16) {
                                if (bzip2BitReader.readBoolean()) {
                                    byArray[n18++] = (byte)n13;
                                }
                                ++n14;
                                ++n13;
                            }
                        }
                    }
                    bzip2BlockDecompressor.huffmanEndOfBlockSymbol = n18 + 1;
                    n15 = bzip2BitReader.readBits(3);
                    if (n15 < 2 || n15 > 6) {
                        throw new DecompressionException("incorrect huffman groups number");
                    }
                    n14 = n18 + 2;
                    if (n14 > 258) {
                        throw new DecompressionException("incorrect alphabet size");
                    }
                    this.huffmanStageDecoder = new Bzip2HuffmanStageDecoder(bzip2BitReader, n15, n14);
                    this.currentState = Bzip2Decoder$State.RECEIVE_SELECTORS_NUMBER;
                }
                case RECEIVE_SELECTORS_NUMBER: {
                    if (!bzip2BitReader.hasReadableBits(15)) {
                        return;
                    }
                    int n13 = bzip2BitReader.readBits(15);
                    if (n13 < 1 || n13 > 18002) {
                        throw new DecompressionException("incorrect selectors number");
                    }
                    this.huffmanStageDecoder.selectors = new byte[n13];
                    this.currentState = Bzip2Decoder$State.RECEIVE_SELECTORS;
                }
                case RECEIVE_SELECTORS: {
                    Bzip2HuffmanStageDecoder bzip2HuffmanStageDecoder = this.huffmanStageDecoder;
                    byte[] byArray = bzip2HuffmanStageDecoder.selectors;
                    int n13 = byArray.length;
                    Bzip2MoveToFrontTable bzip2MoveToFrontTable = bzip2HuffmanStageDecoder.tableMTF;
                    for (int i3 = bzip2HuffmanStageDecoder.currentSelector; i3 < n13; ++i3) {
                        if (!bzip2BitReader.hasReadableBits(6)) {
                            bzip2HuffmanStageDecoder.currentSelector = i3;
                            return;
                        }
                        int n19 = 0;
                        while (bzip2BitReader.readBoolean()) {
                            ++n19;
                        }
                        byArray[i3] = bzip2MoveToFrontTable.indexToFront(n19);
                    }
                    this.currentState = Bzip2Decoder$State.RECEIVE_HUFFMAN_LENGTH;
                }
                case RECEIVE_HUFFMAN_LENGTH: {
                    int n20;
                    Bzip2HuffmanStageDecoder bzip2HuffmanStageDecoder = this.huffmanStageDecoder;
                    int n15 = bzip2HuffmanStageDecoder.totalTables;
                    byte[][] byArray = bzip2HuffmanStageDecoder.tableCodeLengths;
                    int n14 = bzip2HuffmanStageDecoder.alphabetSize;
                    int n21 = bzip2HuffmanStageDecoder.currentLength;
                    int n22 = 0;
                    boolean bl3 = bzip2HuffmanStageDecoder.modifyLength;
                    boolean bl4 = false;
                    block20: for (n20 = bzip2HuffmanStageDecoder.currentGroup; n20 < n15; ++n20) {
                        if (!bzip2BitReader.hasReadableBits(5)) {
                            bl4 = true;
                            break;
                        }
                        if (n21 < 0) {
                            n21 = bzip2BitReader.readBits(5);
                        }
                        for (n22 = bzip2HuffmanStageDecoder.currentAlpha; n22 < n14; ++n22) {
                            if (!bzip2BitReader.isReadable()) {
                                bl4 = true;
                                break block20;
                            }
                            while (bl3 || bzip2BitReader.readBoolean()) {
                                if (!bzip2BitReader.isReadable()) {
                                    bl3 = true;
                                    bl4 = true;
                                    break block20;
                                }
                                n21 += bzip2BitReader.readBoolean() ? -1 : 1;
                                bl3 = false;
                                if (bzip2BitReader.isReadable()) continue;
                                bl4 = true;
                                break block20;
                            }
                            byArray[n20][n22] = (byte)n21;
                        }
                        n21 = -1;
                        bzip2HuffmanStageDecoder.currentAlpha = 0;
                        n22 = 0;
                        bl3 = false;
                    }
                    if (bl4) {
                        bzip2HuffmanStageDecoder.currentGroup = n20;
                        bzip2HuffmanStageDecoder.currentLength = n21;
                        bzip2HuffmanStageDecoder.currentAlpha = n22;
                        bzip2HuffmanStageDecoder.modifyLength = bl3;
                        return;
                    }
                    bzip2HuffmanStageDecoder.createHuffmanDecodingTables();
                    this.currentState = Bzip2Decoder$State.DECODE_HUFFMAN_DATA;
                }
                case DECODE_HUFFMAN_DATA: {
                    Bzip2BlockDecompressor bzip2BlockDecompressor = this.blockDecompressor;
                    int n23 = byteBuf.readerIndex();
                    boolean bl5 = bzip2BlockDecompressor.decodeHuffmanData(this.huffmanStageDecoder);
                    if (!bl5) {
                        return;
                    }
                    if (byteBuf.readerIndex() == n23 && byteBuf.isReadable()) {
                        bzip2BitReader.refill();
                    }
                    int n24 = bzip2BlockDecompressor.blockLength();
                    ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(n24);
                    boolean bl6 = false;
                    try {
                        int n26;
                        while ((n26 = bzip2BlockDecompressor.read()) >= 0) {
                            byteBuf2.writeByte(n26);
                        }
                        int n27 = bzip2BlockDecompressor.checkCRC();
                        this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ n27;
                        list.add(byteBuf2);
                        bl6 = true;
                    }
                    finally {
                        if (!bl6) {
                            byteBuf2.release();
                        }
                    }
                    this.currentState = Bzip2Decoder$State.INIT_BLOCK;
                    continue block15;
                }
                case EOF: {
                    byteBuf.skipBytes(byteBuf.readableBytes());
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public boolean isClosed() {
        return this.currentState == Bzip2Decoder$State.EOF;
    }
}

