/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2BitReader;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2HuffmanStageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2Rand;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Crc32;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;

final class Bzip2BlockDecompressor {
    private final Bzip2BitReader reader;
    private final Crc32 crc = new Crc32();
    private final int blockCRC;
    private final boolean blockRandomised;
    int huffmanEndOfBlockSymbol;
    int huffmanInUse16;
    final byte[] huffmanSymbolMap = new byte[256];
    private final int[] bwtByteCounts = new int[256];
    private final byte[] bwtBlock;
    private final int bwtStartPointer;
    private int[] bwtMergedPointers;
    private int bwtCurrentMergedPointer;
    private int bwtBlockLength;
    private int bwtBytesDecoded;
    private int rleLastDecodedByte = -1;
    private int rleAccumulator;
    private int rleRepeat;
    private int randomIndex;
    private int randomCount = Bzip2Rand.rNums(0) - 1;
    private final Bzip2MoveToFrontTable symbolMTF = new Bzip2MoveToFrontTable();
    private int repeatCount;
    private int repeatIncrement = 1;
    private int mtfValue;

    Bzip2BlockDecompressor(int n4, int n7, boolean bl3, int n8, Bzip2BitReader bzip2BitReader) {
        this.bwtBlock = new byte[n4];
        this.blockCRC = n7;
        this.blockRandomised = bl3;
        this.bwtStartPointer = n8;
        this.reader = bzip2BitReader;
    }

    boolean decodeHuffmanData(Bzip2HuffmanStageDecoder bzip2HuffmanStageDecoder) {
        Bzip2BitReader bzip2BitReader = this.reader;
        byte[] byArray = this.bwtBlock;
        byte[] byArray2 = this.huffmanSymbolMap;
        int n4 = this.bwtBlock.length;
        int n7 = this.huffmanEndOfBlockSymbol;
        int[] nArray = this.bwtByteCounts;
        Bzip2MoveToFrontTable bzip2MoveToFrontTable = this.symbolMTF;
        int n8 = this.bwtBlockLength;
        int n10 = this.repeatCount;
        int n11 = this.repeatIncrement;
        int n12 = this.mtfValue;
        while (true) {
            byte by2;
            if (!bzip2BitReader.hasReadableBits(23)) {
                this.bwtBlockLength = n8;
                this.repeatCount = n10;
                this.repeatIncrement = n11;
                this.mtfValue = n12;
                return false;
            }
            int n13 = bzip2HuffmanStageDecoder.nextSymbol();
            if (n13 == 0) {
                n10 += n11;
                n11 <<= 1;
                continue;
            }
            if (n13 == 1) {
                n10 += n11 << 1;
                n11 <<= 1;
                continue;
            }
            if (n10 > 0) {
                if (n8 + n10 > n4) {
                    throw new DecompressionException("block exceeds declared block size");
                }
                by2 = byArray2[n12];
                int n14 = by2 & 0xFF;
                nArray[n14] = nArray[n14] + n10;
                while (--n10 >= 0) {
                    byArray[n8++] = by2;
                }
                n10 = 0;
                n11 = 1;
            }
            if (n13 == n7) break;
            if (n8 >= n4) {
                throw new DecompressionException("block exceeds declared block size");
            }
            n12 = bzip2MoveToFrontTable.indexToFront(n13 - 1) & 0xFF;
            by2 = byArray2[n12];
            int n15 = by2 & 0xFF;
            nArray[n15] = nArray[n15] + 1;
            byArray[n8++] = by2;
        }
        this.bwtBlockLength = n8;
        this.initialiseInverseBWT();
        return true;
    }

    private void initialiseInverseBWT() {
        int n4;
        int n7 = this.bwtStartPointer;
        byte[] byArray = this.bwtBlock;
        int[] nArray = new int[this.bwtBlockLength];
        int[] nArray2 = new int[256];
        if (n7 < 0 || n7 >= this.bwtBlockLength) {
            throw new DecompressionException("start pointer invalid");
        }
        System.arraycopy(this.bwtByteCounts, 0, nArray2, 1, 255);
        for (n4 = 2; n4 <= 255; ++n4) {
            int n8 = n4;
            nArray2[n8] = nArray2[n8] + nArray2[n4 - 1];
        }
        for (n4 = 0; n4 < this.bwtBlockLength; ++n4) {
            int n10;
            int n11 = n10 = byArray[n4] & 0xFF;
            int n12 = nArray2[n11];
            nArray2[n11] = n12 + 1;
            nArray[n12] = (n4 << 8) + n10;
        }
        this.bwtMergedPointers = nArray;
        this.bwtCurrentMergedPointer = nArray[n7];
    }

    public int read() {
        while (this.rleRepeat < 1) {
            if (this.bwtBytesDecoded == this.bwtBlockLength) {
                return -1;
            }
            int n4 = this.decodeNextBWTByte();
            if (n4 != this.rleLastDecodedByte) {
                this.rleLastDecodedByte = n4;
                this.rleRepeat = 1;
                this.rleAccumulator = 1;
                this.crc.updateCRC(n4);
                continue;
            }
            if (++this.rleAccumulator == 4) {
                int n7;
                this.rleRepeat = n7 = this.decodeNextBWTByte() + 1;
                this.rleAccumulator = 0;
                this.crc.updateCRC(n4, n7);
                continue;
            }
            this.rleRepeat = 1;
            this.crc.updateCRC(n4);
        }
        --this.rleRepeat;
        return this.rleLastDecodedByte;
    }

    private int decodeNextBWTByte() {
        int n4 = this.bwtCurrentMergedPointer;
        int n7 = n4 & 0xFF;
        this.bwtCurrentMergedPointer = this.bwtMergedPointers[n4 >>> 8];
        if (this.blockRandomised && --this.randomCount == 0) {
            n7 ^= 1;
            this.randomIndex = (this.randomIndex + 1) % 512;
            this.randomCount = Bzip2Rand.rNums(this.randomIndex);
        }
        ++this.bwtBytesDecoded;
        return n7;
    }

    public int blockLength() {
        return this.bwtBlockLength;
    }

    int checkCRC() {
        int n4 = this.crc.getCRC();
        if (this.blockCRC != n4) {
            throw new DecompressionException("block CRC error");
        }
        return n4;
    }
}

