/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2BitWriter;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2BlockCompressor$1;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2DivSufSort;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2HuffmanStageEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Bzip2MTFAndRLE2StageEncoder;
import io.grpc.netty.shaded.io.netty.handler.codec.compression.Crc32;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;

final class Bzip2BlockCompressor {
    private final ByteProcessor writeProcessor = new Bzip2BlockCompressor$1(this);
    private final Bzip2BitWriter writer;
    private final Crc32 crc = new Crc32();
    private final byte[] block;
    private int blockLength;
    private final int blockLengthLimit;
    private final boolean[] blockValuesPresent = new boolean[256];
    private final int[] bwtBlock;
    private int rleCurrentValue = -1;
    private int rleLength;

    Bzip2BlockCompressor(Bzip2BitWriter bzip2BitWriter, int n4) {
        this.writer = bzip2BitWriter;
        this.block = new byte[n4 + 1];
        this.bwtBlock = new int[n4 + 1];
        this.blockLengthLimit = n4 - 6;
    }

    private void writeSymbolMap(ByteBuf byteBuf) {
        int n4;
        int n7;
        Bzip2BitWriter bzip2BitWriter = this.writer;
        boolean[] blArray = this.blockValuesPresent;
        boolean[] blArray2 = new boolean[16];
        for (int i3 = 0; i3 < blArray2.length; ++i3) {
            n7 = 0;
            n4 = i3 << 4;
            while (n7 < 16) {
                if (blArray[n4]) {
                    blArray2[i3] = true;
                }
                ++n7;
                ++n4;
            }
        }
        for (boolean bl3 : blArray2) {
            bzip2BitWriter.writeBoolean(byteBuf, bl3);
        }
        for (int i8 = 0; i8 < blArray2.length; ++i8) {
            if (!blArray2[i8]) continue;
            n7 = 0;
            n4 = i8 << 4;
            while (n7 < 16) {
                bzip2BitWriter.writeBoolean(byteBuf, blArray[n4]);
                ++n7;
                ++n4;
            }
        }
    }

    private void writeRun(int n4, int n7) {
        int n8 = this.blockLength;
        byte[] byArray = this.block;
        this.blockValuesPresent[n4] = true;
        this.crc.updateCRC(n4, n7);
        byte by2 = (byte)n4;
        switch (n7) {
            case 1: {
                byArray[n8] = by2;
                this.blockLength = n8 + 1;
                break;
            }
            case 2: {
                byArray[n8] = by2;
                byArray[n8 + 1] = by2;
                this.blockLength = n8 + 2;
                break;
            }
            case 3: {
                byArray[n8] = by2;
                byArray[n8 + 1] = by2;
                byArray[n8 + 2] = by2;
                this.blockLength = n8 + 3;
                break;
            }
            default: {
                this.blockValuesPresent[n7 -= 4] = true;
                byArray[n8] = by2;
                byArray[n8 + 1] = by2;
                byArray[n8 + 2] = by2;
                byArray[n8 + 3] = by2;
                byArray[n8 + 4] = (byte)n7;
                this.blockLength = n8 + 5;
            }
        }
    }

    boolean write(int n4) {
        if (this.blockLength > this.blockLengthLimit) {
            return false;
        }
        int n7 = this.rleCurrentValue;
        int n8 = this.rleLength;
        if (n8 == 0) {
            this.rleCurrentValue = n4;
            this.rleLength = 1;
        } else if (n7 != n4) {
            this.writeRun(n7 & 0xFF, n8);
            this.rleCurrentValue = n4;
            this.rleLength = 1;
        } else if (n8 == 254) {
            this.writeRun(n7 & 0xFF, 255);
            this.rleLength = 0;
        } else {
            this.rleLength = n8 + 1;
        }
        return true;
    }

    int write(ByteBuf byteBuf, int n4, int n7) {
        int n8 = byteBuf.forEachByte(n4, n7, this.writeProcessor);
        return n8 == -1 ? n7 : n8 - n4;
    }

    void close(ByteBuf byteBuf) {
        if (this.rleLength > 0) {
            this.writeRun(this.rleCurrentValue & 0xFF, this.rleLength);
        }
        this.block[this.blockLength] = this.block[0];
        Bzip2DivSufSort bzip2DivSufSort = new Bzip2DivSufSort(this.block, this.bwtBlock, this.blockLength);
        int n4 = bzip2DivSufSort.bwt();
        Bzip2BitWriter bzip2BitWriter = this.writer;
        bzip2BitWriter.writeBits(byteBuf, 24, 3227993L);
        bzip2BitWriter.writeBits(byteBuf, 24, 2511705L);
        bzip2BitWriter.writeInt(byteBuf, this.crc.getCRC());
        bzip2BitWriter.writeBoolean(byteBuf, false);
        bzip2BitWriter.writeBits(byteBuf, 24, n4);
        this.writeSymbolMap(byteBuf);
        Bzip2MTFAndRLE2StageEncoder bzip2MTFAndRLE2StageEncoder = new Bzip2MTFAndRLE2StageEncoder(this.bwtBlock, this.blockLength, this.blockValuesPresent);
        bzip2MTFAndRLE2StageEncoder.encode();
        Bzip2HuffmanStageEncoder bzip2HuffmanStageEncoder = new Bzip2HuffmanStageEncoder(bzip2BitWriter, bzip2MTFAndRLE2StageEncoder.mtfBlock(), bzip2MTFAndRLE2StageEncoder.mtfLength(), bzip2MTFAndRLE2StageEncoder.mtfAlphabetSize(), bzip2MTFAndRLE2StageEncoder.mtfSymbolFrequencies());
        bzip2HuffmanStageEncoder.encode(byteBuf);
    }

    int availableSize() {
        if (this.blockLength == 0) {
            return this.blockLengthLimit + 2;
        }
        return this.blockLengthLimit - this.blockLength + 1;
    }

    boolean isFull() {
        return this.blockLength > this.blockLengthLimit;
    }

    boolean isEmpty() {
        return this.blockLength == 0 && this.rleLength == 0;
    }

    int crc() {
        return this.crc.getCRC();
    }
}

