/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;

final class Bzip2BitWriter {
    private long bitBuffer;
    private int bitCount;

    Bzip2BitWriter() {
    }

    void writeBits(ByteBuf byteBuf, int n4, long l2) {
        if (n4 < 0 || n4 > 32) {
            throw new IllegalArgumentException("count: " + n4 + " (expected: 0-32)");
        }
        int n7 = this.bitCount;
        long l10 = this.bitBuffer | l2 << 64 - n4 >>> n7;
        if ((n7 += n4) >= 32) {
            byteBuf.writeInt((int)(l10 >>> 32));
            l10 <<= 32;
            n7 -= 32;
        }
        this.bitBuffer = l10;
        this.bitCount = n7;
    }

    void writeBoolean(ByteBuf byteBuf, boolean bl3) {
        int n4 = this.bitCount + 1;
        long l2 = this.bitBuffer | (bl3 ? 1L << 64 - n4 : 0L);
        if (n4 == 32) {
            byteBuf.writeInt((int)(l2 >>> 32));
            l2 = 0L;
            n4 = 0;
        }
        this.bitBuffer = l2;
        this.bitCount = n4;
    }

    void writeUnary(ByteBuf byteBuf, int n4) {
        if (n4 < 0) {
            throw new IllegalArgumentException("value: " + n4 + " (expected 0 or more)");
        }
        while (n4-- > 0) {
            this.writeBoolean(byteBuf, true);
        }
        this.writeBoolean(byteBuf, false);
    }

    void writeInt(ByteBuf byteBuf, int n4) {
        this.writeBits(byteBuf, 32, n4);
    }

    void flush(ByteBuf byteBuf) {
        int n4 = this.bitCount;
        if (n4 > 0) {
            long l2 = this.bitBuffer;
            int n7 = 64 - n4;
            if (n4 <= 8) {
                byteBuf.writeByte((int)(l2 >>> n7 << 8 - n4));
            } else if (n4 <= 16) {
                byteBuf.writeShort((int)(l2 >>> n7 << 16 - n4));
            } else if (n4 <= 24) {
                byteBuf.writeMedium((int)(l2 >>> n7 << 24 - n4));
            } else {
                byteBuf.writeInt((int)(l2 >>> n7 << 32 - n4));
            }
        }
    }
}

