/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.compression;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;

class Bzip2BitReader {
    private static final int MAX_COUNT_OF_READABLE_BYTES = 0xFFFFFFF;
    private ByteBuf in;
    private long bitBuffer;
    private int bitCount;

    Bzip2BitReader() {
    }

    void setByteBuf(ByteBuf byteBuf) {
        this.in = byteBuf;
    }

    int readBits(int n4) {
        if (n4 < 0 || n4 > 32) {
            throw new IllegalArgumentException("count: " + n4 + " (expected: 0-32 )");
        }
        int n7 = this.bitCount;
        long l2 = this.bitBuffer;
        if (n7 < n4) {
            int n8;
            long l10;
            switch (this.in.readableBytes()) {
                case 1: {
                    l10 = this.in.readUnsignedByte();
                    n8 = 8;
                    break;
                }
                case 2: {
                    l10 = this.in.readUnsignedShort();
                    n8 = 16;
                    break;
                }
                case 3: {
                    l10 = this.in.readUnsignedMedium();
                    n8 = 24;
                    break;
                }
                default: {
                    l10 = this.in.readUnsignedInt();
                    n8 = 32;
                }
            }
            l2 = l2 << n8 | l10;
            n7 += n8;
            this.bitBuffer = l2;
        }
        this.bitCount = n7 -= n4;
        return (int)(l2 >>> n7 & (n4 != 32 ? (long)((1 << n4) - 1) : 0xFFFFFFFFL));
    }

    boolean readBoolean() {
        return this.readBits(1) != 0;
    }

    int readInt() {
        return this.readBits(32);
    }

    void refill() {
        short s11 = this.in.readUnsignedByte();
        this.bitBuffer = this.bitBuffer << 8 | (long)s11;
        this.bitCount += 8;
    }

    boolean isReadable() {
        return this.bitCount > 0 || this.in.isReadable();
    }

    boolean hasReadableBits(int n4) {
        if (n4 < 0) {
            throw new IllegalArgumentException("count: " + n4 + " (expected value greater than 0)");
        }
        return this.bitCount >= n4 || (this.in.readableBytes() << 3 & Integer.MAX_VALUE) >= n4 - this.bitCount;
    }

    boolean hasReadableBytes(int n4) {
        if (n4 < 0 || n4 > 0xFFFFFFF) {
            throw new IllegalArgumentException("count: " + n4 + " (expected: 0-" + 0xFFFFFFF + ')');
        }
        return this.hasReadableBits(n4 << 3);
    }
}

