/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec.base64;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64$Decoder;
import io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64Dialect;
import java.nio.ByteOrder;

public final class Base64 {
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private static byte[] alphabet(Base64Dialect base64Dialect) {
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return base64Dialect.alphabet;
    }

    private static byte[] decodabet(Base64Dialect base64Dialect) {
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return base64Dialect.decodabet;
    }

    private static boolean breakLines(Base64Dialect base64Dialect) {
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return base64Dialect.breakLinesByDefault;
    }

    public static ByteBuf encode(ByteBuf byteBuf) {
        return Base64.encode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, Base64.breakLines(base64Dialect), base64Dialect);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl3) {
        return Base64.encode(byteBuf, bl3, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl3, Base64Dialect base64Dialect) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        ByteBuf byteBuf2 = Base64.encode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), bl3, base64Dialect);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n4, int n7) {
        return Base64.encode(byteBuf, n4, n7, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n4, int n7, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, n4, n7, Base64.breakLines(base64Dialect), base64Dialect);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n4, int n7, boolean bl3) {
        return Base64.encode(byteBuf, n4, n7, bl3, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n4, int n7, boolean bl3, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, n4, n7, bl3, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n4, int n7, boolean bl3, Base64Dialect base64Dialect, ByteBufAllocator byteBufAllocator) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        ByteBuf byteBuf2 = byteBufAllocator.buffer(Base64.encodedBufferSize(n7, bl3)).order(byteBuf.order());
        byte[] byArray = Base64.alphabet(base64Dialect);
        int n8 = 0;
        int n10 = 0;
        int n11 = n7 - 2;
        int n12 = 0;
        while (n8 < n11) {
            Base64.encode3to4(byteBuf, n8 + n4, 3, byteBuf2, n10, byArray);
            if (bl3 && (n12 += 4) == 76) {
                byteBuf2.setByte(n10 + 4, 10);
                ++n10;
                n12 = 0;
            }
            n8 += 3;
            n10 += 4;
        }
        if (n8 < n7) {
            Base64.encode3to4(byteBuf, n8 + n4, n7 - n8, byteBuf2, n10, byArray);
            n10 += 4;
        }
        if (n10 > 1 && byteBuf2.getByte(n10 - 1) == 10) {
            --n10;
        }
        return byteBuf2.slice(0, n10);
    }

    private static void encode3to4(ByteBuf byteBuf, int n4, int n7, ByteBuf byteBuf2, int n8, byte[] byArray) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            int n10;
            switch (n7) {
                case 1: {
                    n10 = Base64.toInt(byteBuf.getByte(n4));
                    break;
                }
                case 2: {
                    n10 = Base64.toIntBE(byteBuf.getShort(n4));
                    break;
                }
                default: {
                    n10 = n7 <= 0 ? 0 : Base64.toIntBE(byteBuf.getMedium(n4));
                }
            }
            Base64.encode3to4BigEndian(n10, n7, byteBuf2, n8, byArray);
        } else {
            int n11;
            switch (n7) {
                case 1: {
                    n11 = Base64.toInt(byteBuf.getByte(n4));
                    break;
                }
                case 2: {
                    n11 = Base64.toIntLE(byteBuf.getShort(n4));
                    break;
                }
                default: {
                    n11 = n7 <= 0 ? 0 : Base64.toIntLE(byteBuf.getMedium(n4));
                }
            }
            Base64.encode3to4LittleEndian(n11, n7, byteBuf2, n8, byArray);
        }
    }

    static int encodedBufferSize(int n4, boolean bl3) {
        long l2 = ((long)n4 << 2) / 3L;
        long l10 = l2 + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (bl3) {
            l10 += l2 / 76L;
        }
        return l10 < Integer.MAX_VALUE ? (int)l10 : Integer.MAX_VALUE;
    }

    private static int toInt(byte by2) {
        return (by2 & 0xFF) << 16;
    }

    private static int toIntBE(short s11) {
        return (s11 & 0xFF00) << 8 | (s11 & 0xFF) << 8;
    }

    private static int toIntLE(short s11) {
        return (s11 & 0xFF) << 16 | s11 & 0xFF00;
    }

    private static int toIntBE(int n4) {
        return n4 & 0xFF0000 | n4 & 0xFF00 | n4 & 0xFF;
    }

    private static int toIntLE(int n4) {
        return (n4 & 0xFF) << 16 | n4 & 0xFF00 | (n4 & 0xFF0000) >>> 16;
    }

    private static void encode3to4BigEndian(int n4, int n7, ByteBuf byteBuf, int n8, byte[] byArray) {
        switch (n7) {
            case 3: {
                byteBuf.setInt(n8, byArray[n4 >>> 18] << 24 | byArray[n4 >>> 12 & 0x3F] << 16 | byArray[n4 >>> 6 & 0x3F] << 8 | byArray[n4 & 0x3F]);
                break;
            }
            case 2: {
                byteBuf.setInt(n8, byArray[n4 >>> 18] << 24 | byArray[n4 >>> 12 & 0x3F] << 16 | byArray[n4 >>> 6 & 0x3F] << 8 | 0x3D);
                break;
            }
            case 1: {
                byteBuf.setInt(n8, byArray[n4 >>> 18] << 24 | byArray[n4 >>> 12 & 0x3F] << 16 | 0x3D00 | 0x3D);
                break;
            }
        }
    }

    private static void encode3to4LittleEndian(int n4, int n7, ByteBuf byteBuf, int n8, byte[] byArray) {
        switch (n7) {
            case 3: {
                byteBuf.setInt(n8, byArray[n4 >>> 18] | byArray[n4 >>> 12 & 0x3F] << 8 | byArray[n4 >>> 6 & 0x3F] << 16 | byArray[n4 & 0x3F] << 24);
                break;
            }
            case 2: {
                byteBuf.setInt(n8, byArray[n4 >>> 18] | byArray[n4 >>> 12 & 0x3F] << 8 | byArray[n4 >>> 6 & 0x3F] << 16 | 0x3D000000);
                break;
            }
            case 1: {
                byteBuf.setInt(n8, byArray[n4 >>> 18] | byArray[n4 >>> 12 & 0x3F] << 8 | 0x3D0000 | 0x3D000000);
                break;
            }
        }
    }

    public static ByteBuf decode(ByteBuf byteBuf) {
        return Base64.decode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf decode(ByteBuf byteBuf, Base64Dialect base64Dialect) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        ByteBuf byteBuf2 = Base64.decode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), base64Dialect);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n4, int n7) {
        return Base64.decode(byteBuf, n4, n7, Base64Dialect.STANDARD);
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n4, int n7, Base64Dialect base64Dialect) {
        return Base64.decode(byteBuf, n4, n7, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n4, int n7, Base64Dialect base64Dialect, ByteBufAllocator byteBufAllocator) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return new Base64$Decoder(null).decode(byteBuf, n4, n7, byteBufAllocator, base64Dialect);
    }

    static int decodedBufferSize(int n4) {
        return n4 - (n4 >>> 2);
    }

    private Base64() {
    }

    static /* synthetic */ byte[] access$100(Base64Dialect base64Dialect) {
        return Base64.decodabet(base64Dialect);
    }
}

