/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.buffer.SwappedByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoder;
import io.grpc.netty.shaded.io.netty.util.ByteProcessor;
import io.grpc.netty.shaded.io.netty.util.Signal;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class ReplayingDecoderByteBuf
extends ByteBuf {
    private static final Signal REPLAY = ReplayingDecoder.REPLAY;
    private ByteBuf buffer;
    private boolean terminated;
    private SwappedByteBuf swapped;
    static final ReplayingDecoderByteBuf EMPTY_BUFFER = new ReplayingDecoderByteBuf(Unpooled.EMPTY_BUFFER);

    ReplayingDecoderByteBuf() {
    }

    ReplayingDecoderByteBuf(ByteBuf byteBuf) {
        this.setCumulation(byteBuf);
    }

    void setCumulation(ByteBuf byteBuf) {
        this.buffer = byteBuf;
    }

    void terminate() {
        this.terminated = true;
    }

    @Override
    public int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public ByteBuf capacity(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int maxCapacity() {
        return this.capacity();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf clear() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf copy() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf copy(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this.buffer.copy(n4, n7);
    }

    @Override
    public ByteBuf discardReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf ensureWritable(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int ensureWritable(int n4, boolean bl3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf duplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf retainedDuplicate() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public boolean getBoolean(int n4) {
        this.checkIndex(n4, 1);
        return this.buffer.getBoolean(n4);
    }

    @Override
    public byte getByte(int n4) {
        this.checkIndex(n4, 1);
        return this.buffer.getByte(n4);
    }

    @Override
    public short getUnsignedByte(int n4) {
        this.checkIndex(n4, 1);
        return this.buffer.getUnsignedByte(n4);
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray, int n7, int n8) {
        this.checkIndex(n4, n8);
        this.buffer.getBytes(n4, byArray, n7, n8);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, byte[] byArray) {
        this.checkIndex(n4, byArray.length);
        this.buffer.getBytes(n4, byArray);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        this.checkIndex(n4, n8);
        this.buffer.getBytes(n4, byteBuf, n7, n8);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf getBytes(int n4, ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int getBytes(int n4, GatheringByteChannel gatheringByteChannel, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int getBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf getBytes(int n4, OutputStream outputStream, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int getInt(int n4) {
        this.checkIndex(n4, 4);
        return this.buffer.getInt(n4);
    }

    @Override
    public int getIntLE(int n4) {
        this.checkIndex(n4, 4);
        return this.buffer.getIntLE(n4);
    }

    @Override
    public long getUnsignedInt(int n4) {
        this.checkIndex(n4, 4);
        return this.buffer.getUnsignedInt(n4);
    }

    @Override
    public long getUnsignedIntLE(int n4) {
        this.checkIndex(n4, 4);
        return this.buffer.getUnsignedIntLE(n4);
    }

    @Override
    public long getLong(int n4) {
        this.checkIndex(n4, 8);
        return this.buffer.getLong(n4);
    }

    @Override
    public long getLongLE(int n4) {
        this.checkIndex(n4, 8);
        return this.buffer.getLongLE(n4);
    }

    @Override
    public int getMedium(int n4) {
        this.checkIndex(n4, 3);
        return this.buffer.getMedium(n4);
    }

    @Override
    public int getMediumLE(int n4) {
        this.checkIndex(n4, 3);
        return this.buffer.getMediumLE(n4);
    }

    @Override
    public int getUnsignedMedium(int n4) {
        this.checkIndex(n4, 3);
        return this.buffer.getUnsignedMedium(n4);
    }

    @Override
    public int getUnsignedMediumLE(int n4) {
        this.checkIndex(n4, 3);
        return this.buffer.getUnsignedMediumLE(n4);
    }

    @Override
    public short getShort(int n4) {
        this.checkIndex(n4, 2);
        return this.buffer.getShort(n4);
    }

    @Override
    public short getShortLE(int n4) {
        this.checkIndex(n4, 2);
        return this.buffer.getShortLE(n4);
    }

    @Override
    public int getUnsignedShort(int n4) {
        this.checkIndex(n4, 2);
        return this.buffer.getUnsignedShort(n4);
    }

    @Override
    public int getUnsignedShortLE(int n4) {
        this.checkIndex(n4, 2);
        return this.buffer.getUnsignedShortLE(n4);
    }

    @Override
    public char getChar(int n4) {
        this.checkIndex(n4, 2);
        return this.buffer.getChar(n4);
    }

    @Override
    public float getFloat(int n4) {
        this.checkIndex(n4, 4);
        return this.buffer.getFloat(n4);
    }

    @Override
    public double getDouble(int n4) {
        this.checkIndex(n4, 8);
        return this.buffer.getDouble(n4);
    }

    @Override
    public CharSequence getCharSequence(int n4, int n7, Charset charset) {
        this.checkIndex(n4, n7);
        return this.buffer.getCharSequence(n4, n7, charset);
    }

    @Override
    public int hashCode() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int indexOf(int n4, int n7, byte by2) {
        if (n4 == n7) {
            return -1;
        }
        if (Math.max(n4, n7) > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.indexOf(n4, n7, by2);
    }

    @Override
    public int bytesBefore(byte by2) {
        int n4 = this.buffer.bytesBefore(by2);
        if (n4 < 0) {
            throw REPLAY;
        }
        return n4;
    }

    @Override
    public int bytesBefore(int n4, byte by2) {
        return this.bytesBefore(this.buffer.readerIndex(), n4, by2);
    }

    @Override
    public int bytesBefore(int n4, int n7, byte by2) {
        int n8 = this.buffer.writerIndex();
        if (n4 >= n8) {
            throw REPLAY;
        }
        if (n4 <= n8 - n7) {
            return this.buffer.bytesBefore(n4, n7, by2);
        }
        int n10 = this.buffer.bytesBefore(n4, n8 - n4, by2);
        if (n10 < 0) {
            throw REPLAY;
        }
        return n10;
    }

    @Override
    public int forEachByte(ByteProcessor byteProcessor) {
        int n4 = this.buffer.forEachByte(byteProcessor);
        if (n4 < 0) {
            throw REPLAY;
        }
        return n4;
    }

    @Override
    public int forEachByte(int n4, int n7, ByteProcessor byteProcessor) {
        int n8 = this.buffer.writerIndex();
        if (n4 >= n8) {
            throw REPLAY;
        }
        if (n4 <= n8 - n7) {
            return this.buffer.forEachByte(n4, n7, byteProcessor);
        }
        int n10 = this.buffer.forEachByte(n4, n8 - n4, byteProcessor);
        if (n10 < 0) {
            throw REPLAY;
        }
        return n10;
    }

    @Override
    public int forEachByteDesc(ByteProcessor byteProcessor) {
        if (this.terminated) {
            return this.buffer.forEachByteDesc(byteProcessor);
        }
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int forEachByteDesc(int n4, int n7, ByteProcessor byteProcessor) {
        if (n4 + n7 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.forEachByteDesc(n4, n7, byteProcessor);
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.buffer.markReaderIndex();
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            throw new NullPointerException("endianness");
        }
        if (byteOrder == this.order()) {
            return this;
        }
        SwappedByteBuf swappedByteBuf = this.swapped;
        if (swappedByteBuf == null) {
            this.swapped = swappedByteBuf = new SwappedByteBuf(this);
        }
        return swappedByteBuf;
    }

    @Override
    public boolean isReadable() {
        return !this.terminated || this.buffer.isReadable();
    }

    @Override
    public boolean isReadable(int n4) {
        return !this.terminated || this.buffer.isReadable(n4);
    }

    @Override
    public int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    @Override
    public boolean readBoolean() {
        this.checkReadableBytes(1);
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    @Override
    public short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n4, int n7) {
        this.checkReadableBytes(n7);
        this.buffer.readBytes(byArray, n4, n7);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        this.checkReadableBytes(byArray.length);
        this.buffer.readBytes(byArray);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n4, int n7) {
        this.checkReadableBytes(n7);
        this.buffer.readBytes(byteBuf, n4, n7);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        this.checkReadableBytes(byteBuf.writableBytes());
        this.buffer.readBytes(byteBuf);
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf readBytes(int n4) {
        this.checkReadableBytes(n4);
        return this.buffer.readBytes(n4);
    }

    @Override
    public ByteBuf readSlice(int n4) {
        this.checkReadableBytes(n4);
        return this.buffer.readSlice(n4);
    }

    @Override
    public ByteBuf readRetainedSlice(int n4) {
        this.checkReadableBytes(n4);
        return this.buffer.readRetainedSlice(n4);
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public ByteBuf readerIndex(int n4) {
        this.buffer.readerIndex(n4);
        return this;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readIntLE();
    }

    @Override
    public long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    @Override
    public long readUnsignedIntLE() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedIntLE();
    }

    @Override
    public long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLE() {
        this.checkReadableBytes(8);
        return this.buffer.readLongLE();
    }

    @Override
    public int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    @Override
    public int readMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readMediumLE();
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public int readUnsignedMediumLE() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMediumLE();
    }

    @Override
    public short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readShortLE();
    }

    @Override
    public int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    @Override
    public int readUnsignedShortLE() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShortLE();
    }

    @Override
    public char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    @Override
    public float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    @Override
    public CharSequence readCharSequence(int n4, Charset charset) {
        this.checkReadableBytes(n4);
        return this.buffer.readCharSequence(n4, charset);
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.buffer.resetReaderIndex();
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBoolean(int n4, boolean bl3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setByte(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray, int n7, int n8) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n4, byte[] byArray) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7, int n8) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setBytes(int n4, ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setBytes(int n4, InputStream inputStream, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setZero(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setBytes(int n4, ScatteringByteChannel scatteringByteChannel, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setBytes(int n4, FileChannel fileChannel, long l2, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setIndex(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setInt(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setIntLE(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setLong(int n4, long l2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setLongLE(int n4, long l2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setMedium(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setMediumLE(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setShort(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setShortLE(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setChar(int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setFloat(int n4, float f8) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf setDouble(int n4, double d8) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf skipBytes(int n4) {
        this.checkReadableBytes(n4);
        this.buffer.skipBytes(n4);
        return this;
    }

    @Override
    public ByteBuf slice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf retainedSlice() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf slice(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this.buffer.slice(n4, n7);
    }

    @Override
    public ByteBuf retainedSlice(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this.buffer.slice(n4, n7);
    }

    @Override
    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuffer nioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this.buffer.nioBuffer(n4, n7);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuffer[] nioBuffers(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this.buffer.nioBuffers(n4, n7);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n4, int n7) {
        this.checkIndex(n4, n7);
        return this.buffer.internalNioBuffer(n4, n7);
    }

    @Override
    public String toString(int n4, int n7, Charset charset) {
        this.checkIndex(n4, n7);
        return this.buffer.toString(n4, n7, charset);
    }

    @Override
    public String toString(Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + "ridx=" + this.readerIndex() + ", widx=" + this.writerIndex() + ')';
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int n4) {
        return false;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public int maxWritableBytes() {
        return 0;
    }

    @Override
    public ByteBuf writeBoolean(boolean bl3) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeByte(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n4, int n7) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeBytes(InputStream inputStream, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeBytes(FileChannel fileChannel, long l2, int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeInt(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeIntLE(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeLong(long l2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeLongLE(long l2) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeMedium(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeMediumLE(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeZero(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public ByteBuf writerIndex(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeShort(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeShortLE(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeChar(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeFloat(float f8) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf writeDouble(double d8) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int setCharSequence(int n4, CharSequence charSequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        throw ReplayingDecoderByteBuf.reject();
    }

    private void checkIndex(int n4, int n7) {
        if (n4 + n7 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int n4) {
        if (this.buffer.readableBytes() < n4) {
            throw REPLAY;
        }
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public int refCnt() {
        return this.buffer.refCnt();
    }

    @Override
    public ByteBuf retain() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf retain(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf touch() {
        this.buffer.touch();
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        this.buffer.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public boolean release(int n4) {
        throw ReplayingDecoderByteBuf.reject();
    }

    @Override
    public ByteBuf unwrap() {
        throw ReplayingDecoderByteBuf.reject();
    }

    private static UnsupportedOperationException reject() {
        return new UnsupportedOperationException("not a replayable operation");
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

