/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.handler.codec;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.codec.DecoderException;
import io.grpc.netty.shaded.io.netty.handler.codec.ReplayingDecoderByteBuf;
import io.grpc.netty.shaded.io.netty.util.Signal;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.util.List;

public abstract class ReplayingDecoder<S>
extends ByteToMessageDecoder {
    static final Signal REPLAY = Signal.valueOf(ReplayingDecoder.class, "REPLAY");
    private final ReplayingDecoderByteBuf replayable = new ReplayingDecoderByteBuf();
    private S state;
    private int checkpoint = -1;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(S s11) {
        this.state = s11;
    }

    protected void checkpoint() {
        this.checkpoint = this.internalBuffer().readerIndex();
    }

    protected void checkpoint(S s11) {
        this.checkpoint();
        this.state(s11);
    }

    protected S state() {
        return this.state;
    }

    protected S state(S s11) {
        S s12 = this.state;
        this.state = s11;
        return s12;
    }

    @Override
    final void channelInputClosed(ChannelHandlerContext channelHandlerContext, List<Object> list) {
        try {
            this.replayable.terminate();
            if (this.cumulation != null) {
                this.callDecode(channelHandlerContext, this.internalBuffer(), list);
            } else {
                this.replayable.setCumulation(Unpooled.EMPTY_BUFFER);
            }
            this.decodeLast(channelHandlerContext, this.replayable, list);
        }
        catch (Signal signal) {
            signal.expect(REPLAY);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void callDecode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.replayable.setCumulation(byteBuf);
        try {
            while (byteBuf.isReadable()) {
                int n4 = this.checkpoint = byteBuf.readerIndex();
                int n7 = list.size();
                if (n7 > 0) {
                    ReplayingDecoder.fireChannelRead(channelHandlerContext, list, n7);
                    list.clear();
                    if (channelHandlerContext.isRemoved()) {
                        return;
                    }
                    n7 = 0;
                }
                S s11 = this.state;
                int n8 = byteBuf.readableBytes();
                try {
                    this.decodeRemovalReentryProtection(channelHandlerContext, this.replayable, list);
                    if (channelHandlerContext.isRemoved()) {
                        return;
                    }
                    if (n7 == list.size()) {
                        if (n8 != byteBuf.readableBytes() || s11 != this.state) continue;
                        throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() must consume the inbound data or change its state if it did not decode anything.");
                    }
                }
                catch (Signal signal) {
                    signal.expect(REPLAY);
                    if (channelHandlerContext.isRemoved()) {
                        return;
                    }
                    int n10 = this.checkpoint;
                    if (n10 < 0) return;
                    byteBuf.readerIndex(n10);
                    return;
                }
                if (n4 == byteBuf.readerIndex() && s11 == this.state) {
                    throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() method must consume the inbound data or change its state if it decoded something.");
                }
                if (this.isSingleDecode()) return;
            }
            return;
        }
        catch (DecoderException decoderException) {
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
    }
}

